/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.adapter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import paper.libs.org.eclipse.core.internal.registry.Handle;
import paper.libs.org.eclipse.core.internal.registry.RegistryMessages;
import paper.libs.org.eclipse.core.internal.registry.osgi.EquinoxUtils;
import paper.libs.org.eclipse.core.internal.runtime.IAdapterFactoryExt;
import paper.libs.org.eclipse.core.internal.runtime.RuntimeLog;
import paper.libs.org.eclipse.core.runtime.IAdapterFactory;
import paper.libs.org.eclipse.core.runtime.IConfigurationElement;
import paper.libs.org.eclipse.core.runtime.IExtension;
import paper.libs.org.eclipse.core.runtime.Status;
import paper.libs.org.eclipse.osgi.util.NLS;

class AdapterFactoryProxy
implements IAdapterFactory,
IAdapterFactoryExt {
    private String adaptableType;
    private String[] adapterNames;
    private String contributorName;
    private IExtension declaringExtension;
    private Optional<IAdapterFactory> factory;
    private Callable<IAdapterFactory> factoryLoader;
    private String ownerId;
    private int internalOwnerId = -1;

    AdapterFactoryProxy() {
    }

    public static AdapterFactoryProxy createProxy(IConfigurationElement element) {
        AdapterFactoryProxy result = new AdapterFactoryProxy();
        result.contributorName = element.getContributor().getName();
        if (!"factory".equals(element.getName())) {
            result.logError();
            return null;
        }
        result.adaptableType = element.getAttribute("adaptableType");
        if (result.adaptableType == null) {
            result.logError();
            return null;
        }
        result.adapterNames = (String[])Arrays.stream(element.getChildren()).filter(child -> "adapter".equals(child.getName())).map(child -> child.getAttribute("type")).filter(Objects::nonNull).toArray(String[]::new);
        if (result.adapterNames.length == 0) {
            result.logError();
            return null;
        }
        result.declaringExtension = element.getDeclaringExtension();
        result.ownerId = result.declaringExtension.getUniqueIdentifier();
        if (result.declaringExtension instanceof Handle) {
            result.internalOwnerId = ((Handle)((Object)result.declaringExtension)).getId();
        }
        result.factoryLoader = () -> (IAdapterFactory)element.createExecutableExtension("class");
        return result;
    }

    public boolean originatesFrom(IExtension extension) {
        String id = extension.getUniqueIdentifier();
        if (id != null) {
            return id.equals(this.ownerId);
        }
        if (!(extension instanceof Handle)) {
            return false;
        }
        return this.internalOwnerId == ((Handle)((Object)extension)).getId();
    }

    String getAdaptableType() {
        return this.adaptableType;
    }

    @Override
    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        Optional<IAdapterFactory> adapterFactory = this.factory;
        if (adapterFactory == null) {
            adapterFactory = Optional.ofNullable(this.loadFactory(false));
        }
        return adapterFactory.map(f -> f.getAdapter(adaptableObject, adapterType)).orElse(null);
    }

    @Override
    public Class<?>[] getAdapterList() {
        Optional<IAdapterFactory> adapterFactory = this.factory;
        if (adapterFactory == null) {
            adapterFactory = Optional.ofNullable(this.loadFactory(false));
        }
        return adapterFactory.map(f -> f.getAdapterList()).orElse(null);
    }

    @Override
    public String[] getAdapterNames() {
        return this.adapterNames;
    }

    IExtension getExtension() {
        return this.declaringExtension;
    }

    @Override
    public synchronized IAdapterFactory loadFactory(boolean force) {
        if (this.factory == null) {
            boolean isActive;
            try {
                isActive = EquinoxUtils.isActive(this.contributorName);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                isActive = true;
            }
            if (!force && !isActive) {
                return null;
            }
            try {
                this.factory = Optional.of(this.factoryLoader.call());
            }
            catch (Exception e) {
                String msg = NLS.bind(RegistryMessages.adapters_cantInstansiate, this.adaptableType, this.contributorName);
                RuntimeLog.log(new Status(4, "paper.libs.org.eclipse.equinox.registry", 0, msg, (Throwable)e));
                this.factory = Optional.empty();
            }
        }
        return this.factory.orElse(null);
    }

    private void logError() {
        String msg = NLS.bind(RegistryMessages.adapters_badAdapterFactory, this.contributorName);
        RuntimeLog.log(new Status(4, "paper.libs.org.eclipse.equinox.registry", 0, msg, null));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AdapterFactoryProxy [contributor: ");
        sb.append(this.contributorName);
        sb.append(", adaptableType: ");
        sb.append(this.adaptableType);
        if (this.factory != null) {
            sb.append(", factory: ");
            sb.append(this.factory);
        }
        sb.append("]");
        return sb.toString();
    }
}

