/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.mercury.jdt.internal.rewrite.imports;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import paper.libs.org.cadixdev.mercury.jdt.internal.rewrite.imports.ImportName;

final class ImportGroupComparator
implements Comparator<ImportName> {
    private static final String MATCH_ALL = "";
    private static final String STATIC_PREFIX = "#";
    private static final String STATIC_MATCH_ALL = "#";
    private static List<String> memoizedImportOrder = null;
    private static IndexedImportGroups memoizedIndexedImportGroups = null;
    private final IndexedImportGroups indexedImportGroups;

    private static List<String> includeMatchAllImportGroups(List<String> importOrder) {
        boolean needsStaticMatchAll;
        boolean needsTypeMatchAll = !importOrder.contains(MATCH_ALL);
        boolean bl = needsStaticMatchAll = !importOrder.contains("#");
        if (!needsTypeMatchAll && !needsStaticMatchAll) {
            return importOrder;
        }
        ArrayList<String> augmentedOrder = new ArrayList<String>(importOrder.size() + 2);
        if (needsStaticMatchAll) {
            augmentedOrder.add("#");
        }
        augmentedOrder.addAll(importOrder);
        if (needsTypeMatchAll) {
            augmentedOrder.add(MATCH_ALL);
        }
        return augmentedOrder;
    }

    private static synchronized IndexedImportGroups indexImportOrder(List<String> importOrder) {
        if (importOrder.equals(memoizedImportOrder)) {
            return memoizedIndexedImportGroups;
        }
        HashMap<String, Integer> typeGroupsAndIndices = new HashMap<String, Integer>();
        HashMap<String, Integer> staticGroupsAndIndices = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < importOrder.size(); ++i2) {
            HashMap<String, Integer> groupsAndIndices;
            String importGroupString = importOrder.get(i2);
            if (importGroupString.startsWith("#")) {
                groupsAndIndices = staticGroupsAndIndices;
                importGroupString = importGroupString.substring(1);
            } else {
                groupsAndIndices = typeGroupsAndIndices;
            }
            groupsAndIndices.put(importGroupString, i2);
        }
        memoizedImportOrder = importOrder;
        memoizedIndexedImportGroups = new IndexedImportGroups(ImportGroupComparator.mapImportGroups(typeGroupsAndIndices), ImportGroupComparator.mapImportGroups(staticGroupsAndIndices));
        return memoizedIndexedImportGroups;
    }

    private static NavigableMap<String, ImportGroup> mapImportGroups(Map<String, Integer> importGroupNamesAndIndices) {
        if (importGroupNamesAndIndices.isEmpty()) {
            importGroupNamesAndIndices = Collections.singletonMap(MATCH_ALL, 0);
        }
        ArrayList<String> sortedNames = new ArrayList<String>(importGroupNamesAndIndices.keySet());
        Collections.sort(sortedNames);
        ArrayList<ImportGroup> importGroups = new ArrayList<ImportGroup>(sortedNames.size());
        ArrayDeque<ImportGroup> prefixingGroups = new ArrayDeque<ImportGroup>();
        for (String name2 : sortedNames) {
            while (!prefixingGroups.isEmpty() && !ImportGroupComparator.isWholeSegmentPrefix(((ImportGroup)prefixingGroups.getLast()).getName(), name2)) {
                prefixingGroups.removeLast();
            }
            ImportGroup prefix = (ImportGroup)prefixingGroups.peekLast();
            ImportGroup group = new ImportGroup(name2, importGroupNamesAndIndices.get(name2), prefix);
            importGroups.add(group);
            prefixingGroups.addLast(group);
        }
        TreeMap<String, ImportGroup> groupsByName = new TreeMap<String, ImportGroup>();
        for (ImportGroup group : importGroups) {
            groupsByName.put(group.getName(), group);
        }
        return groupsByName;
    }

    private static boolean isWholeSegmentPrefix(String prefix, String name2) {
        if (!name2.startsWith(prefix)) {
            return false;
        }
        return prefix.isEmpty() || name2.length() == prefix.length() || name2.charAt(prefix.length()) == '.';
    }

    ImportGroupComparator(List<String> importOrder) {
        List<String> importOrderWithMatchAllGroups = ImportGroupComparator.includeMatchAllImportGroups(importOrder);
        this.indexedImportGroups = ImportGroupComparator.indexImportOrder(importOrderWithMatchAllGroups);
    }

    @Override
    public int compare(ImportName o1, ImportName o2) {
        return this.determineSortPosition(o1) - this.determineSortPosition(o2);
    }

    private int determineSortPosition(ImportName importName) {
        String name2 = importName.isOnDemand() ? importName.containerName : importName.qualifiedName;
        NavigableMap<String, ImportGroup> groupsByName = importName.isStatic ? this.indexedImportGroups.staticImportGroupByName : this.indexedImportGroups.typeImportGroupsByName;
        ImportGroup prefixingGroup = groupsByName.floorEntry(name2).getValue();
        while (!ImportGroupComparator.isWholeSegmentPrefix(prefixingGroup.getName(), name2)) {
            prefixingGroup = prefixingGroup.getPrefix();
        }
        return prefixingGroup.getIndex();
    }

    private static final class IndexedImportGroups {
        final NavigableMap<String, ImportGroup> typeImportGroupsByName;
        final NavigableMap<String, ImportGroup> staticImportGroupByName;

        IndexedImportGroups(NavigableMap<String, ImportGroup> typeImportGroupsByName, NavigableMap<String, ImportGroup> staticImportGroupsByName) {
            this.typeImportGroupsByName = typeImportGroupsByName;
            this.staticImportGroupByName = staticImportGroupsByName;
        }
    }

    private static final class ImportGroup {
        private final String name;
        private final int index;
        private final ImportGroup prefix;

        public ImportGroup(String name2, int index, ImportGroup prefix) {
            this.name = name2;
            this.index = index;
            this.prefix = prefix;
        }

        public String toString() {
            return String.format("ImportGroup(%d:%s)", this.getIndex(), this.getName());
        }

        String getName() {
            return this.name;
        }

        int getIndex() {
            return this.index;
        }

        ImportGroup getPrefix() {
            return this.prefix;
        }
    }
}

