/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.mercury;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import paper.libs.org.cadixdev.mercury.Mercury;
import paper.libs.org.cadixdev.mercury.SourceProcessor;
import paper.libs.org.eclipse.jdt.core.dom.CompilationUnit;
import paper.libs.org.eclipse.jdt.core.dom.PackageDeclaration;
import paper.libs.org.eclipse.jface.text.Document;

public class SourceContext {
    private final Mercury mercury;
    private final Path sourceFile;
    private final CompilationUnit compilationUnit;
    String packageName;
    String primaryType;
    private Document document;

    SourceContext(Mercury mercury, Path sourceFile, CompilationUnit compilationUnit, String primaryType) {
        this.mercury = mercury;
        this.sourceFile = sourceFile;
        this.compilationUnit = compilationUnit;
        PackageDeclaration packageDeclaration = compilationUnit.getPackage();
        this.packageName = packageDeclaration != null ? packageDeclaration.getName().getFullyQualifiedName() : "";
        this.primaryType = primaryType;
    }

    public final Mercury getMercury() {
        return this.mercury;
    }

    public final Path getSourceFile() {
        return this.sourceFile;
    }

    public final CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public final String getPackageName() {
        return this.packageName;
    }

    public final String getPrimaryType() {
        return this.primaryType;
    }

    public final String getQualifiedPrimaryType() {
        if (this.packageName.isEmpty()) {
            return this.primaryType;
        }
        return this.packageName + '.' + this.primaryType;
    }

    public final Document loadDocument() throws IOException {
        if (this.document == null) {
            this.document = new Document(new String(Files.readAllBytes(this.sourceFile), this.mercury.getEncoding()));
        }
        return this.document;
    }

    void process(List<SourceProcessor> processors) throws Exception {
        for (SourceProcessor processor : processors) {
            processor.process(this);
        }
    }
}

