/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.bombe.asm.analysis;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import paper.libs.org.cadixdev.bombe.analysis.InheritanceProvider;
import paper.libs.org.cadixdev.bombe.analysis.InheritanceType;
import paper.libs.org.cadixdev.bombe.type.signature.FieldSignature;
import paper.libs.org.cadixdev.bombe.type.signature.MethodSignature;
import paper.libs.org.objectweb.asm.ClassVisitor;
import paper.libs.org.objectweb.asm.FieldVisitor;
import paper.libs.org.objectweb.asm.MethodVisitor;

class InheritanceClassInfoVisitor
extends ClassVisitor {
    private String name;
    private boolean isInterface;
    private String superName;
    private List<String> interfaces = Collections.emptyList();
    private final Map<FieldSignature, InheritanceType> fields = new HashMap<FieldSignature, InheritanceType>();
    private final Map<String, InheritanceType> fieldsByName = new HashMap<String, InheritanceType>();
    private final Map<MethodSignature, InheritanceType> methods = new HashMap<MethodSignature, InheritanceType>();

    InheritanceClassInfoVisitor(int api) {
        super(api);
    }

    InheritanceProvider.ClassInfo create() {
        return new InheritanceProvider.ClassInfo.Impl(this.name, this.isInterface, this.superName, this.interfaces, this.fields, this.fieldsByName, this.methods);
    }

    @Override
    public void visit(int version, int access, String name2, String signature, String superName, String[] interfaces) {
        this.name = name2;
        this.isInterface = (access & 0x200) != 0;
        this.superName = superName;
        this.interfaces = Arrays.asList(interfaces);
    }

    @Override
    public FieldVisitor visitField(int access, String name2, String descriptor, String signature, Object value) {
        InheritanceType type = InheritanceType.fromModifiers(access);
        this.fields.put(FieldSignature.of(name2, descriptor), type);
        this.fieldsByName.put(name2, type);
        return null;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name2, String descriptor, String signature, String[] exceptions) {
        this.methods.put(MethodSignature.of(name2, descriptor), InheritanceType.fromModifiers(access));
        return null;
    }
}

