/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.bombe.analysis;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import paper.libs.org.cadixdev.bombe.analysis.InheritanceProvider;
import paper.libs.org.cadixdev.bombe.analysis.InheritanceType;
import paper.libs.org.cadixdev.bombe.type.signature.FieldSignature;
import paper.libs.org.cadixdev.bombe.type.signature.MethodSignature;

final class LazyInheritanceClassInfo
extends InheritanceProvider.ClassInfo.Abstract {
    private final InheritanceProvider.ClassInfo provider;
    private final String name;
    private String superName;
    private List<String> interfaces;
    private Map<FieldSignature, InheritanceType> fields;
    private Map<String, InheritanceType> fieldsByName;
    private Map<MethodSignature, InheritanceType> methods;
    private Set<InheritanceProvider.ClassInfo> parents;

    LazyInheritanceClassInfo(InheritanceProvider.ClassInfo provider) {
        this.provider = provider;
        this.name = provider.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isInterface() {
        return this.provider.isInterface();
    }

    @Override
    public String getSuperName() {
        if (this.superName == null) {
            this.superName = this.provider.getSuperName();
        }
        return this.superName;
    }

    @Override
    public List<String> getInterfaces() {
        if (this.interfaces == null) {
            this.interfaces = this.provider.getInterfaces();
        }
        return this.interfaces;
    }

    @Override
    public Map<FieldSignature, InheritanceType> getFields() {
        if (this.fields == null) {
            this.fields = this.provider.getFields();
        }
        return this.fields;
    }

    @Override
    public Map<String, InheritanceType> getFieldsByName() {
        if (this.fieldsByName == null) {
            this.fieldsByName = this.provider.getFieldsByName();
        }
        return this.fieldsByName;
    }

    @Override
    public Map<MethodSignature, InheritanceType> getMethods() {
        if (this.methods == null) {
            this.methods = this.provider.getMethods();
        }
        return this.methods;
    }

    @Override
    public Set<InheritanceProvider.ClassInfo> provideParents(InheritanceProvider provider) {
        if (this.parents == null) {
            this.parents = this.provider.provideParents(provider);
        }
        return this.parents;
    }

    @Override
    public void provideParents(InheritanceProvider provider, Collection<InheritanceProvider.ClassInfo> parents) {
        parents.addAll(this.provideParents(provider));
    }

    @Override
    public InheritanceProvider.ClassInfo lazy() {
        return this;
    }
}

