/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.model;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import paper.libs.dev.denwav.hypo.model.ClassProviderRoot;
import paper.libs.dev.denwav.hypo.model.PathClassDataReference;

final class JarClassProviderRoot
implements ClassProviderRoot {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final List<Path> roots;

    JarClassProviderRoot(@NotNull Path jarFile) throws IOException {
        this.fileSystem = FileSystems.newFileSystem(jarFile, (ClassLoader)null);
        this.roots = new ArrayList<Path>();
        for (Path root : this.fileSystem.getRootDirectories()) {
            this.roots.add(root);
        }
    }

    @Override
    public byte @Nullable [] getClassData(@NotNull String fileName) throws IOException {
        for (Path root : this.roots) {
            Path file = root.resolve(fileName);
            if (!Files.exists(file, new LinkOption[0])) continue;
            return Files.readAllBytes(file);
        }
        return null;
    }

    @Override
    @NotNull
    public List<? extends ClassProviderRoot.ClassDataReference> getAllClasses() throws IOException {
        PathMatcher pathMatcher = this.fileSystem.getPathMatcher("glob:*.class");
        List result = null;
        for (Path root : this.roots) {
            Stream<Path> stream = Files.walk(root, new FileVisitOption[0]);
            try {
                List r = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> pathMatcher.matches(p.getFileName())).map(p -> new PathClassDataReference(root.relativize((Path)p).toString(), (Path)p)).collect(Collectors.toList());
                if (result == null) {
                    result = r;
                    continue;
                }
                result.addAll(r);
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        return result == null ? Collections.emptyList() : result;
    }

    @Override
    public void close() throws Exception {
        this.fileSystem.close();
    }
}

