/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.mappings.contributors;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import paper.libs.dev.denwav.hypo.core.HypoContext;
import paper.libs.dev.denwav.hypo.hydrate.generic.HypoHydration;
import paper.libs.dev.denwav.hypo.mappings.ChangeRegistry;
import paper.libs.dev.denwav.hypo.mappings.LorenzUtil;
import paper.libs.dev.denwav.hypo.mappings.changes.CopyMethodMappingChange;
import paper.libs.dev.denwav.hypo.mappings.changes.MemberReference;
import paper.libs.dev.denwav.hypo.mappings.changes.RemoveMappingChange;
import paper.libs.dev.denwav.hypo.mappings.contributors.ChangeContributor;
import paper.libs.dev.denwav.hypo.model.data.ClassData;
import paper.libs.dev.denwav.hypo.model.data.MethodData;
import paper.libs.org.cadixdev.lorenz.model.ClassMapping;
import paper.libs.org.cadixdev.lorenz.model.MethodMapping;

public class PropagateMappingsUp
implements ChangeContributor {
    private PropagateMappingsUp() {
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static PropagateMappingsUp create() {
        return new PropagateMappingsUp();
    }

    @Override
    public void contribute(@Nullable ClassData currentClass, @Nullable ClassMapping<?, ?> classMapping, @NotNull HypoContext context, @NotNull ChangeRegistry registry) {
        if (currentClass == null || classMapping == null) {
            return;
        }
        for (MethodMapping methodMapping : classMapping.getMethodMappings()) {
            MethodData method = LorenzUtil.findMethod(currentClass, methodMapping);
            if (method == null) continue;
            PropagateMappingsUp.walkUp(method, methodMapping, registry);
        }
    }

    private static void walkUp(@NotNull MethodData method, @NotNull MethodMapping baseMapping, @NotNull ChangeRegistry registry) {
        MethodMapping methodMapping;
        boolean walkSuper = true;
        ClassMapping<?, ?> classMapping = LorenzUtil.getClassMapping(baseMapping.getMappings(), method.parentClass().name());
        if (classMapping != null) {
            methodMapping = LorenzUtil.getMethodMapping(classMapping, method.name(), method.descriptorText());
            if (methodMapping != null && methodMapping != baseMapping) {
                PropagateMappingsUp.remove(registry, baseMapping);
                walkSuper = false;
            }
        } else {
            methodMapping = null;
        }
        MethodData superMethod = method.superMethod();
        MethodData syntheticSource = method.get(HypoHydration.SYNTHETIC_SOURCE);
        if (superMethod != null && !superMethod.parentClass().isContextClass() && walkSuper) {
            PropagateMappingsUp.walkUp(superMethod, baseMapping, registry);
        } else if (methodMapping == null && syntheticSource == null) {
            registry.submitChange(CopyMethodMappingChange.of(MemberReference.of(method), baseMapping));
            PropagateMappingsUp.remove(registry, baseMapping);
        } else if (superMethod != null && superMethod.parentClass().isContextClass() && syntheticSource == null) {
            PropagateMappingsUp.remove(registry, baseMapping);
        }
        if (syntheticSource != null) {
            PropagateMappingsUp.walkUp(syntheticSource, baseMapping, registry);
        }
    }

    private static void remove(@NotNull ChangeRegistry registry, @NotNull MethodMapping mapping) {
        registry.submitChange(RemoveMappingChange.of(MemberReference.of(mapping)));
    }

    @Override
    @NotNull
    public String name() {
        return "PropagateMappingsUp";
    }
}

