/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.mappings.contributors;

import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import paper.libs.dev.denwav.hypo.core.HypoContext;
import paper.libs.dev.denwav.hypo.hydrate.generic.HypoHydration;
import paper.libs.dev.denwav.hypo.hydrate.generic.SuperCall;
import paper.libs.dev.denwav.hypo.mappings.ChangeRegistry;
import paper.libs.dev.denwav.hypo.mappings.LorenzUtil;
import paper.libs.dev.denwav.hypo.mappings.changes.CopyConstructorMappingChange;
import paper.libs.dev.denwav.hypo.mappings.changes.CopyMethodMappingChange;
import paper.libs.dev.denwav.hypo.mappings.changes.MemberReference;
import paper.libs.dev.denwav.hypo.mappings.contributors.ChangeContributor;
import paper.libs.dev.denwav.hypo.model.data.ClassData;
import paper.libs.dev.denwav.hypo.model.data.ConstructorData;
import paper.libs.dev.denwav.hypo.model.data.MethodData;
import paper.libs.org.cadixdev.lorenz.MappingSet;
import paper.libs.org.cadixdev.lorenz.model.ClassMapping;
import paper.libs.org.cadixdev.lorenz.model.MethodMapping;

public class CopyMappingsDown
implements ChangeContributor {
    private CopyMappingsDown() {
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static CopyMappingsDown create() {
        return new CopyMappingsDown();
    }

    @Override
    public void contribute(@Nullable ClassData currentClass, @Nullable ClassMapping<?, ?> classMapping, @NotNull HypoContext context, @NotNull ChangeRegistry registry) {
        if (currentClass == null || classMapping == null) {
            return;
        }
        for (MethodData method : currentClass.methods()) {
            MethodMapping methodMapping = LorenzUtil.getMethodMapping(classMapping, method.name(), method.descriptorText());
            if (methodMapping == null) continue;
            if (!method.isConstructor()) {
                CopyMappingsDown.walkDown(method, methodMapping, registry);
                continue;
            }
            CopyMappingsDown.walkConstructor(method, methodMapping, registry, null);
        }
    }

    private static void walkDown(@NotNull MethodData method, @NotNull MethodMapping mapping, @NotNull ChangeRegistry registry) {
        for (MethodData childMethod : method.childMethods()) {
            CopyMappingsDown.setChangeAndWalkDown(childMethod, mapping, registry);
        }
        MethodData syntheticTarget = method.get(HypoHydration.SYNTHETIC_TARGET);
        if (syntheticTarget != null) {
            CopyMappingsDown.setChangeAndWalkDown(syntheticTarget, mapping, registry);
        }
    }

    private static void setChangeAndWalkDown(@NotNull MethodData method, @NotNull MethodMapping mapping, @NotNull ChangeRegistry registry) {
        registry.submitChange(CopyMethodMappingChange.of(MemberReference.of(method), mapping));
        CopyMappingsDown.walkDown(method, mapping, registry);
    }

    private static void walkConstructor(@NotNull MethodData method, @NotNull MethodMapping mapping, @NotNull ChangeRegistry registry, @Nullable SuperCall parentSuperCall) {
        List<SuperCall> superCalls = method.get(HypoHydration.SUPER_CALLER_SOURCES);
        if (superCalls == null || superCalls.isEmpty()) {
            return;
        }
        MappingSet mappings = mapping.getMappings();
        for (SuperCall superCall : superCalls) {
            MethodMapping childMapping;
            ConstructorData childConst = superCall.getThisConstructor();
            ClassMapping<?, ?> childClassMapping = LorenzUtil.getClassMapping(mappings, childConst.parentClass().name());
            if (childClassMapping != null && (childMapping = LorenzUtil.getMethodMapping(childClassMapping, childConst.name(), childConst.descriptorText())) != null) continue;
            MemberReference thisReference = MemberReference.of(childConst);
            CopyConstructorMappingChange change = CopyConstructorMappingChange.of(thisReference, mapping);
            registry.submitChange(change);
            SuperCall thisSuperCall = parentSuperCall == null ? superCall : parentSuperCall.chain(superCall);
            change.addParams(thisSuperCall.getParams());
            CopyMappingsDown.walkConstructor(childConst, mapping, registry, thisSuperCall);
        }
    }

    @Override
    @NotNull
    public String name() {
        return "CopyMappingsDown";
    }
}

