/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.mappings;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import paper.libs.dev.denwav.hypo.mappings.LorenzUtil;
import paper.libs.dev.denwav.hypo.mappings.LorenzUtilHelper;
import paper.libs.dev.denwav.hypo.model.HypoModelUtil;
import paper.libs.org.cadixdev.bombe.type.signature.FieldSignature;
import paper.libs.org.cadixdev.bombe.type.signature.MethodSignature;
import paper.libs.org.cadixdev.lorenz.MappingSet;
import paper.libs.org.cadixdev.lorenz.impl.MappingSetImpl;
import paper.libs.org.cadixdev.lorenz.impl.model.AbstractClassMappingImpl;
import paper.libs.org.cadixdev.lorenz.impl.model.MethodMappingImpl;
import paper.libs.org.cadixdev.lorenz.model.ClassMapping;
import paper.libs.org.cadixdev.lorenz.model.FieldMapping;
import paper.libs.org.cadixdev.lorenz.model.InnerClassMapping;
import paper.libs.org.cadixdev.lorenz.model.MethodMapping;
import paper.libs.org.cadixdev.lorenz.model.MethodParameterMapping;
import paper.libs.org.cadixdev.lorenz.model.TopLevelClassMapping;

final class LorenzUtilHelperJdk9
extends LorenzUtilHelper {
    private static final VarHandle topLevelClassesHandle;
    private static final VarHandle innerClassesHandle;
    private static final VarHandle fieldsHandle;
    private static final VarHandle fieldsByNameHandle;
    private static final VarHandle methodsHandle;
    private static final VarHandle paramsHandle;

    LorenzUtilHelperJdk9() {
    }

    @Override
    @NotNull
    Map<String, TopLevelClassMapping> getTopLevelClassesMap(@NotNull MappingSet mappingSet) {
        MappingSetImpl castMap = LorenzUtil.checkType(mappingSet);
        Object handleResult = topLevelClassesHandle.get(castMap);
        Map result = (Map)HypoModelUtil.cast(handleResult);
        return LorenzUtil.notNull(result, "topLevelClasses");
    }

    @Override
    @NotNull
    Map<String, InnerClassMapping> getInnerClassesMap(@NotNull ClassMapping<?, ?> mapping) {
        AbstractClassMappingImpl<?, ?> castMap = LorenzUtil.checkType(mapping);
        Object handleResult = innerClassesHandle.get(castMap);
        Map result = (Map)HypoModelUtil.cast(handleResult);
        return LorenzUtil.notNull(result, "innerClasses");
    }

    @Override
    @NotNull
    Map<FieldSignature, FieldMapping> getFieldsMap(@NotNull ClassMapping<?, ?> mapping) {
        AbstractClassMappingImpl<?, ?> castMap = LorenzUtil.checkType(mapping);
        Object handleResult = fieldsHandle.get(castMap);
        Map result = (Map)HypoModelUtil.cast(handleResult);
        return LorenzUtil.notNull(result, "fields");
    }

    @Override
    @NotNull
    Map<String, FieldMapping> getFieldsByNameMap(@NotNull ClassMapping<?, ?> mapping) {
        AbstractClassMappingImpl<?, ?> castMap = LorenzUtil.checkType(mapping);
        Object handleResult = fieldsByNameHandle.get(castMap);
        Map result = (Map)HypoModelUtil.cast(handleResult);
        return LorenzUtil.notNull(result, "fieldsByName");
    }

    @Override
    @NotNull
    Map<MethodSignature, MethodMapping> getMethodsMap(@NotNull ClassMapping<?, ?> mapping) {
        AbstractClassMappingImpl<?, ?> castMap = LorenzUtil.checkType(mapping);
        Object handleResult = methodsHandle.get(castMap);
        Map result = (Map)HypoModelUtil.cast(handleResult);
        return LorenzUtil.notNull(result, "methods");
    }

    @Override
    @NotNull
    Map<Integer, MethodParameterMapping> getParamsMap(@NotNull MethodMapping mapping) {
        MethodMappingImpl castMap = LorenzUtil.checkType(mapping);
        Object handleResult = paramsHandle.get(castMap);
        Map result = (Map)HypoModelUtil.cast(handleResult);
        return LorenzUtil.notNull(result, "parameters");
    }

    static {
        try {
            topLevelClassesHandle = MethodHandles.privateLookupIn(MappingSetImpl.class, MethodHandles.lookup()).findVarHandle(MappingSetImpl.class, "topLevelClasses", Map.class);
            innerClassesHandle = MethodHandles.privateLookupIn(AbstractClassMappingImpl.class, MethodHandles.lookup()).findVarHandle(AbstractClassMappingImpl.class, "innerClasses", Map.class);
            fieldsHandle = MethodHandles.privateLookupIn(AbstractClassMappingImpl.class, MethodHandles.lookup()).findVarHandle(AbstractClassMappingImpl.class, "fields", Map.class);
            fieldsByNameHandle = MethodHandles.privateLookupIn(AbstractClassMappingImpl.class, MethodHandles.lookup()).findVarHandle(AbstractClassMappingImpl.class, "fieldsByName", Map.class);
            methodsHandle = MethodHandles.privateLookupIn(AbstractClassMappingImpl.class, MethodHandles.lookup()).findVarHandle(AbstractClassMappingImpl.class, "methods", Map.class);
            paramsHandle = MethodHandles.privateLookupIn(MethodMappingImpl.class, MethodHandles.lookup()).findVarHandle(MethodMappingImpl.class, "parameters", Map.class);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }
}

