/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util.data;

import io.papermc.paperweight.DownloadService;
import io.papermc.paperweight.PaperweightException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 *2\u00020\u0001:\u0001*B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\t\u0010\u0014\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c2\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J?\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J$\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 J$\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\b\u0010)\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lio/papermc/paperweight/util/data/MavenArtifact;", "", "group", "", "artifact", "version", "classifier", "extension", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "classifierText", "getClassifierText", "()Ljava/lang/String;", "ext", "getExt", "file", "getFile", "path", "getPath", "addSlash", "url", "component1", "component2", "component3", "component4", "component5", "copy", "downloadToDir", "Ljava/nio/file/Path;", "downloadService", "Lio/papermc/paperweight/DownloadService;", "targetDir", "repos", "", "downloadToFile", "", "targetFile", "equals", "", "other", "hashCode", "", "toString", "Companion", "paperweight-lib"})
public final class MavenArtifact {
    private final String group;
    private final String artifact;
    private final String version;
    private final String classifier;
    private final String extension;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final String getClassifierText() {
        return this.classifier != null ? '-' + this.classifier : "";
    }

    private final String getExt() {
        String string = this.extension;
        if (string == null) {
            string = "jar";
        }
        return string;
    }

    private final String getPath() {
        return StringsKt.replace$default((String)this.group, (char)'.', (char)'/', (boolean)false, (int)4, null) + '/' + this.artifact + '/' + this.version + '/' + this.getFile();
    }

    @NotNull
    public final String getFile() {
        return this.artifact + '-' + this.version + this.getClassifierText() + '.' + this.getExt();
    }

    public final void downloadToFile(@NotNull DownloadService downloadService, @NotNull Path targetFile, @NotNull List<String> repos) {
        Intrinsics.checkNotNullParameter((Object)downloadService, (String)"downloadService");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter(repos, (String)"repos");
        Path path = targetFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"targetFile.parent");
        Path path2 = path;
        Object object = new FileAttribute[]{};
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(object, ((FileAttribute[])object).length)), (String)"Files.createDirectories(this, *attributes)");
        Exception thrown = null;
        for (String repo : repos) {
            try {
                downloadService.download(this.addSlash(repo) + this.getPath(), (Object)targetFile);
                return;
            }
            catch (Exception e) {
                if (thrown != null) {
                    ExceptionsKt.addSuppressed((Throwable)thrown, (Throwable)e);
                    continue;
                }
                thrown = e;
            }
        }
        Exception exception = thrown;
        if (exception != null) {
            object = exception;
            boolean bl2 = false;
            boolean bl3 = false;
            Object it = object;
            boolean bl4 = false;
            throw (Throwable)new PaperweightException("Failed to download artifact: " + this + ". Checked repos: " + repos, (Throwable)it);
        }
    }

    @NotNull
    public final Path downloadToDir(@NotNull DownloadService downloadService, @NotNull Path targetDir, @NotNull List<String> repos) {
        Path out;
        Intrinsics.checkNotNullParameter((Object)downloadService, (String)"downloadService");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        Intrinsics.checkNotNullParameter(repos, (String)"repos");
        Path path = out = targetDir.resolve(this.getFile());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"out");
        this.downloadToFile(downloadService, path, repos);
        return out;
    }

    @NotNull
    public String toString() {
        int n = 50;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder(n);
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        $this$buildString.append(this.group).append(':').append(this.artifact).append(':').append(this.version);
        if (this.classifier != null) {
            $this$buildString.append(':').append(this.classifier);
        }
        if (this.extension != null) {
            $this$buildString.append('@').append(this.extension);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(capacity).\u2026builderAction).toString()");
        return string;
    }

    private final String addSlash(String url) {
        return StringsKt.endsWith$default((CharSequence)url, (char)'/', (boolean)false, (int)2, null) ? url : url + '/';
    }

    public MavenArtifact(@NotNull String group, @NotNull String artifact, @NotNull String version, @Nullable String classifier, @Nullable String extension) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.group = group;
        this.artifact = artifact;
        this.version = version;
        this.classifier = classifier;
        this.extension = extension;
    }

    public /* synthetic */ MavenArtifact(String string, String string2, String string3, String string4, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            string5 = null;
        }
        this(string, string2, string3, string4, string5);
    }

    private final String component1() {
        return this.group;
    }

    private final String component2() {
        return this.artifact;
    }

    private final String component3() {
        return this.version;
    }

    private final String component4() {
        return this.classifier;
    }

    private final String component5() {
        return this.extension;
    }

    @NotNull
    public final MavenArtifact copy(@NotNull String group, @NotNull String artifact, @NotNull String version, @Nullable String classifier, @Nullable String extension) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return new MavenArtifact(group, artifact, version, classifier, extension);
    }

    public static /* synthetic */ MavenArtifact copy$default(MavenArtifact mavenArtifact, String string, String string2, String string3, String string4, String string5, int n, Object object) {
        if ((n & 1) != 0) {
            string = mavenArtifact.group;
        }
        if ((n & 2) != 0) {
            string2 = mavenArtifact.artifact;
        }
        if ((n & 4) != 0) {
            string3 = mavenArtifact.version;
        }
        if ((n & 8) != 0) {
            string4 = mavenArtifact.classifier;
        }
        if ((n & 0x10) != 0) {
            string5 = mavenArtifact.extension;
        }
        return mavenArtifact.copy(string, string2, string3, string4, string5);
    }

    public int hashCode() {
        String string = this.group;
        String string2 = this.artifact;
        String string3 = this.version;
        String string4 = this.classifier;
        String string5 = this.extension;
        return ((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (string5 != null ? string5.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof MavenArtifact)) break block3;
                MavenArtifact mavenArtifact = (MavenArtifact)object;
                if (!Intrinsics.areEqual((Object)this.group, (Object)mavenArtifact.group) || !Intrinsics.areEqual((Object)this.artifact, (Object)mavenArtifact.artifact) || !Intrinsics.areEqual((Object)this.version, (Object)mavenArtifact.version) || !Intrinsics.areEqual((Object)this.classifier, (Object)mavenArtifact.classifier) || !Intrinsics.areEqual((Object)this.extension, (Object)mavenArtifact.extension)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J4\u0010\u0007\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\t0\b*\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lio/papermc/paperweight/util/data/MavenArtifact$Companion;", "", "()V", "parse", "Lio/papermc/paperweight/util/data/MavenArtifact;", "text", "", "nextSubstring", "Lkotlin/Pair;", "", "startIndex", "stops", "", "goToEnd", "", "paperweight-lib"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final MavenArtifact parse(@NotNull String text) {
            void classifier;
            void version;
            void artifact;
            void group;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Object object = io.papermc.paperweight.util.data.MavenArtifact$Companion.nextSubstring$default(this, text, 0, new char[]{':'}, false, 4, null);
            String string = (String)object.component1();
            int groupIndex = ((Number)object.component2()).intValue();
            Object object2 = io.papermc.paperweight.util.data.MavenArtifact$Companion.nextSubstring$default(this, text, groupIndex, new char[]{':'}, false, 4, null);
            object = (String)object2.component1();
            int artifactIndex = ((Number)object2.component2()).intValue();
            Object object3 = this.nextSubstring(text, artifactIndex, new char[]{':', '@'}, true);
            object2 = (String)object3.component1();
            int versionIndex = ((Number)object3.component2()).intValue();
            Pair<String, Integer> pair = this.nextSubstring(text, versionIndex, new char[]{':', '@'}, true);
            object3 = (String)pair.component1();
            int classifierIndex = ((Number)pair.component2()).intValue();
            Pair<String, Integer> pair2 = this.nextSubstring(text, classifierIndex, new char[0], true);
            String extension = (String)pair2.component1();
            if (group == null) {
                throw (Throwable)new PaperweightException("Invalid Maven artifact descriptor (no groupId found): " + text);
            }
            if (artifact == null) {
                throw (Throwable)new PaperweightException("Invalid Maven artifact descriptor (no artifactId found): " + text);
            }
            if (version == null) {
                throw (Throwable)new PaperweightException("Invalid Maven artifact descriptor (no version found): " + text);
            }
            return new MavenArtifact((String)group, (String)artifact, (String)version, (String)classifier, extension);
        }

        private final Pair<String, Integer> nextSubstring(String $this$nextSubstring, int startIndex, char[] stops, boolean goToEnd) {
            Pair pair;
            if (startIndex == $this$nextSubstring.length()) {
                return TuplesKt.to(null, (Object)startIndex);
            }
            int endIndex = StringsKt.indexOfAny$default((CharSequence)$this$nextSubstring, (char[])stops, (int)startIndex, (boolean)false, (int)4, null);
            if (endIndex != -1) {
                String string = $this$nextSubstring;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(startIndex, endIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                pair = TuplesKt.to((Object)string3, (Object)(endIndex + 1));
            } else if (goToEnd) {
                String string = $this$nextSubstring;
                boolean bl = false;
                String string4 = string;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(startIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                pair = TuplesKt.to((Object)string5, (Object)$this$nextSubstring.length());
            } else {
                pair = TuplesKt.to(null, (Object)startIndex);
            }
            return pair;
        }

        static /* synthetic */ Pair nextSubstring$default(Companion companion, String string, int n, char[] cArray, boolean bl, int n2, Object object) {
            if ((n2 & 4) != 0) {
                bl = false;
            }
            return companion.nextSubstring(string, n, cArray, bl);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

