/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util;

import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.UtilsKt;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001a\u0010\r\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0003\u001a\"\u0010\r\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\t\u001a\"\u0010\r\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\t\u001a\u0012\u0010\u0012\u001a\u00020\u0013*\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003\u001a\n\u0010\u0015\u001a\u00020\u0013*\u00020\u0003\u001a\u001a\u0010\u0016\u001a\u00020\u0013*\u00020\u00032\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u001a\u0012\u0010\u001a\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u0003\u001a\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d*\u00020\u00032\b\b\u0002\u0010\u001e\u001a\u00020\u001f\u001a\f\u0010 \u001a\u00020\u0013*\u00020\u0003H\u0002\u001a\u0012\u0010!\u001a\u00020\"*\u00020#2\u0006\u0010$\u001a\u00020%\u001a\u0012\u0010&\u001a\u00020\"*\u00020\u00032\u0006\u0010$\u001a\u00020%\u001a\f\u0010'\u001a\u00020(*\u00020\u0003H\u0002\u001a\n\u0010)\u001a\u00020**\u00020\u0003\u001a-\u0010+\u001a\u0002H,\"\f\b\u0000\u0010,*\u0006\u0012\u0002\b\u00030-*\u0002H,2\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\t\u00a2\u0006\u0002\u0010.\u001a\u0018\u0010/\u001a\u00020\u0013*\u0006\u0012\u0002\b\u00030-2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u001a\n\u00100\u001a\u00020\u001f*\u00020\u0003\u001a\u0010\u00101\u001a\b\u0012\u0004\u0012\u00020\u000302*\u00020*\u001a\u0012\u00103\u001a\u00020\u0003*\u00020\u00032\u0006\u00104\u001a\u00020\u001f\u001a\n\u00105\u001a\u00020**\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0003*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u001d\u0010\u0005\u001a\u00020\u0003*\n\u0012\u0006\b\u0001\u0012\u00020\u00060\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\n\"\u001f\u0010\u000b\u001a\u0004\u0018\u00010\u0003*\n\u0012\u0006\b\u0001\u0012\u00020\u00060\t8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u00066"}, d2={"isWindows", "", "isLibraryJar", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)Z", "path", "Lorg/gradle/api/file/FileSystemLocation;", "getPath", "(Lorg/gradle/api/file/FileSystemLocation;)Ljava/nio/file/Path;", "Lorg/gradle/api/provider/Provider;", "(Lorg/gradle/api/provider/Provider;)Ljava/nio/file/Path;", "pathOrNull", "getPathOrNull", "convention", "Lorg/gradle/api/file/DirectoryProperty;", "project", "Lorg/gradle/api/Project;", "Lorg/gradle/api/file/RegularFileProperty;", "copyRecursivelyTo", "", "target", "deleteForcefully", "deleteRecursively", "excludes", "", "Ljava/nio/file/PathMatcher;", "directory", "Ljava/lang/ProcessBuilder;", "filesMatchingRecursive", "", "glob", "", "fixWindowsPermissionsForDeletion", "hash", "", "Ljava/io/InputStream;", "digest", "Ljava/security/MessageDigest;", "hashFile", "jarUri", "Ljava/net/URI;", "openZip", "Ljava/nio/file/FileSystem;", "pathProvider", "P", "Lorg/gradle/api/file/FileSystemLocationProperty;", "(Lorg/gradle/api/file/FileSystemLocationProperty;Lorg/gradle/api/provider/Provider;)Lorg/gradle/api/file/FileSystemLocationProperty;", "set", "sha256asHex", "walk", "Ljava/util/stream/Stream;", "withDifferentExtension", "ext", "writeZip", "paperweight-lib"})
public final class FileKt {
    private static final boolean isWindows;

    @NotNull
    public static final Path getPath(@NotNull FileSystemLocation $this$path) {
        Intrinsics.checkNotNullParameter((Object)$this$path, (String)"$this$path");
        Path path = $this$path.getAsFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"asFile.toPath()");
        return path;
    }

    @NotNull
    public static final Path getPath(@NotNull Provider<? extends FileSystemLocation> $this$path) {
        Intrinsics.checkNotNullParameter($this$path, (String)"$this$path");
        return FileKt.getPath((FileSystemLocation)$this$path.get());
    }

    @Nullable
    public static final Path getPathOrNull(@NotNull Provider<? extends FileSystemLocation> $this$pathOrNull) {
        Intrinsics.checkNotNullParameter($this$pathOrNull, (String)"$this$pathOrNull");
        FileSystemLocation fileSystemLocation = (FileSystemLocation)$this$pathOrNull.getOrNull();
        return fileSystemLocation != null ? FileKt.getPath(fileSystemLocation) : null;
    }

    public static final void set(@NotNull FileSystemLocationProperty<?> $this$set, @Nullable Path path) {
        Intrinsics.checkNotNullParameter($this$set, (String)"$this$set");
        Path path2 = path;
        $this$set.set(path2 != null ? path2.toFile() : null);
    }

    @NotNull
    public static final <P extends FileSystemLocationProperty<?>> P pathProvider(@NotNull P $this$pathProvider, @NotNull Provider<Path> path) {
        Intrinsics.checkNotNullParameter($this$pathProvider, (String)"$this$pathProvider");
        Intrinsics.checkNotNullParameter(path, (String)"path");
        P p = $this$pathProvider;
        boolean bl = false;
        boolean bl2 = false;
        P $this$apply = p;
        boolean bl3 = false;
        $this$apply.fileProvider(path.map((Transformer)pathProvider.1.1.INSTANCE));
        return p;
    }

    @NotNull
    public static final DirectoryProperty convention(@NotNull DirectoryProperty $this$convention, @NotNull Project project, @NotNull Provider<Path> path) {
        Intrinsics.checkNotNullParameter((Object)$this$convention, (String)"$this$convention");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(path, (String)"path");
        DirectoryProperty directoryProperty = $this$convention.convention(project.getLayout().dir(path.map((Transformer)convention.1.INSTANCE)));
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"convention(project.layou\u2026ath.map { it.toFile() }))");
        return directoryProperty;
    }

    @NotNull
    public static final RegularFileProperty convention(@NotNull RegularFileProperty $this$convention, @NotNull Project project, @NotNull Provider<Path> path) {
        Intrinsics.checkNotNullParameter((Object)$this$convention, (String)"$this$convention");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(path, (String)"path");
        RegularFileProperty regularFileProperty = $this$convention.convention(project.getLayout().file(path.map((Transformer)convention.2.INSTANCE)));
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"convention(project.layou\u2026ath.map { it.toFile() }))");
        return regularFileProperty;
    }

    @NotNull
    public static final DirectoryProperty convention(@NotNull DirectoryProperty $this$convention, @NotNull Project project, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$convention, (String)"$this$convention");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        DirectoryProperty directoryProperty = $this$convention.convention(project.getLayout().dir(project.provider(new Callable(path){
            final /* synthetic */ Path $path;

            public final File call() {
                return this.$path.toFile();
            }
            {
                this.$path = path;
            }
        })));
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"convention(project.layou\u2026vider { path.toFile() }))");
        return directoryProperty;
    }

    public static final boolean isLibraryJar(@NotNull Path $this$isLibraryJar) {
        Intrinsics.checkNotNullParameter((Object)$this$isLibraryJar, (String)"$this$isLibraryJar");
        return StringsKt.endsWith$default((String)PathsKt.getName((Path)$this$isLibraryJar), (String)".jar", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)PathsKt.getName((Path)$this$isLibraryJar), (String)"-sources.jar", (boolean)false, (int)2, null);
    }

    public static final void deleteForcefully(@NotNull Path $this$deleteForcefully) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteForcefully, (String)"$this$deleteForcefully");
        FileKt.fixWindowsPermissionsForDeletion($this$deleteForcefully);
        Path path = $this$deleteForcefully;
        boolean bl = false;
        Files.deleteIfExists(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void deleteRecursively(@NotNull Path $this$deleteRecursively, @NotNull Iterable<? extends PathMatcher> excludes) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteRecursively, (String)"$this$deleteRecursively");
        Intrinsics.checkNotNullParameter(excludes, (String)"excludes");
        Path path = $this$deleteRecursively;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean bl = false;
        if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return;
        }
        path = $this$deleteRecursively;
        linkOptionArray = new LinkOption[]{};
        bl = false;
        if (!Files.isDirectory(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean bl2;
            boolean $i$f$any;
            Path $this$any$iv;
            block14: {
                $this$any$iv = excludes;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)((Object)$this$any$iv)).isEmpty()) {
                    bl2 = false;
                } else {
                    Iterator<? extends PathMatcher> iterator = $this$any$iv.iterator();
                    while (iterator.hasNext()) {
                        PathMatcher element$iv;
                        PathMatcher it = element$iv = iterator.next();
                        boolean bl3 = false;
                        if (!it.matches($this$deleteRecursively)) continue;
                        bl2 = true;
                        break block14;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return;
            }
            FileKt.fixWindowsPermissionsForDeletion($this$deleteRecursively);
            $this$any$iv = $this$deleteRecursively;
            $i$f$any = false;
            Files.deleteIfExists($this$any$iv);
            return;
        }
        AutoCloseable $i$f$any = Files.walk($this$deleteRecursively, new FileVisitOption[0]);
        bl = false;
        boolean bl4 = false;
        Iterator iterator = null;
        try {
            Object stream = (Stream)$i$f$any;
            boolean bl5 = false;
            Stream stream2 = stream;
            Intrinsics.checkNotNullExpressionValue((Object)stream2, (String)"stream");
            stream = SequencesKt.toList((Sequence)SequencesKt.filterNot((Sequence)StreamsKt.asSequence((Stream)stream2), (Function1)((Function1)new Function1<Path, Boolean>((Iterable)excludes){
                final /* synthetic */ Iterable $excludes$inlined;
                {
                    this.$excludes$inlined = iterable;
                    super(1);
                }

                public final boolean invoke(Path file) {
                    boolean bl;
                    block3: {
                        Iterable $this$any$iv = this.$excludes$inlined;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                PathMatcher it = (PathMatcher)element$iv;
                                boolean bl2 = false;
                                if (!it.matches(file)) continue;
                                bl = true;
                                break block3;
                            }
                            bl = false;
                        }
                    }
                    return bl;
                }
            })));
        }
        catch (Throwable stream) {
            iterator = stream;
            throw stream;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)$i$f$any, (Throwable)((Object)iterator));
        }
        Object fileList = stream;
        Iterable $this$forEach$iv = (Iterable)fileList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path f = (Path)element$iv;
            boolean bl6 = false;
            Path path2 = f;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"f");
            FileKt.fixWindowsPermissionsForDeletion(path2);
        }
        $this$forEach$iv = CollectionsKt.asReversed((List)fileList);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path f = (Path)element$iv;
            boolean bl7 = false;
            Path path3 = f;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"f");
            Path path4 = path3;
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            boolean bl8 = false;
            if (Files.isRegularFile(path4, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                path4 = f;
                boolean bl9 = false;
                Files.deleteIfExists(path4);
                continue;
            }
            path4 = f;
            linkOptionArray2 = new LinkOption[]{};
            bl8 = false;
            if (!Files.isDirectory(path4, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) || !PathsKt.listDirectoryEntries$default((Path)f, null, (int)1, null).isEmpty()) continue;
            path4 = f;
            boolean bl10 = false;
            Files.deleteIfExists(path4);
        }
    }

    public static /* synthetic */ void deleteRecursively$default(Path path, Iterable iterable, int n, Object object) {
        if ((n & 1) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        FileKt.deleteRecursively(path, iterable);
    }

    private static final void fixWindowsPermissionsForDeletion(Path $this$fixWindowsPermissionsForDeletion) {
        Path path;
        block7: {
            block6: {
                if (!isWindows) break block6;
                path = $this$fixWindowsPermissionsForDeletion;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                boolean bl = false;
                if (!Files.notExists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block7;
            }
            return;
        }
        path = $this$fixWindowsPermissionsForDeletion;
        boolean bl = false;
        try {
            Object object = Result.Companion;
            Path $this$runCatching = path;
            boolean bl2 = false;
            Path path2 = $this$runCatching;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            boolean bl3 = false;
            DosFileAttributeView dosFileAttributeView = Files.getFileAttributeView(path2, DosFileAttributeView.class, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
            if (dosFileAttributeView == null) {
                Void void_ = PathsKt.fileAttributeViewNotAvailable((Path)path2, DosFileAttributeView.class);
                throw new KotlinNothingValueException();
            }
            DosFileAttributeView dosAttr = dosFileAttributeView;
            dosAttr.setHidden(false);
            dosAttr.setReadOnly(false);
            Unit unit = Unit.INSTANCE;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl5 = false;
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyRecursivelyTo(@NotNull Path $this$copyRecursivelyTo, @NotNull Path target) {
        Intrinsics.checkNotNullParameter((Object)$this$copyRecursivelyTo, (String)"$this$copyRecursivelyTo");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Object object = target;
        Object[] objectArray = new FileAttribute[]{};
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object, Arrays.copyOf(objectArray, objectArray.length)), (String)"Files.createDirectories(this, *attributes)");
        object = $this$copyRecursivelyTo;
        objectArray = new LinkOption[]{};
        bl = false;
        if (!Files.exists((Path)object, (LinkOption[])Arrays.copyOf(objectArray, objectArray.length))) {
            return;
        }
        object = Files.walk($this$copyRecursivelyTo, new FileVisitOption[0]);
        boolean bl2 = false;
        bl = false;
        Throwable throwable = null;
        try {
            Stream stream = (Stream)object;
            boolean bl3 = false;
            Iterator iterator = stream.iterator();
            while (iterator.hasNext()) {
                Path f;
                Path path = f = (Path)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"f");
                Path targetPath = target.resolve(PathsKt.getInvariantSeparatorsPathString((Path)PathsKt.relativeTo((Path)path, (Path)$this$copyRecursivelyTo)));
                Path path2 = f;
                Object object2 = new LinkOption[]{};
                boolean bl4 = false;
                if (Files.isDirectory(path2, Arrays.copyOf(object2, ((LinkOption[])object2).length))) {
                    Path path3 = targetPath;
                    Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"targetPath");
                    path2 = path3;
                    object2 = new FileAttribute[]{};
                    bl4 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, (FileAttribute[])Arrays.copyOf(object2, ((LinkOption[])object2).length)), (String)"Files.createDirectories(this, *attributes)");
                    continue;
                }
                path2 = f;
                Path path4 = targetPath;
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"targetPath");
                object2 = path4;
                bl4 = false;
                boolean bl5 = false;
                CopyOption[] copyOptionArray = new CopyOption[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path2, (Path)object2, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"Files.copy(this, target, *options)");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<Path> filesMatchingRecursive(@NotNull Path $this$filesMatchingRecursive, @NotNull String glob) {
        List<Path> list;
        Intrinsics.checkNotNullParameter((Object)$this$filesMatchingRecursive, (String)"$this$filesMatchingRecursive");
        Intrinsics.checkNotNullParameter((Object)glob, (String)"glob");
        PathMatcher matcher = $this$filesMatchingRecursive.getFileSystem().getPathMatcher("glob:" + glob);
        AutoCloseable autoCloseable = Files.walk($this$filesMatchingRecursive, new FileVisitOption[0]);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl3 = false;
            List<Path> list2 = stream.filter(new Predicate(matcher){
                final /* synthetic */ PathMatcher $matcher$inlined;
                {
                    this.$matcher$inlined = pathMatcher;
                }

                public final boolean test(Path it) {
                    Path path = it;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it");
                    Path path2 = path;
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    boolean bl = false;
                    return Files.isRegularFile(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && this.$matcher$inlined.matches(it.getFileName());
                }
            }).collect(Collectors.toList());
            list = list2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue(list, (String)"Files.walk(this).use { s\u2026ollectors.toList())\n    }");
        return list;
    }

    public static /* synthetic */ List filesMatchingRecursive$default(Path path, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "*";
        }
        return FileKt.filesMatchingRecursive(path, string);
    }

    private static final URI jarUri(Path $this$jarUri) {
        URI uRI = URI.create("jar:" + $this$jarUri.toUri());
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"URI.create(\"jar:${toUri()}\")");
        return uRI;
    }

    @NotNull
    public static final FileSystem openZip(@NotNull Path $this$openZip) {
        Intrinsics.checkNotNullParameter((Object)$this$openZip, (String)"$this$openZip");
        FileSystem fileSystem = FileSystems.newFileSystem(FileKt.jarUri($this$openZip), MapsKt.emptyMap());
        Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"FileSystems.newFileSyste\u2026 emptyMap<String, Any>())");
        return fileSystem;
    }

    @NotNull
    public static final FileSystem writeZip(@NotNull Path $this$writeZip) {
        Intrinsics.checkNotNullParameter((Object)$this$writeZip, (String)"$this$writeZip");
        FileSystem fileSystem = FileSystems.newFileSystem(FileKt.jarUri($this$writeZip), MapsKt.mapOf((Pair)TuplesKt.to((Object)"create", (Object)"true")));
        Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"FileSystems.newFileSyste\u2026apOf(\"create\" to \"true\"))");
        return fileSystem;
    }

    @NotNull
    public static final Stream<Path> walk(@NotNull FileSystem $this$walk) {
        Intrinsics.checkNotNullParameter((Object)$this$walk, (String)"$this$walk");
        Stream<Path> stream = StreamSupport.stream($this$walk.getRootDirectories().spliterator(), false).flatMap(walk.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"StreamSupport.stream(roo\u2026latMap { Files.walk(it) }");
        return stream;
    }

    @NotNull
    public static final ProcessBuilder directory(@NotNull ProcessBuilder $this$directory, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"$this$directory");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ProcessBuilder processBuilder = $this$directory.directory(path.toFile());
        Intrinsics.checkNotNullExpressionValue((Object)processBuilder, (String)"directory(path.toFile())");
        return processBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] hash(@NotNull InputStream $this$hash, @NotNull MessageDigest digest) {
        Intrinsics.checkNotNullParameter((Object)$this$hash, (String)"$this$hash");
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        DigestInputStream digestStream = new DigestInputStream($this$hash, digest);
        Closeable closeable = digestStream;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            DigestInputStream stream = (DigestInputStream)closeable;
            boolean bl3 = false;
            byte[] buffer = new byte[1024];
            while (stream.read(buffer) != -1) {
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] byArray2 = digestStream.getMessageDigest().digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"digestStream.messageDigest.digest()");
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] hashFile(@NotNull Path $this$hashFile, @NotNull MessageDigest digest) {
        byte[] byArray2;
        Intrinsics.checkNotNullParameter((Object)$this$hashFile, (String)"$this$hashFile");
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Object object = $this$hashFile;
        OpenOption[] openOptionArray = new OpenOption[]{};
        boolean bl = false;
        InputStream inputStream = Files.newInputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"Files.newInputStream(this, *options)");
        object = inputStream;
        boolean bl2 = false;
        bl = false;
        Throwable throwable = null;
        try {
            InputStream iS = (InputStream)object;
            boolean bl3 = false;
            byArray2 = FileKt.hash(iS, digest);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return byArray2;
    }

    @NotNull
    public static final String sha256asHex(@NotNull Path $this$sha256asHex) {
        Intrinsics.checkNotNullParameter((Object)$this$sha256asHex, (String)"$this$sha256asHex");
        return UtilsKt.toHex(FileKt.hashFile($this$sha256asHex, UtilsKt.getDigestSha256()));
    }

    @NotNull
    public static final Path withDifferentExtension(@NotNull Path $this$withDifferentExtension, @NotNull String ext) {
        Intrinsics.checkNotNullParameter((Object)$this$withDifferentExtension, (String)"$this$withDifferentExtension");
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        Path path = $this$withDifferentExtension.resolveSibling(PathsKt.getNameWithoutExtension((Path)$this$withDifferentExtension) + '.' + ext);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolveSibling(\"$nameWithoutExtension.$ext\")");
        return path;
    }

    static {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"System.getProperty(\"os.name\")");
        isWindows = StringsKt.contains((CharSequence)string, (CharSequence)"windows", (boolean)true);
    }
}

