/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.userdev.internal.setup.step;

import io.papermc.paperweight.userdev.internal.setup.SetupHandler;
import io.papermc.paperweight.userdev.internal.setup.step.Input;
import io.papermc.paperweight.userdev.internal.setup.step.Output;
import io.papermc.paperweight.userdev.internal.setup.step.SetupStep;
import io.papermc.paperweight.userdev.internal.setup.util.HashFunctionBuilder;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.Git;
import io.papermc.paperweight.util.UtilsKt;
import io.papermc.paperweight.util.ZipKt;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0016\u0010\u0002\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0005\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0010\u0010\b\u00a8\u0006\u0018"}, d2={"Lio/papermc/paperweight/userdev/internal/setup/step/ApplyDevBundlePatches;", "Lio/papermc/paperweight/userdev/internal/setup/step/SetupStep;", "decompiledJar", "Ljava/nio/file/Path;", "devBundlePatches", "outputJar", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "getDecompiledJar$annotations", "()V", "hashFile", "getHashFile", "()Ljava/nio/file/Path;", "name", "", "getName", "()Ljava/lang/String;", "getOutputJar$annotations", "run", "", "context", "Lio/papermc/paperweight/userdev/internal/setup/SetupHandler$Context;", "touchHashFunctionBuilder", "builder", "Lio/papermc/paperweight/userdev/internal/setup/util/HashFunctionBuilder;", "paperweight-userdev"})
public final class ApplyDevBundlePatches
implements SetupStep {
    @NotNull
    private final String name;
    @NotNull
    private final Path hashFile;
    private final Path decompiledJar;
    private final Path devBundlePatches;
    private final Path outputJar;

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Path getHashFile() {
        return this.hashFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(@NotNull SetupHandler.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Git.Companion.checkForGit();
        Path workDir = UtilsKt.findOutputDir(this.outputJar);
        try {
            ZipKt.unzip(this.decompiledJar, workDir);
            Git git = new Git(workDir, null, 2, null);
            AutoCloseable autoCloseable = Files.walk(this.devBundlePatches, new FileVisitOption[0]);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Stream stream = (Stream)autoCloseable;
                boolean bl3 = false;
                stream.forEach(new Consumer(this, git, workDir){
                    final /* synthetic */ ApplyDevBundlePatches this$0;
                    final /* synthetic */ Git $git$inlined;
                    final /* synthetic */ Path $workDir$inlined;
                    {
                        this.this$0 = applyDevBundlePatches;
                        this.$git$inlined = git;
                        this.$workDir$inlined = path;
                    }

                    public final void accept(Path it) {
                        Path path = it;
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it");
                        if (StringsKt.endsWith$default((String)PathsKt.getName((Path)path), (String)".patch", (boolean)false, (int)2, null)) {
                            String[] stringArray = new String[3];
                            stringArray[0] = "apply";
                            stringArray[1] = "--ignore-whitespace";
                            Path path2 = it;
                            boolean bl = false;
                            stringArray[2] = ((Object)path2.toAbsolutePath()).toString();
                            this.$git$inlined.invoke(stringArray).executeOut();
                        } else {
                            Path path3 = it;
                            Object object = new LinkOption[]{};
                            boolean bl = false;
                            if (Files.isRegularFile(path3, Arrays.copyOf(object, ((LinkOption[])object).length))) {
                                Path destination;
                                Path path4 = destination = this.$workDir$inlined.resolve(PathsKt.relativeTo((Path)it, (Path)ApplyDevBundlePatches.access$getDevBundlePatches$p(this.this$0)));
                                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"destination");
                                Path path5 = path4.getParent();
                                Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"destination.parent");
                                object = path5;
                                Object object2 = new FileAttribute[]{};
                                boolean bl2 = false;
                                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object, Arrays.copyOf(object2, ((FileAttribute[])object2).length)), (String)"Files.createDirectories(this, *attributes)");
                                object = it;
                                object2 = destination;
                                bl2 = true;
                                boolean bl3 = false;
                                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                                Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)object, (Path)object2, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"Files.copy(this, target, *options)");
                            }
                        }
                    }
                });
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            UtilsKt.ensureDeleted(this.outputJar);
            ZipKt.zip(workDir, this.outputJar);
        }
        finally {
            FileKt.deleteRecursively$default(workDir, null, 1, null);
        }
    }

    @Override
    public void touchHashFunctionBuilder(@NotNull HashFunctionBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.include((Object)io.papermc.paperweight.userdev.internal.setup.util.UtilsKt.hashDirectory(this.devBundlePatches));
    }

    @Input
    private static /* synthetic */ void getDecompiledJar$annotations() {
    }

    @Output
    private static /* synthetic */ void getOutputJar$annotations() {
    }

    public ApplyDevBundlePatches(@NotNull Path decompiledJar, @NotNull Path devBundlePatches, @NotNull Path outputJar) {
        Intrinsics.checkNotNullParameter((Object)decompiledJar, (String)"decompiledJar");
        Intrinsics.checkNotNullParameter((Object)devBundlePatches, (String)"devBundlePatches");
        Intrinsics.checkNotNullParameter((Object)outputJar, (String)"outputJar");
        this.decompiledJar = decompiledJar;
        this.devBundlePatches = devBundlePatches;
        this.outputJar = outputJar;
        this.name = "apply patches to decompiled jar";
        this.hashFile = io.papermc.paperweight.userdev.internal.setup.util.UtilsKt.siblingHashesFile(this.outputJar);
    }

    public static final /* synthetic */ Path access$getDevBundlePatches$p(ApplyDevBundlePatches $this) {
        return $this.devBundlePatches;
    }
}

