/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.userdev.internal.setup;

import io.papermc.paperweight.userdev.internal.setup.SetupHandler;
import io.papermc.paperweight.userdev.internal.setup.step.Input;
import io.papermc.paperweight.userdev.internal.setup.step.Output;
import io.papermc.paperweight.userdev.internal.setup.step.SetupStep;
import io.papermc.paperweight.userdev.internal.setup.util.HashFunctionBuilder;
import io.papermc.paperweight.userdev.internal.setup.util.UtilsKt;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.Jar_runnerKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.jetbrains.annotations.NotNull;
import paper.libs.com.github.salomonbrys.kotson.GsonBuilderKt;
import paper.libs.com.google.gson.Gson;
import paper.libs.com.google.gson.JsonElement;
import paper.libs.com.google.gson.JsonObject;
import paper.libs.com.google.gson.reflect.TypeToken;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J\u0018\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J8\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0006\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0005\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0004\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u000fR\u0016\u0010\u0002\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0015\u0010\u000f\u00a8\u0006!"}, d2={"Lio/papermc/paperweight/userdev/internal/setup/RunPaperclip;", "Lio/papermc/paperweight/userdev/internal/setup/step/SetupStep;", "paperclip", "Ljava/nio/file/Path;", "outputJar", "mojangJar", "minecraftVersion", "", "bundler", "", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/lang/String;Z)V", "hashFile", "getHashFile", "()Ljava/nio/file/Path;", "getMinecraftVersion$annotations", "()V", "getMojangJar$annotations", "name", "getName", "()Ljava/lang/String;", "getOutputJar$annotations", "getPaperclip$annotations", "handleBundler", "", "work", "handleOldPaperclip", "patchPaperclip", "context", "Lio/papermc/paperweight/userdev/internal/setup/SetupHandler$Context;", "run", "touchHashFunctionBuilder", "builder", "Lio/papermc/paperweight/userdev/internal/setup/util/HashFunctionBuilder;", "paperweight-userdev"})
public final class RunPaperclip
implements SetupStep {
    @NotNull
    private final String name;
    @NotNull
    private final Path hashFile;
    private final Path paperclip;
    private final Path outputJar;
    private final Path mojangJar;
    private final String minecraftVersion;
    private final boolean bundler;

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Path getHashFile() {
        return this.hashFile;
    }

    @Override
    public void run(@NotNull SetupHandler.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.patchPaperclip(context, this.paperclip, this.outputJar, this.mojangJar, this.minecraftVersion, this.bundler);
    }

    @Override
    public void touchHashFunctionBuilder(@NotNull HashFunctionBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.setIncludePaperweightHash(false);
    }

    private final void patchPaperclip(SetupHandler.Context context, Path paperclip, Path outputJar, Path mojangJar, String minecraftVersion2, boolean bundler) {
        Path cache;
        Path logFile = UtilsKt.siblingLogFile(outputJar);
        Object object = new FileAttribute[]{};
        String string = null;
        boolean bl = false;
        Path path = Files.createTempDirectory(string, Arrays.copyOf(object, ((FileAttribute[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Files.createTempDirectory(prefix, *attributes)");
        Path work = path;
        FileKt.deleteForcefully(logFile);
        Path path2 = cache = work.resolve("cache");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"cache");
        object = path2;
        Object object2 = new FileAttribute[]{};
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object, Arrays.copyOf(object2, ((FileAttribute[])object2).length)), (String)"Files.createDirectories(this, *attributes)");
        object = mojangJar;
        Path path3 = cache.resolve("mojang_" + minecraftVersion2 + ".jar");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"cache.resolve(\"mojang_$minecraftVersion.jar\")");
        object2 = path3;
        bl2 = false;
        boolean bl3 = false;
        CopyOption[] copyOptionArray = new CopyOption[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)object, (Path)object2, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"Files.copy(this, target, *options)");
        JavaLauncher javaLauncher = context.getDefaultJavaLauncher();
        ConfigurableFileCollection configurableFileCollection = context.getProject().files(new Object[]{paperclip});
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"context.project.files(paperclip)");
        Jar_runnerKt.runJar(javaLauncher, (FileCollection)configurableFileCollection, (Object)work, (Object)logFile, (List<String>)CollectionsKt.listOf((Object)"-Dpaperclip.patchonly=true"), new String[0]);
        if (bundler) {
            this.handleBundler(paperclip, work, outputJar);
        } else {
            this.handleOldPaperclip(work, outputJar);
        }
        FileKt.deleteRecursively$default(work, null, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void handleBundler(Path paperclip, Path work, Path outputJar) {
        Closeable closeable = FileKt.openZip(paperclip);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Object object;
            Object type$iv$iv$iv;
            Object object2;
            Object $receiver$iv$iv;
            void $this$fromJson$iv;
            FileSystem fs = (FileSystem)closeable;
            boolean bl3 = false;
            Iterable<Path> iterable = fs.getRootDirectories();
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"fs.rootDirectories");
            Path root = (Path)CollectionsKt.single(iterable);
            Path serverVersionJson = root.resolve("version.json");
            Gson gson = io.papermc.paperweight.util.UtilsKt.getGson();
            Path path = serverVersionJson;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"serverVersionJson");
            Iterable<Path> any$iv = path;
            boolean $i$f$fromJson22 = false;
            Path path2 = any$iv;
            if (path2 instanceof String) {
                Type type;
                $receiver$iv$iv = $this$fromJson$iv;
                String string = (String)((Object)any$iv);
                object2 = $receiver$iv$iv;
                Type type2 = new TypeToken<JsonObject>(){}.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<T>() {} .type");
                type$iv$iv$iv = type2;
                if (type$iv$iv$iv instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv$iv)) {
                    Type type3 = ((ParameterizedType)type$iv$iv$iv).getRawType();
                    type = type3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type.rawType");
                } else {
                    type = GsonBuilderKt.removeTypeWildcards((Type)type$iv$iv$iv);
                }
                Type type4 = type;
                Object t = ((Gson)object2).fromJson(string, type4);
                object = t;
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"fromJson(json, typeToken<T>())");
            } else {
                $receiver$iv$iv = io.papermc.paperweight.util.UtilsKt.convertToPath(any$iv);
                Charset charset = Charsets.UTF_8;
                type$iv$iv$iv = new OpenOption[]{};
                int n = 8192;
                boolean bl4 = false;
                $receiver$iv$iv = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)$receiver$iv$iv, Arrays.copyOf(type$iv$iv$iv, ((OpenOption[])type$iv$iv$iv).length)), charset), n);
                boolean bl5 = false;
                n = 0;
                object2 = null;
                try {
                    Type type;
                    BufferedReader it$iv = (BufferedReader)$receiver$iv$iv;
                    boolean bl6 = false;
                    void $receiver$iv$iv2 = $this$fromJson$iv;
                    Reader $i$f$typeToken = it$iv;
                    void $i$f$fromJson = $receiver$iv$iv2;
                    Type type5 = new TypeToken<JsonObject>(){}.getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"object : TypeToken<T>() {} .type");
                    Type type$iv$iv$iv2 = type5;
                    if (type$iv$iv$iv2 instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv$iv2)) {
                        Type type6 = ((ParameterizedType)type$iv$iv$iv2).getRawType();
                        type = type6;
                        Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"type.rawType");
                    } else {
                        type = GsonBuilderKt.removeTypeWildcards(type$iv$iv$iv2);
                    }
                    Type type7 = type;
                    Object t = $i$f$fromJson.fromJson($i$f$typeToken, type7);
                    Intrinsics.checkExpressionValueIsNotNull(t, (String)"fromJson(json, typeToken<T>())");
                    it$iv = t;
                    object = it$iv;
                }
                catch (Throwable it$iv) {
                    object2 = it$iv;
                    throw it$iv;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)$receiver$iv$iv, (Throwable)object2);
                }
            }
            JsonElement jsonElement = ((JsonObject)object).get("id");
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"gson.fromJson<JsonObject>(serverVersionJson)[\"id\"]");
            String versionId = jsonElement.getAsString();
            Path path3 = root.resolve("META-INF/versions.list");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"root.resolve(FileEntry.VERSIONS_LIST)");
            any$iv = path3;
            Charset $i$f$fromJson22 = Charsets.UTF_8;
            boolean bl7 = false;
            List<String> list = Files.readAllLines(any$iv, $i$f$fromJson22);
            Intrinsics.checkNotNullExpressionValue(list, (String)"Files.readAllLines(this, charset)");
            any$iv = list;
            boolean $i$f$map = false;
            void var14_22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String bl6 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl8 = false;
                List list2 = StringsKt.split$default((CharSequence)((CharSequence)it), (char[])new char[]{'\t'}, (boolean)false, (int)0, (int)6, null);
                collection.add(list2);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv2;
                List it = (List)element$iv$iv;
                boolean bl9 = false;
                Pair pair = TuplesKt.to(it.get(1), it.get(2));
                boolean bl10 = false;
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map versions = destination$iv$iv2;
            Path serverJarPath = work.resolve("versions/" + (String)versions.get(versionId));
            Path path4 = outputJar.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"outputJar.parent");
            Path path5 = path4;
            Object object3 = new FileAttribute[]{};
            boolean bl11 = false;
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path5, Arrays.copyOf(object3, ((FileAttribute[])object3).length)), (String)"Files.createDirectories(this, *attributes)");
            Path path6 = serverJarPath;
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"serverJarPath");
            path5 = path6;
            object3 = outputJar;
            bl11 = true;
            boolean bl12 = false;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Path path7 = Files.copy(path5, (Path)object3, Arrays.copyOf(copyOptionArray, copyOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"Files.copy(this, target, *options)");
            Path path8 = path7;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void handleOldPaperclip(Path work, Path outputJar) {
        Object v1;
        boolean bl;
        Object object;
        block2: {
            Path path = work.resolve("cache");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"work.resolve(\"cache\")");
            object = PathsKt.listDirectoryEntries$default((Path)path, null, (int)1, null);
            bl = false;
            Iterable iterable = object;
            boolean bl2 = false;
            for (Object t : iterable) {
                Path it = (Path)t;
                boolean bl3 = false;
                if (!StringsKt.startsWith$default((String)PathsKt.getName((Path)it), (String)"patched", (boolean)false, (int)2, null)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        Path path = v1;
        if (path == null) {
            object = "Can't find patched jar!";
            bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        Path patched = path;
        object = patched;
        bl = true;
        boolean bl4 = false;
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)object, outputJar, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"Files.copy(this, target, *options)");
    }

    @Input
    private static /* synthetic */ void getPaperclip$annotations() {
    }

    @Output
    private static /* synthetic */ void getOutputJar$annotations() {
    }

    @Input
    private static /* synthetic */ void getMojangJar$annotations() {
    }

    @Input
    private static /* synthetic */ void getMinecraftVersion$annotations() {
    }

    public RunPaperclip(@NotNull Path paperclip, @NotNull Path outputJar, @NotNull Path mojangJar, @NotNull String minecraftVersion2, boolean bundler) {
        Intrinsics.checkNotNullParameter((Object)paperclip, (String)"paperclip");
        Intrinsics.checkNotNullParameter((Object)outputJar, (String)"outputJar");
        Intrinsics.checkNotNullParameter((Object)mojangJar, (String)"mojangJar");
        Intrinsics.checkNotNullParameter((Object)minecraftVersion2, (String)"minecraftVersion");
        this.paperclip = paperclip;
        this.outputJar = outputJar;
        this.mojangJar = mojangJar;
        this.minecraftVersion = minecraftVersion2;
        this.bundler = bundler;
        this.name = "apply mojang mapped paperclip patch";
        this.hashFile = UtilsKt.siblingHashesFile(this.outputJar);
    }

    public /* synthetic */ RunPaperclip(Path path, Path path2, Path path3, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        this(path, path2, path3, string, bl);
    }
}

