/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.userdev.internal.setup;

import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.tasks.GenerateDevBundle;
import io.papermc.paperweight.userdev.internal.setup.ExtractedBundle;
import io.papermc.paperweight.userdev.internal.setup.v2.DevBundleV2;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.UtilsKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u001a\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0002\"\"\u0010\u0000\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"supported", "", "", "Lkotlin/reflect/KClass;", "", "extractDevBundle", "Lio/papermc/paperweight/userdev/internal/setup/ExtractedBundle;", "destinationDirectory", "Ljava/nio/file/Path;", "devBundle", "readDevBundle", "Lkotlin/Pair;", "extractedDevBundlePath", "paperweight-userdev"})
public final class ExtractDevBundleKt {
    private static final Map<Integer, KClass<? extends Object>> supported = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)2, (Object)Reflection.getOrCreateKotlinClass(DevBundleV2.Config.class)), TuplesKt.to((Object)3, (Object)Reflection.getOrCreateKotlinClass(GenerateDevBundle.DevBundleConfig.class))});

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ExtractedBundle<Object> extractDevBundle(@NotNull Path destinationDirectory, @NotNull Path devBundle) {
        Intrinsics.checkNotNullParameter((Object)destinationDirectory, (String)"destinationDirectory");
        Intrinsics.checkNotNullParameter((Object)devBundle, (String)"devBundle");
        Path hashFile = destinationDirectory.resolve("current.sha256");
        String newDevBundleHash = FileKt.sha256asHex(devBundle);
        Object object = destinationDirectory;
        Object object2 = new LinkOption[]{};
        boolean bl = false;
        if (Files.exists((Path)object, Arrays.copyOf(object2, ((LinkOption[])object2).length))) {
            Path path = hashFile;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"hashFile");
            object2 = path;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            boolean bl2 = false;
            String currentDevBundleHash = Files.isRegularFile((Path)object2, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? PathsKt.readText((Path)hashFile, (Charset)Charsets.UTF_8) : "";
            object2 = currentDevBundleHash;
            bl = false;
            if (!StringsKt.isBlank((CharSequence)object2) && Intrinsics.areEqual((Object)newDevBundleHash, (Object)currentDevBundleHash)) {
                return new ExtractedBundle<Object>(false, ExtractDevBundleKt.readDevBundle(destinationDirectory), destinationDirectory);
            }
            FileKt.deleteRecursively$default(destinationDirectory, null, 1, null);
        }
        object = destinationDirectory;
        object2 = new FileAttribute[]{};
        bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object, (FileAttribute[])Arrays.copyOf(object2, ((LinkOption[])object2).length)), (String)"Files.createDirectories(this, *attributes)");
        Path path = hashFile;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"hashFile");
        PathsKt.writeText((Path)path, (CharSequence)newDevBundleHash, (Charset)Charsets.UTF_8, (OpenOption[])new OpenOption[0]);
        object = FileKt.openZip(devBundle);
        boolean bl3 = false;
        bl = false;
        Throwable throwable = null;
        try {
            FileSystem fs = (FileSystem)object;
            boolean bl4 = false;
            Path path2 = fs.getPath("/", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"fs.getPath(\"/\")");
            FileKt.copyRecursivelyTo(path2, destinationDirectory);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return new ExtractedBundle<Object>(true, ExtractDevBundleKt.readDevBundle(destinationDirectory), destinationDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Pair<Object, Integer> readDevBundle(Path extractedDevBundlePath) {
        Path configFile;
        Path path = extractedDevBundlePath.resolve("data-version.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"extractedDevBundlePath.resolve(\"data-version.txt\")");
        Object object = PathsKt.readText$default((Path)path, null, (int)1, null);
        boolean bl = false;
        String string = object;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        object = ((Object)StringsKt.trim((CharSequence)string)).toString();
        bl = false;
        int dataVersion = Integer.parseInt((String)object);
        object = supported;
        Integer n = dataVersion;
        boolean bl2 = false;
        Object object2 = object;
        boolean bl3 = false;
        if (!object2.containsKey(n)) {
            throw (Throwable)new PaperweightException("The paperweight development bundle you are attempting to use is of data version '" + dataVersion + "', but" + " the currently running version of paperweight only supports data versions '" + supported + "'.");
        }
        KClass<? extends Object> kClass = supported.get(dataVersion);
        if (kClass == null) {
            throw (Throwable)new PaperweightException("Could not find config class for version " + dataVersion + '?');
        }
        KClass<? extends Object> configClass = kClass;
        Path path2 = configFile = extractedDevBundlePath.resolve("config.json");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"configFile");
        object2 = path2;
        Charset charset = Charsets.UTF_8;
        Object object3 = new OpenOption[]{};
        int n2 = 8192;
        boolean bl4 = false;
        object2 = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)object2, Arrays.copyOf(object3, ((OpenOption[])object3).length)), charset), n2);
        boolean bl5 = false;
        n2 = 0;
        Throwable throwable = null;
        try {
            BufferedReader reader = (BufferedReader)object2;
            boolean bl6 = false;
            object3 = UtilsKt.getGson().fromJson((Reader)reader, JvmClassMappingKt.getJavaClass(configClass));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"configFile.bufferedReade\u2026, configClass.java)\n    }");
        Object config = object3;
        return TuplesKt.to((Object)config, (Object)dataVersion);
    }
}

