/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks.patchremap;

import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.util.Command;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.Git;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bJ\u0006\u0010\u0013\u001a\u00020\u0011J\u0006\u0010\u0014\u001a\u00020\u0011J\b\u0010\u0015\u001a\u00020\u0011H\u0002J\u0006\u0010\u0016\u001a\u00020\u0011J\u0006\u0010\u0017\u001a\u00020\u0011J\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0003J\u0006\u0010\u001a\u001a\u00020\u0011J\u000e\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\bJ\u0006\u0010\u001d\u001a\u00020\u0006J\u0006\u0010\u001e\u001a\u00020\u0011R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/papermc/paperweight/tasks/patchremap/PatchApplier;", "", "remappedBranch", "", "unmappedBranch", "ignoreGitIgnore", "", "targetDir", "Ljava/nio/file/Path;", "(Ljava/lang/String;Ljava/lang/String;ZLjava/nio/file/Path;)V", "commitAuthor", "commitMessage", "commitTime", "git", "Lio/papermc/paperweight/util/Git;", "remappedBaseTag", "applyPatch", "", "patch", "checkoutOld", "checkoutRemapped", "clearCommit", "commitChanges", "commitInitialRemappedSource", "commitPlain", "message", "createBranches", "generatePatches", "target", "isUnfinishedPatch", "recordCommit", "paperweight-lib"})
public final class PatchApplier {
    private final Git git;
    private String commitMessage;
    private String commitAuthor;
    private String commitTime;
    private final String remappedBaseTag;
    private final String remappedBranch;
    private final String unmappedBranch;
    private final boolean ignoreGitIgnore;

    public final void checkoutRemapped() {
        String string = "Switching to " + this.remappedBranch + " without losing changes";
        boolean bl = false;
        System.out.println((Object)string);
        Command.executeSilently$default(this.git.invoke("symbolic-ref", "HEAD", "refs/heads/" + this.remappedBranch), false, false, 3, null);
    }

    public final void checkoutOld() {
        String string = "Resetting back to " + this.unmappedBranch + " branch";
        boolean bl = false;
        System.out.println((Object)string);
        Command.executeSilently$default(this.git.invoke("checkout", this.unmappedBranch), false, false, 3, null);
    }

    public final void commitPlain(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String[] stringArray = Git.Companion.add(this.ignoreGitIgnore, ".");
        Command.executeSilently$default(this.git.invoke(Arrays.copyOf(stringArray, stringArray.length)), false, false, 3, null);
        Command.executeSilently$default(this.git.invoke("commit", "-m", message, "--author=Initial <auto@mated.null>"), false, false, 3, null);
    }

    public final void createBranches() {
        Command.executeSilently$default(this.git.invoke("checkout", "-b", this.unmappedBranch), false, false, 3, null);
        Command.executeSilently$default(this.git.invoke("branch", this.remappedBranch), false, false, 3, null);
    }

    public final void commitInitialRemappedSource() {
        String[] stringArray = Git.Companion.add(this.ignoreGitIgnore, ".");
        Command.executeSilently$default(this.git.invoke(Arrays.copyOf(stringArray, stringArray.length)), false, false, 3, null);
        Command.executeSilently$default(this.git.invoke("commit", "-m", "Initial Remapped Source", "--author=Initial <auto@mated.null>"), false, false, 3, null);
        Command.executeSilently$default(this.git.invoke("tag", this.remappedBaseTag), false, false, 3, null);
    }

    public final void recordCommit() {
        this.commitMessage = this.git.invoke("log", "--format=%B", "-n", "1", "HEAD").getText();
        this.commitAuthor = this.git.invoke("log", "--format=%an <%ae>", "-n", "1", "HEAD").getText();
        this.commitTime = this.git.invoke("log", "--format=%aD", "-n", "1", "HEAD").getText();
    }

    private final void clearCommit() {
        this.commitMessage = null;
        this.commitAuthor = null;
        this.commitTime = null;
    }

    public final void commitChanges() {
        String string = "Committing remapped changes to " + this.remappedBranch;
        boolean bl = false;
        System.out.println((Object)string);
        String string2 = this.commitMessage;
        if (string2 == null) {
            throw (Throwable)new PaperweightException("commitMessage not set");
        }
        String message = string2;
        String string3 = this.commitAuthor;
        if (string3 == null) {
            throw (Throwable)new PaperweightException("commitAuthor not set");
        }
        String author = string3;
        String string4 = this.commitTime;
        if (string4 == null) {
            throw (Throwable)new PaperweightException("commitTime not set");
        }
        String time = string4;
        this.clearCommit();
        String[] stringArray = Git.Companion.add(this.ignoreGitIgnore, ".");
        Command.executeSilently$default(this.git.invoke(Arrays.copyOf(stringArray, stringArray.length)), false, false, 3, null);
        this.git.invoke("commit", "-m", message, "--author=" + author, "--date=" + time).execute();
    }

    public final void applyPatch(@NotNull Path patch) {
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        String[] stringArray = new String[4];
        stringArray[0] = "am";
        stringArray[1] = "--3way";
        stringArray[2] = "--ignore-whitespace";
        Path path = patch;
        boolean bl = false;
        stringArray[3] = ((Object)path.toAbsolutePath()).toString();
        int result = this.git.invoke(stringArray).runOut();
        if (result != 0) {
            throw (Throwable)new RuntimeException("Patch failed to apply: " + patch);
        }
    }

    public final void generatePatches(@NotNull Path target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        FileKt.deleteRecursively$default(target, null, 1, null);
        Path path = target;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"Files.createDirectories(this, *attributes)");
        Command.executeSilently$default(this.git.invoke("checkout", this.remappedBranch), false, false, 3, null);
        String[] stringArray = new String[9];
        stringArray[0] = "format-patch";
        stringArray[1] = "--zero-commit";
        stringArray[2] = "--full-index";
        stringArray[3] = "--no-signature";
        stringArray[4] = "--no-stat";
        stringArray[5] = "-N";
        stringArray[6] = "-o";
        path = target;
        boolean bl2 = false;
        stringArray[7] = ((Object)path.toAbsolutePath()).toString();
        stringArray[8] = this.remappedBaseTag;
        this.git.invoke(stringArray).executeOut();
    }

    public final boolean isUnfinishedPatch() {
        String string = this.git.invoke("branch", "--show-current").getText();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string2)).toString(), (Object)this.unmappedBranch) ^ true) {
            return false;
        }
        Command.executeSilently$default(this.git.invoke("update-index", "--refresh"), false, false, 3, null);
        if (Command.runSilently$default(this.git.invoke("diff-index", "--quiet", "HEAD", "--"), false, false, 3, null) == 0) {
            string = this.git.invoke("log", this.unmappedBranch, "-1", "--pretty=%B").getText();
            bl = false;
            String string3 = string;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = this.git.invoke("log", this.remappedBranch, "-1", "--pretty=%B").getText();
            bl = false;
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            return Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string3)).toString(), (Object)((Object)StringsKt.trim((CharSequence)string4)).toString()) ^ true;
        }
        throw (Throwable)new PaperweightException("Unknown state: repo has uncommitted changes");
    }

    public PatchApplier(@NotNull String remappedBranch, @NotNull String unmappedBranch, boolean ignoreGitIgnore, @NotNull Path targetDir) {
        Intrinsics.checkNotNullParameter((Object)remappedBranch, (String)"remappedBranch");
        Intrinsics.checkNotNullParameter((Object)unmappedBranch, (String)"unmappedBranch");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        this.remappedBranch = remappedBranch;
        this.unmappedBranch = unmappedBranch;
        this.ignoreGitIgnore = ignoreGitIgnore;
        this.git = new Git(targetDir, null, 2, null);
        this.remappedBaseTag = "remapped-base";
    }
}

