/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.tasks.LineMapJarAction;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.UtilsKt;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.JavaForkOptions;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u001a>\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n\u001a(\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f0\u000e2\u0006\u0010\u0011\u001a\u00020\nH\u0002\u00a8\u0006\u0012"}, d2={"lineMapJar", "Lorg/gradle/workers/WorkQueue;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "jvmArgs", "", "", "launcher", "Lorg/gradle/jvm/toolchain/JavaLauncher;", "inputJarPath", "Ljava/nio/file/Path;", "outputJarPath", "decompileJarPath", "readLineMap", "", "Ljava/util/NavigableMap;", "", "decompileJar", "paperweight-lib"})
public final class LineMapJarKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final WorkQueue lineMapJar(@NotNull WorkerExecutor workerExecutor, @NotNull List<String> jvmArgs, @NotNull JavaLauncher launcher, @NotNull Path inputJarPath, @NotNull Path outputJarPath, @NotNull Path decompileJarPath) {
        void workActionClass$iv;
        void $this$submit$iv;
        WorkQueue queue2;
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        Intrinsics.checkNotNullParameter(jvmArgs, (String)"jvmArgs");
        Intrinsics.checkNotNullParameter((Object)launcher, (String)"launcher");
        Intrinsics.checkNotNullParameter((Object)inputJarPath, (String)"inputJarPath");
        Intrinsics.checkNotNullParameter((Object)outputJarPath, (String)"outputJarPath");
        Intrinsics.checkNotNullParameter((Object)decompileJarPath, (String)"decompileJarPath");
        UtilsKt.ensureParentExists(outputJarPath);
        UtilsKt.ensureDeleted(outputJarPath);
        WorkQueue workQueue = queue2 = workerExecutor.processIsolation(new Action(jvmArgs, launcher){
            final /* synthetic */ List $jvmArgs;
            final /* synthetic */ JavaLauncher $launcher;

            public final void execute(@NotNull ProcessWorkerSpec $this$processIsolation) {
                Intrinsics.checkNotNullParameter((Object)$this$processIsolation, (String)"$receiver");
                $this$processIsolation.getForkOptions().jvmArgs((Iterable)this.$jvmArgs);
                JavaForkOptions javaForkOptions = $this$processIsolation.getForkOptions();
                RegularFile regularFile = this.$launcher.getExecutablePath();
                Intrinsics.checkNotNullExpressionValue((Object)regularFile, (String)"launcher.executablePath");
                Path path = FileKt.getPath((FileSystemLocation)regularFile);
                boolean bl = false;
                javaForkOptions.executable((Object)((Object)path.toAbsolutePath()).toString());
            }
            {
                this.$jvmArgs = list;
                this.$launcher = javaLauncher;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)workQueue, (String)"queue");
        WorkQueue workQueue2 = workQueue;
        Class<LineMapJarAction> clazz = LineMapJarAction.class;
        Action parameterAction$iv = new Action(inputJarPath, outputJarPath, decompileJarPath){
            final /* synthetic */ Path $inputJarPath;
            final /* synthetic */ Path $outputJarPath;
            final /* synthetic */ Path $decompileJarPath;

            public final void execute(@NotNull LineMapJarAction.Parameters $this$submit) {
                Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$receiver");
                FileKt.set((FileSystemLocationProperty)$this$submit.getInputJar(), this.$inputJarPath);
                FileKt.set((FileSystemLocationProperty)$this$submit.getOutputJar(), this.$outputJarPath);
                FileKt.set((FileSystemLocationProperty)$this$submit.getDecompileJar(), this.$decompileJarPath);
            }
            {
                this.$inputJarPath = path;
                this.$outputJarPath = path2;
                this.$decompileJarPath = path3;
            }
        };
        boolean $i$f$submit = false;
        $this$submit$iv.submit((Class)workActionClass$iv, parameterAction$iv);
        return queue2;
    }

    public static /* synthetic */ WorkQueue lineMapJar$default(WorkerExecutor workerExecutor, List list, JavaLauncher javaLauncher, Path path, Path path2, Path path3, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.arrayListOf((Object[])new String[]{"-Xmx512m"});
        }
        return LineMapJarKt.lineMapJar(workerExecutor, list, javaLauncher, path, path2, path3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Map<String, NavigableMap<Integer, Integer>> readLineMap(Path decompileJar) {
        Map classes = new HashMap();
        try {
            Object object = decompileJar;
            OpenOption[] openOptionArray = new OpenOption[]{};
            boolean bl = false;
            InputStream inputStream = Files.newInputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"Files.newInputStream(this, *options)");
            object = inputStream;
            boolean bl2 = false;
            bl = false;
            Throwable throwable = null;
            try {
                InputStream fis = (InputStream)object;
                boolean bl3 = false;
                Closeable closeable = new ZipInputStream(fis);
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    ZipInputStream zip = (ZipInputStream)closeable;
                    boolean bl6 = false;
                    ZipEntry entry = zip.getNextEntry();
                    while (entry != null) {
                        ByteBuffer buf;
                        byte[] extra;
                        block24: {
                            block23: {
                                extra = entry.getExtra();
                                if (extra == null) break block23;
                                String string = entry.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
                                if (StringsKt.endsWith$default((String)string, (String)".java", (boolean)false, (int)2, null)) break block24;
                            }
                            entry = zip.getNextEntry();
                            continue;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)ByteBuffer.wrap(extra), (String)"ByteBuffer.wrap(extra)");
                        buf.order(ByteOrder.LITTLE_ENDIAN);
                        while (buf.hasRemaining()) {
                            short id = buf.getShort();
                            short len = buf.getShort();
                            if (id == 17990) {
                                String cls;
                                String string;
                                Intrinsics.checkNotNullExpressionValue((Object)entry.getName(), (String)"entry.name");
                                int n = 0;
                                int n2 = entry.getName().length() - 5;
                                int n3 = 0;
                                String string2 = string;
                                if (string2 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                                }
                                Intrinsics.checkNotNullExpressionValue((Object)string2.substring(n, n2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                byte ver = buf.get();
                                if (ver != (byte)1) {
                                    throw (Throwable)new PaperweightException("Wrong FF code line version for " + entry.getName() + " (got " + ver + ", expected 1)");
                                }
                                int count = (len - 1) / 4;
                                NavigableMap lines = new TreeMap();
                                n3 = 0;
                                int n4 = count;
                                while (n3 < n4) {
                                    void x;
                                    short oldLine = buf.getShort();
                                    short newLine = buf.getShort();
                                    ((Map)lines).put(Integer.valueOf(oldLine), Integer.valueOf(newLine));
                                    ++x;
                                }
                                classes.put(cls, lines);
                                continue;
                            }
                            buf.position(buf.position() + len);
                        }
                        entry = zip.getNextEntry();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        catch (Exception ex) {
            throw (Throwable)new PaperweightException("Could not read line maps from decompiled jar: " + decompileJar, ex);
        }
        return classes;
    }

    public static final /* synthetic */ Map access$readLineMap(Path decompileJar) {
        return LineMapJarKt.readLineMap(decompileJar);
    }
}

