/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.util.AsmUtil;
import io.papermc.paperweight.util.ClassNodeCache;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import paper.libs.org.objectweb.asm.tree.AbstractInsnNode;
import paper.libs.org.objectweb.asm.tree.ClassNode;
import paper.libs.org.objectweb.asm.tree.FieldInsnNode;
import paper.libs.org.objectweb.asm.tree.FieldNode;
import paper.libs.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/papermc/paperweight/tasks/FieldAccessNormalizer;", "Lio/papermc/paperweight/util/AsmUtil;", "node", "Lpaper/libs/org/objectweb/asm/tree/ClassNode;", "classNodeCache", "Lio/papermc/paperweight/util/ClassNodeCache;", "(Lorg/objectweb/asm/tree/ClassNode;Lio/papermc/paperweight/util/ClassNodeCache;)V", "findTargetFieldDeclaration", "instruction", "Lpaper/libs/org/objectweb/asm/tree/FieldInsnNode;", "visitFieldInst", "", "visitMethod", "method", "Lpaper/libs/org/objectweb/asm/tree/MethodNode;", "visitNode", "paperweight-lib"})
public final class FieldAccessNormalizer
implements AsmUtil {
    private final ClassNode node;
    private final ClassNodeCache classNodeCache;

    public final void visitNode() {
        Iterator<MethodNode> iterator = this.node.methods.iterator();
        while (iterator.hasNext()) {
            MethodNode method;
            MethodNode methodNode = method = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)methodNode, (String)"method");
            this.visitMethod(methodNode);
        }
    }

    private final void visitMethod(MethodNode method) {
        for (AbstractInsnNode instruction : method.instructions) {
            FieldInsnNode fieldInst;
            AbstractInsnNode abstractInsnNode = instruction;
            if (!(abstractInsnNode instanceof FieldInsnNode)) {
                abstractInsnNode = null;
            }
            if ((FieldInsnNode)abstractInsnNode == null) {
                continue;
            }
            this.visitFieldInst(fieldInst);
        }
    }

    private final void visitFieldInst(FieldInsnNode instruction) {
        ClassNode classNode = this.findTargetFieldDeclaration(instruction);
        if (classNode == null) {
            return;
        }
        ClassNode ownerNode = classNode;
        instruction.owner = ownerNode.name;
    }

    private final ClassNode findTargetFieldDeclaration(FieldInsnNode instruction) {
        String fieldName = instruction.name;
        String className = instruction.owner;
        while (className != null) {
            Object v1;
            ClassNode currentNode;
            block13: {
                if (this.classNodeCache.findClass(className) == null) {
                    return null;
                }
                List<FieldNode> list = currentNode.fields;
                Intrinsics.checkNotNullExpressionValue(list, (String)"currentNode.fields");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FieldNode it = (FieldNode)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.name, (Object)fieldName)) continue;
                    v1 = element$iv;
                    break block13;
                }
                v1 = null;
            }
            FieldNode fieldNode = v1;
            if (fieldNode != null) {
                if (this.contains(fieldNode.access, 2)) {
                    if (Intrinsics.areEqual((Object)currentNode.name, (Object)this.node.name)) {
                        return currentNode;
                    }
                } else if (this.contains(fieldNode.access, 4)) {
                    ClassNode walkingNode = this.node;
                    while (walkingNode != null) {
                        if (Intrinsics.areEqual((Object)walkingNode.name, (Object)currentNode.name)) {
                            return currentNode;
                        }
                        walkingNode = this.classNodeCache.findClass(walkingNode.superName);
                    }
                } else {
                    if (this.contains(fieldNode.access, 1)) {
                        return currentNode;
                    }
                    String string = currentNode.name;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentNode.name");
                    String currentPackage = StringsKt.substringBeforeLast$default((String)string, (char)'/', null, (int)2, null);
                    String string2 = this.node.name;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"node.name");
                    String originalPackage = StringsKt.substringBeforeLast$default((String)string2, (char)'/', null, (int)2, null);
                    if (Intrinsics.areEqual((Object)currentPackage, (Object)originalPackage)) {
                        return currentNode;
                    }
                }
            }
            className = currentNode.superName;
        }
        return null;
    }

    public FieldAccessNormalizer(@NotNull ClassNode node, @NotNull ClassNodeCache classNodeCache) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)classNodeCache, (String)"classNodeCache");
        this.node = node;
        this.classNodeCache = classNodeCache;
    }
}

