/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.tasks.ControllableOutputTask;
import io.papermc.paperweight.util.Command;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.Git;
import io.papermc.paperweight.util.UtilsKt;
import java.io.Closeable;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0005\u001a4\u0010\n\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000f\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\u0003\u00a8\u0006\u0011"}, d2={"checkoutRepoFromUpstream", "", "git", "Lio/papermc/paperweight/util/Git;", "upstream", "Ljava/nio/file/Path;", "upstreamBranch", "", "recreateCloneDirectory", "target", "applyGitPatches", "Lio/papermc/paperweight/tasks/ControllableOutputTask;", "outputDir", "patchDir", "printOutput", "", "disableAutoGpgSigningInRepo", "paperweight-lib"})
public final class ApplyGitPatchesKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void applyGitPatches(@NotNull ControllableOutputTask $this$applyGitPatches, @NotNull Git git, @NotNull String target, @NotNull Path outputDir, @Nullable Path patchDir, boolean printOutput) {
        Iterable<Path> patches;
        boolean bl;
        Object object;
        boolean bl2;
        Object object2;
        boolean bl3;
        FileAttribute[] fileAttributeArray;
        Path statusFile;
        block21: {
            Iterable<Path> iterable;
            block20: {
                Iterable iterable2;
                Intrinsics.checkNotNullParameter((Object)((Object)$this$applyGitPatches), (String)"$this$applyGitPatches");
                Intrinsics.checkNotNullParameter((Object)git, (String)"git");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
                if (printOutput) {
                    String string = "   Applying patches to " + target + "...";
                    boolean bl4 = false;
                    System.out.println((Object)string);
                }
                Path path = statusFile = outputDir.resolve(".git/patch-apply-failed");
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"statusFile");
                FileKt.deleteForcefully(path);
                Command.runSilently$default(git.invoke("am", "--abort"), false, true, 1, null);
                iterable = patchDir;
                if (iterable == null) break block20;
                Path path2 = iterable;
                fileAttributeArray = "*.patch";
                bl3 = false;
                object2 = (FileAttribute[])Files.newDirectoryStream(path2, (String)fileAttributeArray);
                bl2 = false;
                boolean bl5 = false;
                object = null;
                try {
                    Iterable iterable3 = (DirectoryStream)object2;
                    bl = false;
                    DirectoryStream directoryStream = iterable3;
                    Intrinsics.checkNotNullExpressionValue((Object)directoryStream, (String)"it");
                    Sequence it = CollectionsKt.asSequence((Iterable)directoryStream);
                    boolean bl6 = false;
                    iterable3 = SequencesKt.toMutableList((Sequence)it);
                    iterable2 = iterable3;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
                }
                iterable = iterable2;
                if (iterable2 != null) break block21;
            }
            boolean bl7 = false;
            iterable = patches = (List)new ArrayList();
        }
        if (patches.isEmpty()) {
            if (printOutput) {
                String string = "No patches found";
                boolean bl8 = false;
                System.out.println((Object)string);
            }
            return;
        }
        Path path = UtilsKt.getCache($this$applyGitPatches.getLayout());
        fileAttributeArray = new FileAttribute[]{};
        bl3 = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"Files.createDirectories(this, *attributes)");
        Path tempDir = PathsKt.createTempDirectory((Path)UtilsKt.getCache($this$applyGitPatches.getLayout()), (String)"paperweight", (FileAttribute[])new FileAttribute[0]);
        try {
            Path mailDir;
            Path path3 = mailDir = tempDir.resolve("new");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"mailDir");
            Object object3 = path3;
            object2 = new FileAttribute[]{};
            bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object3, Arrays.copyOf(object2, ((FileAttribute[])object2).length)), (String)"Files.createDirectories(this, *attributes)");
            object2 = patches.iterator();
            while (object2.hasNext()) {
                Path patch;
                Path path4 = patch = (Path)object2.next();
                Intrinsics.checkNotNullExpressionValue((Object)mailDir.resolve(patch.getFileName()), (String)"mailDir.resolve(patch.fileName)");
                boolean bl9 = false;
                bl = false;
                CopyOption[] copyOptionArray = new CopyOption[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path4, (Path)object, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"Files.copy(this, target, *options)");
            }
            String[] stringArray = new String[4];
            stringArray[0] = "am";
            stringArray[1] = "--3way";
            stringArray[2] = "--ignore-whitespace";
            object3 = tempDir;
            boolean bl10 = false;
            stringArray[3] = ((Object)object3.toAbsolutePath()).toString();
            if ($this$applyGitPatches.showErrors(git.invoke(stringArray)).run() != 0) {
                PathsKt.writeText$default((Path)statusFile, (CharSequence)"1", null, (OpenOption[])new OpenOption[0], (int)2, null);
                $this$applyGitPatches.getLogger().error("***   Please review above details and finish the apply then");
                $this$applyGitPatches.getLogger().error("***   save the changes with `./gradlew rebuildPatches`");
                throw (Throwable)new PaperweightException("Failed to apply patches");
            }
            FileKt.deleteForcefully(statusFile);
            if (printOutput) {
                object3 = "   Patches applied cleanly to " + target;
                bl10 = false;
                System.out.println(object3);
            }
        }
        finally {
            FileKt.deleteRecursively$default(tempDir, null, 1, null);
        }
    }

    public static final void disableAutoGpgSigningInRepo(@NotNull Git $this$disableAutoGpgSigningInRepo) {
        Intrinsics.checkNotNullParameter((Object)$this$disableAutoGpgSigningInRepo, (String)"$this$disableAutoGpgSigningInRepo");
        Command.executeSilently$default($this$disableAutoGpgSigningInRepo.invoke("config", "commit.gpgSign", "false"), false, true, 1, null);
        Command.executeSilently$default($this$disableAutoGpgSigningInRepo.invoke("config", "tag.gpgSign", "false"), false, true, 1, null);
    }

    public static final void checkoutRepoFromUpstream(@NotNull Git git, @NotNull Path upstream, @NotNull String upstreamBranch) {
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        Intrinsics.checkNotNullParameter((Object)upstream, (String)"upstream");
        Intrinsics.checkNotNullParameter((Object)upstreamBranch, (String)"upstreamBranch");
        Command.executeSilently$default(git.invoke("init", "--quiet"), false, true, 1, null);
        ApplyGitPatchesKt.disableAutoGpgSigningInRepo(git);
        Command.runSilently$default(git.invoke("remote", "remove", "upstream"), false, true, 1, null);
        String[] stringArray = new String[4];
        stringArray[0] = "remote";
        stringArray[1] = "add";
        stringArray[2] = "upstream";
        String string = upstream.toUri().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"upstream.toUri().toString()");
        stringArray[3] = string;
        Command.executeSilently$default(git.invoke(stringArray), false, true, 1, null);
        Command.executeSilently$default(git.invoke("fetch", "upstream", "--prune"), false, true, 1, null);
        if (Command.runSilently$default(git.invoke("checkout", "master"), false, true, 1, null) != 0) {
            Command.runSilently$default(git.invoke("checkout", "-b", "master"), false, true, 1, null);
        }
        Command.executeSilently$default(git.invoke("reset", "--hard", "upstream/" + upstreamBranch), false, true, 1, null);
        Command.runSilently$default(git.invoke("gc"), false, true, 1, null);
    }

    public static final void recreateCloneDirectory(@NotNull Path target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Path path = target;
        Object object = new LinkOption[]{};
        boolean bl = false;
        if (Files.exists(path, Arrays.copyOf(object, ((LinkOption[])object).length))) {
            Path path2 = target.resolve(".git");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"target.resolve(\".git\")");
            path = path2;
            object = new LinkOption[]{};
            bl = false;
            if (Files.isDirectory(path, (LinkOption[])Arrays.copyOf(object, ((Object[])object).length))) {
                Git git = new Git(target, null, 2, null);
                Command.runSilently$default(git.invoke("clean", "-fxd"), false, true, 1, null);
                Command.runSilently$default(git.invoke("reset", "--hard", "HEAD"), false, true, 1, null);
            } else {
                for (Path entry : PathsKt.listDirectoryEntries$default((Path)target, null, (int)1, null)) {
                    FileKt.deleteRecursively$default(entry, null, 1, null);
                }
                path = target;
                object = new FileAttribute[]{};
                bl = false;
                Object object2 = object;
                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path, (FileAttribute[])Arrays.copyOf(object2, ((Object)object2).length)), (String)"Files.createDirectories(this, *attributes)");
            }
        } else {
            path = target;
            object = new FileAttribute[]{};
            bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path, (FileAttribute[])Arrays.copyOf(object, ((Object[])object).length)), (String)"Files.createDirectories(this, *attributes)");
        }
    }
}

