/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight;

import io.papermc.paperweight.DownloadService;
import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.util.UtilsKt;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.jetbrains.annotations.NotNull;
import paper.libs.org.apache.http.Header;
import paper.libs.org.apache.http.HttpEntity;
import paper.libs.org.apache.http.HttpHost;
import paper.libs.org.apache.http.StatusLine;
import paper.libs.org.apache.http.client.config.RequestConfig;
import paper.libs.org.apache.http.client.methods.CloseableHttpResponse;
import paper.libs.org.apache.http.client.methods.HttpGet;
import paper.libs.org.apache.http.client.utils.DateUtils;
import paper.libs.org.apache.http.impl.client.CloseableHttpClient;
import paper.libs.org.apache.http.impl.client.HttpClientBuilder;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/papermc/paperweight/DownloadService;", "Lorg/gradle/api/services/BuildService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "Ljava/lang/AutoCloseable;", "()V", "httpClient", "Lpaper/libs/org/apache/http/impl/client/CloseableHttpClient;", "close", "", "download", "source", "Ljava/net/URL;", "target", "Ljava/nio/file/Path;", "", "handleResponse", "Ljava/time/Instant;", "response", "Lpaper/libs/org/apache/http/client/methods/CloseableHttpResponse;", "saveEtag", "lastModified", "etagFile", "paperweight-lib"})
public abstract class DownloadService
implements BuildService<BuildServiceParameters.None>,
AutoCloseable {
    private final CloseableHttpClient httpClient;

    public final void download(@NotNull Object source, @NotNull Object target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        URL url = UtilsKt.convertToUrl(source);
        Path file = UtilsKt.convertToPath(target);
        this.download(url, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void download(URL source, Path target) {
        Instant instant;
        Path etagFile;
        Path etagDir;
        Path path = target.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"target.parent");
        Path path2 = path;
        Object object = new FileAttribute[]{};
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(object, ((FileAttribute[])object).length)), (String)"Files.createDirectories(this, *attributes)");
        Path path3 = etagDir = target.resolveSibling("etags");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"etagDir");
        object = path3;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"Files.createDirectories(this, *attributes)");
        Path path4 = etagFile = etagDir.resolve(PathsKt.getName((Path)target) + ".etag");
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"etagFile");
        Path path5 = path4;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean bl3 = false;
        String etag = Files.exists(path5, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? PathsKt.readText$default((Path)etagFile, null, (int)1, null) : null;
        HttpHost host = new HttpHost(source.getHost(), source.getPort(), source.getProtocol());
        Path path6 = target;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        boolean bl4 = false;
        if (Files.exists(path6, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            path6 = target;
            linkOptionArray2 = new LinkOption[]{};
            bl4 = false;
            FileTime fileTime = Files.getLastModifiedTime(path6, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"Files.getLastModifiedTime(this, *options)");
            instant = fileTime.toInstant();
        } else {
            instant = Instant.EPOCH;
        }
        Instant time = instant;
        HttpGet httpGet = new HttpGet(source.getFile());
        int timeouts = (int)TimeUnit.MINUTES.toMillis(5L);
        httpGet.setConfig(RequestConfig.custom().setConnectTimeout(timeouts).setConnectionRequestTimeout(timeouts).setSocketTimeout(timeouts).setCookieSpec("standard").build());
        Object object2 = target;
        LinkOption[] linkOptionArray3 = new LinkOption[]{};
        boolean bl5 = false;
        if (Files.exists((Path)object2, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
            if (Intrinsics.areEqual((Object)time, (Object)Instant.EPOCH) ^ true) {
                String value = DateTimeFormatter.RFC_1123_DATE_TIME.format(time.atZone(ZoneOffset.UTC));
                httpGet.setHeader("If-Modified-Since", value);
            }
            if (etag != null) {
                httpGet.setHeader("If-None-Match", etag);
            }
        }
        object2 = this.httpClient.execute(host, httpGet);
        boolean bl6 = false;
        bl5 = false;
        Throwable throwable = null;
        try {
            int code;
            CloseableHttpResponse response = (CloseableHttpResponse)object2;
            boolean bl7 = false;
            CloseableHttpResponse closeableHttpResponse = response;
            Intrinsics.checkNotNullExpressionValue((Object)closeableHttpResponse, (String)"response");
            StatusLine statusLine = closeableHttpResponse.getStatusLine();
            Intrinsics.checkNotNullExpressionValue((Object)statusLine, (String)"response.statusLine");
            int n = code = statusLine.getStatusCode();
            if (200 > n || 299 < n) {
                if (code != 304) {
                    StatusLine statusLine2 = response.getStatusLine();
                    Intrinsics.checkNotNullExpressionValue((Object)statusLine2, (String)"response.statusLine");
                    String reason = statusLine2.getReasonPhrase();
                    throw (Throwable)new PaperweightException("Download failed, HTTP code: " + code + "; URL: " + source + "; Reason: " + reason);
                }
            }
            Instant lastModified = this.handleResponse(response, target);
            this.saveEtag(response, lastModified, target, etagFile);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Instant handleResponse(CloseableHttpResponse response, Path target) {
        boolean bl;
        Instant instant;
        Header header = response.getLastHeader("Last-Modified");
        boolean bl2 = false;
        boolean bl3 = false;
        Header $this$with = header;
        boolean bl4 = false;
        if ($this$with == null) {
            instant = Instant.EPOCH;
        } else {
            CharSequence charSequence = $this$with.getValue();
            boolean bl5 = false;
            bl = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                instant = Instant.EPOCH;
            } else {
                instant = DateUtils.parseDate($this$with.getValue()).toInstant();
                if (instant == null) {
                    instant = Instant.EPOCH;
                }
            }
        }
        Instant lastModified = instant;
        StatusLine statusLine = response.getStatusLine();
        Intrinsics.checkNotNullExpressionValue((Object)statusLine, (String)"response.statusLine");
        if (statusLine.getStatusCode() == 304) {
            Instant instant2 = lastModified;
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"lastModified");
            return instant2;
        }
        HttpEntity httpEntity = response.getEntity();
        if (httpEntity == null) {
            Instant instant3 = lastModified;
            Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"lastModified");
            return instant3;
        }
        HttpEntity entity = httpEntity;
        Object object = target;
        OpenOption[] openOptionArray = new OpenOption[]{};
        boolean bl6 = false;
        OutputStream outputStream = Files.newOutputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"Files.newOutputStream(this, *options)");
        object = outputStream;
        boolean bl7 = false;
        bl6 = false;
        Throwable throwable = null;
        try {
            long l;
            OutputStream output = (OutputStream)object;
            boolean bl8 = false;
            Closeable closeable = entity.getContent();
            bl = false;
            boolean bl9 = false;
            Throwable throwable2 = null;
            try {
                InputStream input = (InputStream)closeable;
                boolean bl10 = false;
                InputStream inputStream = input;
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"input");
                l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)output, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        Instant instant4 = lastModified;
        Intrinsics.checkNotNullExpressionValue((Object)instant4, (String)"lastModified");
        return instant4;
    }

    private final void saveEtag(CloseableHttpResponse response, Instant lastModified, Path target, Path etagFile) {
        String etag;
        if (Intrinsics.areEqual((Object)lastModified, (Object)Instant.EPOCH) ^ true) {
            Path path = target;
            FileTime fileTime = FileTime.from(lastModified);
            Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"FileTime.from(lastModified)");
            FileTime fileTime2 = fileTime;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)Files.setLastModifiedTime(path, fileTime2), (String)"Files.setLastModifiedTime(this, value)");
        }
        Header header = response.getFirstHeader("ETag");
        if (header == null) {
            return;
        }
        Header header2 = header;
        String string = etag = header2.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"etag");
        PathsKt.writeText$default((Path)etagFile, (CharSequence)string, null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    /*
     * WARNING - void declaration
     */
    public DownloadService() {
        CloseableHttpClient closeableHttpClient;
        void builder;
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        boolean bl = false;
        boolean bl2 = false;
        HttpClientBuilder httpClientBuilder2 = httpClientBuilder;
        DownloadService downloadService = this;
        boolean bl3 = false;
        builder.setRetryHandler(httpClient.1.1.INSTANCE);
        builder.useSystemProperties();
        CloseableHttpClient closeableHttpClient2 = closeableHttpClient = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)closeableHttpClient2, (String)"HttpClientBuilder.create\u2026    builder.build()\n    }");
        downloadService.httpClient = closeableHttpClient2;
    }
}

