/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.tukaani.xz.check;

import java.security.NoSuchAlgorithmException;
import paper.libs.org.tukaani.xz.UnsupportedOptionsException;
import paper.libs.org.tukaani.xz.check.CRC32;
import paper.libs.org.tukaani.xz.check.CRC64;
import paper.libs.org.tukaani.xz.check.None;
import paper.libs.org.tukaani.xz.check.SHA256;

public abstract class Check {
    int size;
    String name;

    public abstract void update(byte[] var1, int var2, int var3);

    public abstract byte[] finish();

    public void update(byte[] byArray2) {
        this.update(byArray2, 0, byArray2.length);
    }

    public int getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public static Check getInstance(int n) throws UnsupportedOptionsException {
        switch (n) {
            case 0: {
                return new None();
            }
            case 1: {
                return new CRC32();
            }
            case 4: {
                return new CRC64();
            }
            case 10: {
                try {
                    return new SHA256();
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
        }
        throw new UnsupportedOptionsException("Unsupported Check ID " + n);
    }
}

