/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.osgi.service.condpermadmin;

import java.util.ArrayList;

public class ConditionInfo {
    private final String type;
    private final String[] args;

    public ConditionInfo(String type, String[] args) {
        this.type = type;
        String[] stringArray = this.args = args != null ? (String[])args.clone() : new String[]{};
        if (type == null) {
            throw new NullPointerException("type is null");
        }
    }

    public ConditionInfo(String encodedCondition) {
        if (encodedCondition == null) {
            throw new NullPointerException("missing encoded condition");
        }
        if (encodedCondition.length() == 0) {
            throw new IllegalArgumentException("empty encoded condition");
        }
        try {
            char[] encoded = encodedCondition.toCharArray();
            int length = encoded.length;
            int pos = 0;
            while (Character.isWhitespace(encoded[pos])) {
                ++pos;
            }
            if (encoded[pos] != '[') {
                throw new IllegalArgumentException("expecting open bracket");
            }
            ++pos;
            while (Character.isWhitespace(encoded[pos])) {
                ++pos;
            }
            int begin = pos;
            while (!Character.isWhitespace(encoded[pos]) && encoded[pos] != ']') {
                ++pos;
            }
            if (pos == begin || encoded[begin] == '\"') {
                throw new IllegalArgumentException("expecting type");
            }
            this.type = new String(encoded, begin, pos - begin);
            while (Character.isWhitespace(encoded[pos])) {
                ++pos;
            }
            ArrayList<String> argsList = new ArrayList<String>();
            while (encoded[pos] == '\"') {
                begin = ++pos;
                while (encoded[pos] != '\"') {
                    if (encoded[pos] == '\\') {
                        ++pos;
                    }
                    ++pos;
                }
                argsList.add(ConditionInfo.unescapeString(encoded, begin, pos));
                if (!Character.isWhitespace(encoded[++pos])) continue;
                while (Character.isWhitespace(encoded[pos])) {
                    ++pos;
                }
            }
            this.args = argsList.toArray(new String[0]);
            char c = encoded[pos];
            ++pos;
            while (pos < length && Character.isWhitespace(encoded[pos])) {
                ++pos;
            }
            if (c != ']' || pos != length) {
                throw new IllegalArgumentException("expecting close bracket");
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("parsing terminated abruptly");
        }
    }

    public final String getEncoded() {
        StringBuilder output = new StringBuilder();
        output.append('[');
        output.append(this.type);
        int i2 = 0;
        while (i2 < this.args.length) {
            output.append(" \"");
            ConditionInfo.escapeString(this.args[i2], output);
            output.append('\"');
            ++i2;
        }
        output.append(']');
        return output.toString();
    }

    public String toString() {
        return this.getEncoded();
    }

    public final String getType() {
        return this.type;
    }

    public final String[] getArgs() {
        return (String[])this.args.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ConditionInfo)) {
            return false;
        }
        ConditionInfo other = (ConditionInfo)obj;
        if (!this.type.equals(other.type) || this.args.length != other.args.length) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.args.length) {
            if (!this.args[i2].equals(other.args[i2])) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public int hashCode() {
        int h = 527 + this.type.hashCode();
        int i2 = 0;
        while (i2 < this.args.length) {
            h = 31 * h + this.args[i2].hashCode();
            ++i2;
        }
        return h;
    }

    private static void escapeString(String str, StringBuilder output) {
        int len = str.length();
        int i2 = 0;
        while (i2 < len) {
            char c = str.charAt(i2);
            switch (c) {
                case '\"': 
                case '\\': {
                    output.append('\\');
                    output.append(c);
                    break;
                }
                case '\r': {
                    output.append("\\r");
                    break;
                }
                case '\n': {
                    output.append("\\n");
                    break;
                }
                default: {
                    output.append(c);
                }
            }
            ++i2;
        }
    }

    private static String unescapeString(char[] str, int begin, int end) {
        StringBuilder output = new StringBuilder(end - begin);
        int i2 = begin;
        while (i2 < end) {
            int c = str[i2];
            if (c == 92 && ++i2 < end) {
                c = str[i2];
                switch (c) {
                    case 34: 
                    case 92: {
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    default: {
                        c = 92;
                        --i2;
                    }
                }
            }
            output.append((char)c);
            ++i2;
        }
        return output.toString();
    }
}

