/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.osgi.dto;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class DTO {
    private static final int MAX_LENGTH = 100;

    public String toString() {
        return DTO.appendValue(new StringBuilder(), new IdentityHashMap<Object, String>(), "#", this).toString();
    }

    private static StringBuilder appendDTO(StringBuilder result, Map<Object, String> objectRefs, String refpath, DTO dto) {
        result.append('{');
        String delim = "";
        Field[] fieldArray = dto.getClass().getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (!Modifier.isStatic(field.getModifiers())) {
                result.append(delim);
                String name2 = field.getName();
                DTO.appendString(result, name2);
                result.append(':');
                Object value = null;
                try {
                    value = field.get(dto);
                }
                catch (IllegalAccessException illegalAccessException) {}
                DTO.appendValue(result, objectRefs, String.valueOf(refpath) + "/" + name2, value);
                delim = ", ";
            }
            ++n2;
        }
        result.append('}');
        return result;
    }

    private static StringBuilder appendValue(StringBuilder result, Map<Object, String> objectRefs, String refpath, Object value) {
        if (value == null) {
            return result.append("null");
        }
        if (value instanceof String || value instanceof Character) {
            return DTO.appendString(result, DTO.compress(value.toString()));
        }
        if (value instanceof Number || value instanceof Boolean) {
            return result.append(value.toString());
        }
        if (value instanceof Enum) {
            return DTO.appendString(result, ((Enum)value).name());
        }
        if ("paper.libs.org.osgi.framework.Version".equals(value.getClass().getName())) {
            return DTO.appendString(result, value.toString());
        }
        String path = objectRefs.get(value);
        if (path != null) {
            result.append("{\"$ref\":");
            DTO.appendString(result, path);
            result.append('}');
            return result;
        }
        objectRefs.put(value, refpath);
        if (value instanceof DTO) {
            return DTO.appendDTO(result, objectRefs, refpath, (DTO)value);
        }
        if (value instanceof Map) {
            return DTO.appendMap(result, objectRefs, refpath, (Map)value);
        }
        if (value instanceof List || value instanceof Set) {
            return DTO.appendIterable(result, objectRefs, refpath, (Iterable)value);
        }
        if (value.getClass().isArray()) {
            return DTO.appendArray(result, objectRefs, refpath, value);
        }
        return DTO.appendString(result, DTO.compress(value.toString()));
    }

    private static StringBuilder appendArray(StringBuilder result, Map<Object, String> objectRefs, String refpath, Object array) {
        result.append('[');
        int length = Array.getLength(array);
        int i2 = 0;
        while (i2 < length) {
            if (i2 > 0) {
                result.append(',');
            }
            DTO.appendValue(result, objectRefs, String.valueOf(refpath) + "/" + i2, Array.get(array, i2));
            ++i2;
        }
        result.append(']');
        return result;
    }

    private static StringBuilder appendIterable(StringBuilder result, Map<Object, String> objectRefs, String refpath, Iterable<?> iterable) {
        result.append('[');
        int i2 = 0;
        for (Object item : iterable) {
            if (i2 > 0) {
                result.append(',');
            }
            DTO.appendValue(result, objectRefs, String.valueOf(refpath) + "/" + i2, item);
            ++i2;
        }
        result.append(']');
        return result;
    }

    private static StringBuilder appendMap(StringBuilder result, Map<Object, String> objectRefs, String refpath, Map<?, ?> map2) {
        result.append('{');
        String delim = "";
        for (Map.Entry<?, ?> entry : map2.entrySet()) {
            result.append(delim);
            String name2 = String.valueOf(entry.getKey());
            DTO.appendString(result, name2);
            result.append(':');
            Object value = entry.getValue();
            DTO.appendValue(result, objectRefs, String.valueOf(refpath) + "/" + name2, value);
            delim = ", ";
        }
        result.append('}');
        return result;
    }

    private static StringBuilder appendString(StringBuilder result, CharSequence string) {
        result.append('\"');
        int i2 = result.length();
        result.append(string);
        while (i2 < result.length()) {
            char c = result.charAt(i2);
            if (c == '\"' || c == '\\') {
                result.insert(i2, '\\');
                i2 += 2;
                continue;
            }
            if (c < ' ') {
                result.insert(i2 + 1, Integer.toHexString(c | 0x10000));
                result.replace(i2, i2 + 2, "\\u");
                i2 += 6;
                continue;
            }
            ++i2;
        }
        result.append('\"');
        return result;
    }

    private static CharSequence compress(CharSequence in) {
        int length = in.length();
        if (length <= 100) {
            return in;
        }
        StringBuilder result = new StringBuilder(100).append(in, 0, 47).append('.').append('.').append('.').append(in, length - 50, length);
        return result;
    }
}

