/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.jheaps.array;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.Iterator;
import paper.libs.org.jheaps.AddressableHeap;
import paper.libs.org.jheaps.annotations.LinearTime;
import paper.libs.org.jheaps.array.AbstractArrayAddressableHeap;

public class BinaryArrayAddressableHeap<K, V>
extends AbstractArrayAddressableHeap<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_HEAP_CAPACITY = 16;

    public BinaryArrayAddressableHeap() {
        this(null, 16);
    }

    public BinaryArrayAddressableHeap(int capacity) {
        this(null, capacity);
    }

    public BinaryArrayAddressableHeap(Comparator<? super K> comparator2) {
        this(comparator2, 16);
    }

    public BinaryArrayAddressableHeap(Comparator<? super K> comparator2, int capacity) {
        super(comparator2, capacity);
    }

    @LinearTime
    public static <K, V> BinaryArrayAddressableHeap<K, V> heapify(K[] keys, V[] values) {
        int i2;
        if (keys == null) {
            throw new IllegalArgumentException("Key array cannot be null");
        }
        if (values != null && keys.length != values.length) {
            throw new IllegalArgumentException("Values array must have the same length as the keys array");
        }
        if (keys.length == 0) {
            return new BinaryArrayAddressableHeap<K, V>();
        }
        BinaryArrayAddressableHeap<K, V> h = new BinaryArrayAddressableHeap<K, V>(keys.length);
        for (i2 = 0; i2 < keys.length; ++i2) {
            K key = keys[i2];
            Object value = values == null ? null : (Object)values[i2];
            BinaryArrayAddressableHeap<K, V> binaryArrayAddressableHeap = h;
            binaryArrayAddressableHeap.getClass();
            AbstractArrayAddressableHeap.ArrayHandle ah = binaryArrayAddressableHeap.new AbstractArrayAddressableHeap.ArrayHandle(key, value);
            ah.index = i2 + 1;
            h.array[i2 + 1] = ah;
        }
        h.size = keys.length;
        for (i2 = keys.length / 2; i2 > 0; --i2) {
            h.fixdown(i2);
        }
        return h;
    }

    @LinearTime
    public static <K, V> BinaryArrayAddressableHeap<K, V> heapify(K[] keys, V[] values, Comparator<? super K> comparator2) {
        int i2;
        if (keys == null) {
            throw new IllegalArgumentException("Keys array cannot be null");
        }
        if (values != null && keys.length != values.length) {
            throw new IllegalArgumentException("Values array must have the same length as the keys array");
        }
        if (keys.length == 0) {
            return new BinaryArrayAddressableHeap<K, V>(comparator2);
        }
        BinaryArrayAddressableHeap<K, V> h = new BinaryArrayAddressableHeap<K, V>(comparator2, keys.length);
        for (i2 = 0; i2 < keys.length; ++i2) {
            K key = keys[i2];
            Object value = values == null ? null : (Object)values[i2];
            BinaryArrayAddressableHeap<K, V> binaryArrayAddressableHeap = h;
            binaryArrayAddressableHeap.getClass();
            AbstractArrayAddressableHeap.ArrayHandle ah = binaryArrayAddressableHeap.new AbstractArrayAddressableHeap.ArrayHandle(key, value);
            ah.index = i2 + 1;
            h.array[i2 + 1] = ah;
        }
        h.size = keys.length;
        for (i2 = keys.length / 2; i2 > 0; --i2) {
            h.fixdownWithComparator(i2);
        }
        return h;
    }

    public Iterator<AddressableHeap.Handle<K, V>> handlesIterator() {
        return new Iterator<AddressableHeap.Handle<K, V>>(){
            private int pos = 1;

            @Override
            public boolean hasNext() {
                return this.pos <= BinaryArrayAddressableHeap.this.size;
            }

            @Override
            public AddressableHeap.Handle<K, V> next() {
                return BinaryArrayAddressableHeap.this.array[this.pos++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    protected void ensureCapacity(int capacity) {
        this.checkCapacity(capacity);
        AbstractArrayAddressableHeap.ArrayHandle[] newArray = (AbstractArrayAddressableHeap.ArrayHandle[])Array.newInstance(AbstractArrayAddressableHeap.ArrayHandle.class, capacity + 1);
        System.arraycopy(this.array, 1, newArray, 1, this.size);
        this.array = newArray;
    }

    @Override
    protected void forceFixup(int k) {
        AbstractArrayAddressableHeap.ArrayHandle h = this.array[k];
        while (k > 1) {
            this.array[k] = this.array[k / 2];
            this.array[k].index = k;
            k /= 2;
        }
        this.array[k] = h;
        h.index = k;
    }

    @Override
    protected void fixup(int k) {
        AbstractArrayAddressableHeap.ArrayHandle h = this.array[k];
        while (k > 1 && ((Comparable)this.array[k / 2].getKey()).compareTo(h.getKey()) > 0) {
            this.array[k] = this.array[k / 2];
            this.array[k].index = k;
            k /= 2;
        }
        this.array[k] = h;
        h.index = k;
    }

    @Override
    protected void fixupWithComparator(int k) {
        AbstractArrayAddressableHeap.ArrayHandle h = this.array[k];
        while (k > 1 && this.comparator.compare(this.array[k / 2].getKey(), h.getKey()) > 0) {
            this.array[k] = this.array[k / 2];
            this.array[k].index = k;
            k /= 2;
        }
        this.array[k] = h;
        h.index = k;
    }

    @Override
    protected void fixdown(int k) {
        AbstractArrayAddressableHeap.ArrayHandle h = this.array[k];
        while (2 * k <= this.size) {
            int j = 2 * k;
            if (j < this.size && ((Comparable)this.array[j].getKey()).compareTo(this.array[j + 1].getKey()) > 0) {
                ++j;
            }
            if (((Comparable)h.getKey()).compareTo(this.array[j].getKey()) <= 0) break;
            this.array[k] = this.array[j];
            this.array[k].index = k;
            k = j;
        }
        this.array[k] = h;
        h.index = k;
    }

    @Override
    protected void fixdownWithComparator(int k) {
        AbstractArrayAddressableHeap.ArrayHandle h = this.array[k];
        while (2 * k <= this.size) {
            int j = 2 * k;
            if (j < this.size && this.comparator.compare(this.array[j].getKey(), this.array[j + 1].getKey()) > 0) {
                ++j;
            }
            if (this.comparator.compare(h.getKey(), this.array[j].getKey()) <= 0) break;
            this.array[k] = this.array[j];
            this.array[k].index = k;
            k = j;
        }
        this.array[k] = h;
        h.index = k;
    }
}

