/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.jgrapht.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

public class CollectionUtil {
    private CollectionUtil() {
    }

    public static <K, V> HashMap<K, V> newHashMapWithExpectedSize(int expectedSize) {
        return new HashMap(CollectionUtil.capacityForSize(expectedSize));
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMapWithExpectedSize(int expectedSize) {
        return new LinkedHashMap(CollectionUtil.capacityForSize(expectedSize));
    }

    public static <E> HashSet<E> newHashSetWithExpectedSize(int expectedSize) {
        return new HashSet(CollectionUtil.capacityForSize(expectedSize));
    }

    public static <E> LinkedHashSet<E> newLinkedHashSetWithExpectedSize(int expectedSize) {
        return new LinkedHashSet(CollectionUtil.capacityForSize(expectedSize));
    }

    private static int capacityForSize(int size) {
        return (int)((float)size / 0.75f + 1.0f);
    }
}

