/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.osgi.storage.bundlefile;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import paper.libs.org.eclipse.osgi.storage.bundlefile.BundleEntry;
import paper.libs.org.eclipse.osgi.storage.bundlefile.BundleFile;

public class FileBundleEntry
extends BundleEntry {
    private final File file;
    private final String name;

    public FileBundleEntry(File file, String name2) {
        boolean endsInSlash;
        this.file = file;
        boolean bl = endsInSlash = name2.length() > 0 && name2.charAt(name2.length() - 1) == '/';
        if (BundleFile.secureAction.isDirectory(file)) {
            if (!endsInSlash) {
                name2 = String.valueOf(name2) + '/';
            }
        } else if (endsInSlash) {
            name2 = name2.substring(0, name2.length() - 1);
        }
        this.name = name2;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return BundleFile.secureAction.getFileInputStream(this.file);
    }

    @Override
    public long getSize() {
        return BundleFile.secureAction.length(this.file);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getTime() {
        return BundleFile.secureAction.lastModified(this.file);
    }

    @Override
    public URL getLocalURL() {
        return this.getFileURL();
    }

    @Override
    public URL getFileURL() {
        try {
            return this.file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }
}

