/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.osgi.internal.url;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import paper.libs.org.eclipse.osgi.internal.url.EquinoxFactoryManager;
import paper.libs.org.eclipse.osgi.internal.url.MultiplexingFactory;
import paper.libs.org.eclipse.osgi.internal.url.URLStreamHandlerFactoryImpl;

public class MultiplexingURLStreamHandler
extends URLStreamHandler {
    private static Method openConnectionMethod;
    private static Method openConnectionProxyMethod;
    private static Method equalsMethod;
    private static Method getDefaultPortMethod;
    private static Method getHostAddressMethod;
    private static Method hashCodeMethod;
    private static Method hostsEqualMethod;
    private static Method parseURLMethod;
    private static Method sameFileMethod;
    private static Method setURLMethod;
    private static Method toExternalFormMethod;
    private static Field handlerField;
    private static boolean methodsInitialized;
    private String protocol;
    private URLStreamHandlerFactoryImpl factory;
    private final URLStreamHandler authorized;

    static {
        methodsInitialized = false;
    }

    private static synchronized void initializeMethods(URLStreamHandlerFactoryImpl factory) {
        if (methodsInitialized) {
            return;
        }
        try {
            block5: {
                openConnectionMethod = URLStreamHandler.class.getDeclaredMethod("openConnection", URL.class);
                MultiplexingFactory.setAccessible(openConnectionMethod);
                openConnectionProxyMethod = URLStreamHandler.class.getDeclaredMethod("openConnection", URL.class, Proxy.class);
                MultiplexingFactory.setAccessible(openConnectionProxyMethod);
                equalsMethod = URLStreamHandler.class.getDeclaredMethod("equals", URL.class, URL.class);
                MultiplexingFactory.setAccessible(equalsMethod);
                getDefaultPortMethod = URLStreamHandler.class.getDeclaredMethod("getDefaultPort", null);
                MultiplexingFactory.setAccessible(getDefaultPortMethod);
                getHostAddressMethod = URLStreamHandler.class.getDeclaredMethod("getHostAddress", URL.class);
                MultiplexingFactory.setAccessible(getHostAddressMethod);
                hashCodeMethod = URLStreamHandler.class.getDeclaredMethod("hashCode", URL.class);
                MultiplexingFactory.setAccessible(hashCodeMethod);
                hostsEqualMethod = URLStreamHandler.class.getDeclaredMethod("hostsEqual", URL.class, URL.class);
                MultiplexingFactory.setAccessible(hostsEqualMethod);
                parseURLMethod = URLStreamHandler.class.getDeclaredMethod("parseURL", URL.class, String.class, Integer.TYPE, Integer.TYPE);
                MultiplexingFactory.setAccessible(parseURLMethod);
                sameFileMethod = URLStreamHandler.class.getDeclaredMethod("sameFile", URL.class, URL.class);
                MultiplexingFactory.setAccessible(sameFileMethod);
                setURLMethod = URLStreamHandler.class.getDeclaredMethod("setURL", URL.class, String.class, String.class, Integer.TYPE, String.class, String.class, String.class, String.class, String.class);
                MultiplexingFactory.setAccessible(setURLMethod);
                toExternalFormMethod = URLStreamHandler.class.getDeclaredMethod("toExternalForm", URL.class);
                MultiplexingFactory.setAccessible(toExternalFormMethod);
                try {
                    handlerField = URL.class.getDeclaredField("handler");
                }
                catch (NoSuchFieldException e) {
                    handlerField = EquinoxFactoryManager.getField(URL.class, URLStreamHandler.class, true);
                    if (handlerField != null) break block5;
                    throw e;
                }
            }
            MultiplexingFactory.setAccessible(handlerField);
        }
        catch (Exception e) {
            factory.container.getLogServices().log(MultiplexingURLStreamHandler.class.getName(), 4, "initializeMethods", e);
            throw new RuntimeException(e.getMessage(), e);
        }
        methodsInitialized = true;
    }

    public MultiplexingURLStreamHandler(String protocol, URLStreamHandlerFactoryImpl factory, URLStreamHandler authorized) {
        this.protocol = protocol;
        this.factory = factory;
        this.authorized = authorized;
        MultiplexingURLStreamHandler.initializeMethods(factory);
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        URLStreamHandler handler = this.findAuthorizedURLStreamHandler(this.protocol);
        if (handler != null) {
            try {
                return (URLConnection)openConnectionMethod.invoke((Object)handler, url);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof IOException) {
                    throw (IOException)e.getTargetException();
                }
                throw (RuntimeException)e.getTargetException();
            }
            catch (Exception e) {
                this.factory.container.getLogServices().log(MultiplexingURLStreamHandler.class.getName(), 4, "openConnection", e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        throw new MalformedURLException();
    }

    @Override
    protected URLConnection openConnection(URL url, Proxy proxy) throws IOException {
        URLStreamHandler handler = this.findAuthorizedURLStreamHandler(this.protocol);
        if (handler != null) {
            try {
                return (URLConnection)openConnectionProxyMethod.invoke((Object)handler, url, proxy);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof IOException) {
                    throw (IOException)e.getTargetException();
                }
                throw (RuntimeException)e.getTargetException();
            }
            catch (Exception e) {
                this.factory.container.getLogServices().log(MultiplexingURLStreamHandler.class.getName(), 4, "openConnection", e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        throw new MalformedURLException();
    }

    @Override
    protected boolean equals(URL url1, URL url2) {
        URLStreamHandler handler = this.findAuthorizedURLStreamHandler(this.protocol);
        if (handler != null) {
            try {
                return (Boolean)equalsMethod.invoke((Object)handler, url1, url2);
            }
            catch (InvocationTargetException e) {
                throw (RuntimeException)e.getTargetException();
            }
            catch (Exception e) {
                this.factory.container.getLogServices().log(MultiplexingURLStreamHandler.class.getName(), 4, "equals", e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected int getDefaultPort() {
        URLStreamHandler handler = this.findAuthorizedURLStreamHandler(this.protocol);
        if (handler != null) {
            try {
                return (Integer)getDefaultPortMethod.invoke((Object)handler, null);
            }
            catch (InvocationTargetException e) {
                throw (RuntimeException)e.getTargetException();
            }
            catch (Exception e) {
                this.factory.container.getLogServices().log(MultiplexingURLStreamHandler.class.getName(), 4, "getDefaultPort", e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected InetAddress getHostAddress(URL url) {
        URLStreamHandler handler = this.findAuthorizedURLStreamHandler(this.protocol);
        if (handler != null) {
            try {
                return (InetAddress)getHostAddressMethod.invoke((Object)handler, url);
            }
            catch (InvocationTargetException e) {
                throw (RuntimeException)e.getTargetException();
            }
            catch (Exception e) {
                this.factory.container.getLogServices().log(MultiplexingURLStreamHandler.class.getName(), 4, "hashCode", e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected int hashCode(URL url) {
        URLStreamHandler handler = this.findAuthorizedURLStreamHandler(this.protocol);
        if (handler != null) {
            try {
                return (Integer)hashCodeMethod.invoke((Object)handler, url);
            }
            catch (InvocationTargetException e) {
                throw (RuntimeException)e.getTargetException();
            }
            catch (Exception e) {
                this.factory.container.getLogServices().log(MultiplexingURLStreamHandler.class.getName(), 4, "hashCode", e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected boolean hostsEqual(URL url1, URL url2) {
        URLStreamHandler handler = this.findAuthorizedURLStreamHandler(this.protocol);
        if (handler != null) {
            try {
                return (Boolean)hostsEqualMethod.invoke((Object)handler, url1, url2);
            }
            catch (InvocationTargetException e) {
                throw (RuntimeException)e.getTargetException();
            }
            catch (Exception e) {
                this.factory.container.getLogServices().log(MultiplexingURLStreamHandler.class.getName(), 4, "hostsEqual", e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected void parseURL(URL arg0, String arg1, int arg2, int arg3) {
        URLStreamHandler handler = this.factory.findAuthorizedURLStreamHandler(this.protocol);
        if (handler != null) {
            try {
                handlerField.set(arg0, handler);
                parseURLMethod.invoke((Object)handler, arg0, arg1, arg2, arg3);
                return;
            }
            catch (InvocationTargetException e) {
                throw (RuntimeException)e.getTargetException();
            }
            catch (Exception e) {
                this.factory.container.getLogServices().log(MultiplexingURLStreamHandler.class.getName(), 4, "parseURL", e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected boolean sameFile(URL url1, URL url2) {
        URLStreamHandler handler = this.findAuthorizedURLStreamHandler(this.protocol);
        if (handler != null) {
            try {
                return (Boolean)sameFileMethod.invoke((Object)handler, url1, url2);
            }
            catch (InvocationTargetException e) {
                throw (RuntimeException)e.getTargetException();
            }
            catch (Exception e) {
                this.factory.container.getLogServices().log(MultiplexingURLStreamHandler.class.getName(), 4, "sameFile", e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected void setURL(URL arg0, String arg1, String arg2, int arg3, String arg4, String arg5, String arg6, String arg7, String arg8) {
        URLStreamHandler handler = this.findAuthorizedURLStreamHandler(this.protocol);
        if (handler != null) {
            try {
                handlerField.set(arg0, handler);
                setURLMethod.invoke((Object)handler, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
                return;
            }
            catch (InvocationTargetException e) {
                throw (RuntimeException)e.getTargetException();
            }
            catch (Exception e) {
                this.factory.container.getLogServices().log(MultiplexingURLStreamHandler.class.getName(), 4, "setURL", e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected String toExternalForm(URL url) {
        URLStreamHandler handler = this.findAuthorizedURLStreamHandler(this.protocol);
        if (handler != null) {
            try {
                return (String)toExternalFormMethod.invoke((Object)handler, url);
            }
            catch (InvocationTargetException e) {
                throw (RuntimeException)e.getTargetException();
            }
            catch (Exception e) {
                this.factory.container.getLogServices().log(MultiplexingURLStreamHandler.class.getName(), 4, "toExternalForm", e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        throw new IllegalStateException();
    }

    private URLStreamHandler findAuthorizedURLStreamHandler(String requested) {
        URLStreamHandler handler = this.factory.findAuthorizedURLStreamHandler(requested);
        return handler == null ? this.authorized : handler;
    }
}

