/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.osgi.internal.loader.sources;

import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import paper.libs.org.eclipse.osgi.internal.loader.BundleLoader;
import paper.libs.org.eclipse.osgi.internal.loader.sources.SingleSourcePackage;
import paper.libs.org.eclipse.osgi.util.ManifestElement;

public class FilteredSourcePackage
extends SingleSourcePackage {
    private static final char ALL = '*';
    private final String[] includes;
    private final String[] excludes;

    public FilteredSourcePackage(String name2, BundleLoader supplier, String includes, String excludes) {
        super(name2, supplier);
        this.includes = includes != null ? ManifestElement.getArrayFromList(includes) : null;
        this.excludes = excludes != null ? ManifestElement.getArrayFromList(excludes) : null;
    }

    @Override
    public URL getResource(String name2) {
        if (this.isFiltered(name2, this.getId())) {
            return null;
        }
        return super.getResource(name2);
    }

    @Override
    public Enumeration<URL> getResources(String name2) {
        if (this.isFiltered(name2, this.getId())) {
            return null;
        }
        return super.getResources(name2);
    }

    @Override
    public Class<?> loadClass(String name2) throws ClassNotFoundException {
        if (this.isFiltered(name2, this.getId())) {
            return null;
        }
        return super.loadClass(name2);
    }

    private boolean isFiltered(String name2, String pkgName) {
        String lastName = this.getName(name2, pkgName);
        return !this.isIncluded(lastName) || this.isExcluded(lastName);
    }

    private String getName(String name2, String pkgName) {
        if (!".".equals(pkgName) && pkgName.length() + 1 <= name2.length()) {
            return name2.substring(pkgName.length() + 1);
        }
        return name2;
    }

    private boolean isIncluded(String name2) {
        if (this.includes == null) {
            return true;
        }
        return this.isInList(name2, this.includes);
    }

    private boolean isExcluded(String name2) {
        if (this.excludes == null) {
            return false;
        }
        return this.isInList(name2, this.excludes);
    }

    private boolean isInList(String name2, String[] list) {
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            int len = s.length();
            if (len != 0) {
                if (s.charAt(0) == '*' && len == 1) {
                    return true;
                }
                if (s.charAt(len - 1) == '*' && name2.startsWith(s.substring(0, len - 1))) {
                    return true;
                }
                if (name2.equals(s)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Collection<String> listResources(String path, String filePattern) {
        Collection<String> result = super.listResources(path, filePattern);
        Iterator<String> resources = result.iterator();
        while (resources.hasNext()) {
            String fileName;
            String resource = resources.next();
            int lastSlash = resource.lastIndexOf(47);
            String string = fileName = lastSlash >= 0 ? resource.substring(lastSlash + 1) : resource;
            if (this.isIncluded(fileName) && !this.isExcluded(fileName)) continue;
            resources.remove();
        }
        return result;
    }
}

