/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.osgi.internal.loader;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import paper.libs.org.eclipse.osgi.container.Module;
import paper.libs.org.eclipse.osgi.container.ModuleCapability;
import paper.libs.org.eclipse.osgi.container.ModuleLoader;
import paper.libs.org.eclipse.osgi.container.ModuleRequirement;
import paper.libs.org.eclipse.osgi.container.ModuleRevision;
import paper.libs.org.eclipse.osgi.container.ModuleRevisionBuilder;
import paper.libs.org.eclipse.osgi.container.ModuleWire;
import paper.libs.org.eclipse.osgi.container.ModuleWiring;
import paper.libs.org.eclipse.osgi.container.builders.OSGiManifestBuilderFactory;
import paper.libs.org.eclipse.osgi.internal.debug.Debug;
import paper.libs.org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import paper.libs.org.eclipse.osgi.internal.framework.EquinoxContainer;
import paper.libs.org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import paper.libs.org.eclipse.osgi.internal.loader.BundleLoaderSources;
import paper.libs.org.eclipse.osgi.internal.loader.EquinoxClassLoader;
import paper.libs.org.eclipse.osgi.internal.loader.ModuleClassLoader;
import paper.libs.org.eclipse.osgi.internal.loader.SystemBundleLoader;
import paper.libs.org.eclipse.osgi.internal.loader.buddy.PolicyHandler;
import paper.libs.org.eclipse.osgi.internal.loader.sources.MultiSourcePackage;
import paper.libs.org.eclipse.osgi.internal.loader.sources.NullPackageSource;
import paper.libs.org.eclipse.osgi.internal.loader.sources.PackageSource;
import paper.libs.org.eclipse.osgi.internal.loader.sources.SingleSourcePackage;
import paper.libs.org.eclipse.osgi.storage.BundleInfo;
import paper.libs.org.eclipse.osgi.util.ManifestElement;
import paper.libs.org.osgi.framework.Bundle;
import paper.libs.org.osgi.framework.BundleContext;
import paper.libs.org.osgi.framework.BundleException;

public class BundleLoader
extends ModuleLoader {
    public static final String DEFAULT_PACKAGE = ".";
    public static final String JAVA_PACKAGE = "java.";
    public static final ClassContext CLASS_CONTEXT = AccessController.doPrivileged(ClassContext::new);
    public static final ClassLoader FW_CLASSLOADER = BundleLoader.getClassLoader(EquinoxContainer.class);
    private static final int PRE_CLASS = 1;
    private static final int POST_CLASS = 2;
    private static final int PRE_RESOURCE = 3;
    private static final int POST_RESOURCE = 4;
    private static final int PRE_RESOURCES = 5;
    private static final int POST_RESOURCES = 6;
    private static final Pattern PACKAGENAME_FILTER = Pattern.compile("\\(osgi.wiring.package\\s*=\\s*([^)]+)\\)");
    private final ModuleWiring wiring;
    private final EquinoxContainer container;
    private final Debug debug;
    private final PolicyHandler policy;
    private final Collection<String> exportedPackages;
    private final BundleLoaderSources exportSources;
    private final Map<String, PackageSource> requiredSources = new HashMap<String, PackageSource>();
    private final Map<String, PackageSource> importedSources = new HashMap<String, PackageSource>();
    private final List<ModuleWire> requiredBundleWires;
    private boolean importsInitialized = false;
    private boolean dynamicAllPackages;
    private String[] dynamicImportPackageStems;
    private String[] dynamicImportPackages;
    private final Object classLoaderCreatedMonitor = new Object();
    private ModuleClassLoader classLoaderCreated;
    private volatile ModuleClassLoader classloader;
    private final ClassLoader parent;
    private final AtomicBoolean triggerClassLoaded = new AtomicBoolean(false);
    private final AtomicBoolean firstUseOfInvalidLoader = new AtomicBoolean(false);

    public static final String getPackageName(String name2) {
        int index;
        if (name2 != null && (index = name2.lastIndexOf(46)) > 0) {
            return name2.substring(0, index);
        }
        return DEFAULT_PACKAGE;
    }

    public static final String getResourcePackageName(String name2) {
        if (name2 != null) {
            int begin = name2.length() > 1 && name2.charAt(0) == '/' ? 1 : 0;
            int end = name2.lastIndexOf(47);
            if (end > begin) {
                return name2.substring(begin, end).replace('/', '.');
            }
        }
        return DEFAULT_PACKAGE;
    }

    public BundleLoader(ModuleWiring wiring, EquinoxContainer container, ClassLoader parent) {
        this.wiring = wiring;
        this.container = container;
        this.debug = container.getConfiguration().getDebug();
        this.parent = parent;
        this.exportSources = new BundleLoaderSources(this);
        List<ModuleCapability> exports = wiring.getModuleCapabilities("osgi.wiring.package");
        exports = exports == null ? Collections.emptyList() : exports;
        this.exportedPackages = Collections.synchronizedCollection(exports.size() > 10 ? new HashSet(exports.size()) : new ArrayList(exports.size()));
        BundleLoader.initializeExports(exports, this.exportSources, this.exportedPackages);
        this.addDynamicImportPackage(wiring.getModuleRequirements("osgi.wiring.package"));
        List<ModuleWire> currentRequireBundleWires = wiring.getRequiredModuleWires("osgi.wiring.bundle");
        this.requiredBundleWires = currentRequireBundleWires == null || currentRequireBundleWires.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(currentRequireBundleWires);
        List<ModuleCapability> moduleDatas = wiring.getRevision().getModuleCapabilities("equinox.module.data");
        List buddyList = (List)(moduleDatas.isEmpty() ? null : moduleDatas.get(0).getAttributes().get("buddy.policy"));
        PolicyHandler policyHandler = this.policy = buddyList != null ? new PolicyHandler(this, buddyList, container.getStorage().getModuleContainer().getFrameworkWiring(), container.getBootLoader()) : null;
        if (this.policy != null) {
            Module systemModule = container.getStorage().getModuleContainer().getModule(0L);
            Bundle systemBundle = systemModule.getBundle();
            this.policy.open(systemBundle.getBundleContext());
        }
    }

    public ModuleWiring getWiring() {
        return this.wiring;
    }

    public void addFragmentExports(List<ModuleCapability> exports) {
        BundleLoader.initializeExports(exports, this.exportSources, this.exportedPackages);
    }

    private static void initializeExports(List<ModuleCapability> exports, BundleLoaderSources sources, Collection<String> exportNames) {
        if (exports != null) {
            for (ModuleCapability export : exports) {
                String name2 = (String)export.getAttributes().get("osgi.wiring.package");
                if (sources.forceSourceCreation(export) && !exportNames.contains(name2)) {
                    sources.createPackageSource(export, true);
                }
                exportNames.add(name2);
            }
        }
    }

    final PackageSource createExportPackageSource(ModuleWire importWire, Collection<BundleLoader> visited) {
        String name2 = (String)importWire.getCapability().getAttributes().get("osgi.wiring.package");
        BundleLoader providerLoader = this.getProviderLoader(importWire);
        if (providerLoader == null) {
            return BundleLoader.createMultiSource(name2, new PackageSource[0]);
        }
        PackageSource requiredSource = providerLoader.findRequiredSource(name2, visited);
        PackageSource exportSource = providerLoader.exportSources.createPackageSource(importWire.getCapability(), false);
        if (requiredSource == null) {
            return exportSource;
        }
        return BundleLoader.createMultiSource(name2, new PackageSource[]{requiredSource, exportSource});
    }

    private static PackageSource createMultiSource(String packageName, PackageSource[] sources) {
        if (sources.length == 1) {
            return sources[0];
        }
        ArrayList<SingleSourcePackage> sourceList = new ArrayList<SingleSourcePackage>(sources.length);
        PackageSource[] packageSourceArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            SingleSourcePackage[] innerSources;
            PackageSource source = packageSourceArray[n2];
            SingleSourcePackage[] singleSourcePackageArray = innerSources = source.getSuppliers();
            int n3 = innerSources.length;
            int n4 = 0;
            while (n4 < n3) {
                SingleSourcePackage innerSource = singleSourcePackageArray[n4];
                if (!sourceList.contains(innerSource)) {
                    sourceList.add(innerSource);
                }
                ++n4;
            }
            ++n2;
        }
        return new MultiSourcePackage(packageName, sourceList.toArray(new SingleSourcePackage[sourceList.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleClassLoader getModuleClassLoader() {
        ModuleClassLoader result = this.classloader;
        if (result != null) {
            return result;
        }
        List<ClassLoaderHook> hooks = this.container.getConfiguration().getHookRegistry().getClassLoaderHooks();
        BundleInfo.Generation generation = (BundleInfo.Generation)this.wiring.getRevision().getRevisionInfo();
        if (System.getSecurityManager() == null) {
            result = BundleLoader.createClassLoaderPrivledged(this.parent, generation.getBundleInfo().getStorage().getConfiguration(), this, generation, hooks);
        } else {
            ClassLoader cl = this.parent;
            result = AccessController.doPrivileged(() -> BundleLoader.createClassLoaderPrivledged(cl, generation.getBundleInfo().getStorage().getConfiguration(), this, generation, hooks));
        }
        Object object = this.classLoaderCreatedMonitor;
        synchronized (object) {
            if (this.classLoaderCreated == null) {
                this.classLoaderCreated = result;
                ModuleClassLoader cl = result;
                AccessController.doPrivileged(() -> {
                    for (ClassLoaderHook hook : hooks) {
                        hook.classLoaderCreated(cl);
                    }
                    return null;
                });
                this.classloader = this.classLoaderCreated;
            } else {
                result = this.classLoaderCreated;
                if (this.debug.DEBUG_LOADER) {
                    Debug.println("BundleLoader[" + this + "].getModuleClassLoader() - created duplicate classloader");
                }
            }
        }
        return result;
    }

    @Override
    protected void loadFragments(Collection<ModuleRevision> fragments) {
        this.addFragmentExports(this.wiring.getModuleCapabilities("osgi.wiring.package"));
        this.loadClassLoaderFragments(fragments);
        this.clearManifestLocalizationCache();
    }

    protected void clearManifestLocalizationCache() {
        BundleInfo.Generation hostGen = (BundleInfo.Generation)this.wiring.getRevision().getRevisionInfo();
        hostGen.clearManifestCache();
        List<ModuleWire> hostWires = this.wiring.getProvidedModuleWires("osgi.wiring.host");
        if (hostWires != null) {
            for (ModuleWire fragmentWire : hostWires) {
                BundleInfo.Generation fragGen = (BundleInfo.Generation)fragmentWire.getRequirer().getRevisionInfo();
                fragGen.clearManifestCache();
            }
        }
    }

    void loadClassLoaderFragments(Collection<ModuleRevision> fragments) {
        ModuleClassLoader current = this.classloader;
        if (current != null) {
            current.loadFragments(fragments);
        }
    }

    static ModuleClassLoader createClassLoaderPrivledged(ClassLoader parent, EquinoxConfiguration configuration, BundleLoader delegate, BundleInfo.Generation generation, List<ClassLoaderHook> hooks) {
        for (ClassLoaderHook hook : hooks) {
            ModuleClassLoader hookClassLoader = hook.createClassLoader(parent, configuration, delegate, generation);
            if (hookClassLoader == null) continue;
            return hookClassLoader;
        }
        return new EquinoxClassLoader(parent, configuration, delegate, generation);
    }

    public void close() {
        ModuleClassLoader current;
        Module systemModule;
        BundleContext context;
        if (this.policy != null && (context = (systemModule = this.container.getStorage().getModuleContainer().getModule(0L)).getBundle().getBundleContext()) != null) {
            this.policy.close(context);
        }
        if ((current = this.classloader) != null) {
            current.close();
        }
    }

    @Override
    protected ClassLoader getClassLoader() {
        return this.getModuleClassLoader();
    }

    public ClassLoader getParentClassLoader() {
        return this.parent;
    }

    final URL getResource(String name2) {
        return this.getModuleClassLoader().getResource(name2);
    }

    public Class<?> findLocalClass(String name2) throws ClassNotFoundException {
        long start = 0L;
        if (this.debug.DEBUG_LOADER) {
            Debug.println("BundleLoader[" + this + "].findLocalClass(" + name2 + ")");
            start = System.currentTimeMillis();
        }
        try {
            Class<?> clazz = this.getModuleClassLoader().findLocalClass(name2);
            if (this.debug.DEBUG_LOADER && clazz != null) {
                long time = System.currentTimeMillis() - start;
                Debug.println("BundleLoader[" + this + "] found local class " + name2 + " " + time + "ms");
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            if (e.getCause() instanceof BundleException) {
                throw e;
            }
            return null;
        }
    }

    public Class<?> findClass(String name2) throws ClassNotFoundException {
        return this.findClass0(name2, true);
    }

    public Class<?> findClassNoParentNoException(String name2) {
        try {
            return this.findClass0(name2, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private Class<?> findClass0(String name2, boolean parentAndGenerateException) throws ClassNotFoundException {
        if (parentAndGenerateException && this.parent != null && name2.startsWith(JAVA_PACKAGE)) {
            return this.parent.loadClass(name2);
        }
        if (this.debug.DEBUG_LOADER) {
            Debug.println("BundleLoader[" + this + "].findClass(" + name2 + ")");
        }
        String pkgName = BundleLoader.getPackageName(name2);
        boolean bootDelegation = false;
        if (parentAndGenerateException && this.parent != null && this.container.isBootDelegationPackage(pkgName)) {
            try {
                return this.parent.loadClass(name2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                bootDelegation = true;
            }
        }
        Class<?> result = null;
        try {
            result = (Class<?>)this.searchHooks(name2, 1);
        }
        catch (FileNotFoundException fileNotFoundException) {}
        if (result != null) {
            return result;
        }
        PackageSource source = this.findImportedSource(pkgName, null);
        if (source != null) {
            if (this.debug.DEBUG_LOADER) {
                Debug.println("BundleLoader[" + this + "] loading from import package: " + source);
            }
            if ((result = source.loadClass(name2)) == null) {
                result = this.getModuleClassLoader().publicFindLoaded(name2);
            }
            if (result != null) {
                return result;
            }
            return this.generateException(name2, parentAndGenerateException);
        }
        source = this.findRequiredSource(pkgName, null);
        if (source != null) {
            if (this.debug.DEBUG_LOADER) {
                Debug.println("BundleLoader[" + this + "] loading from required bundle package: " + source);
            }
            result = source.loadClass(name2);
        }
        if (result == null) {
            result = this.findLocalClass(name2);
        }
        if (result != null) {
            return result;
        }
        if (source == null && (source = this.findDynamicSource(pkgName)) != null) {
            result = source.loadClass(name2);
            if (result != null) {
                return result;
            }
            return this.generateException(name2, parentAndGenerateException);
        }
        if (result == null) {
            try {
                result = (Class<?>)this.searchHooks(name2, 2);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        if (result == null && this.policy != null) {
            result = this.policy.doBuddyClassLoading(name2);
        }
        if (result != null) {
            return result;
        }
        if (parentAndGenerateException && this.parent != null && !bootDelegation && (this.container.getConfiguration().compatibilityBootDelegation || this.isRequestFromVM())) {
            try {
                return this.parent.loadClass(name2);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return this.generateException(name2, parentAndGenerateException);
    }

    private Class<?> generateException(String name2, boolean generate) throws ClassNotFoundException {
        if (generate) {
            ClassNotFoundException e = new ClassNotFoundException(String.valueOf(name2) + " cannot be found by " + this);
            if (this.debug.DEBUG_LOADER) {
                Debug.println("BundleLoader[" + this + "].loadClass(" + name2 + ") failed.");
                Debug.printStackTrace(e);
            }
            throw e;
        }
        return null;
    }

    private <E> E searchHooks(String name2, int type) throws ClassNotFoundException, FileNotFoundException {
        List<ClassLoaderHook> loaderHooks = this.container.getConfiguration().getHookRegistry().getClassLoaderHooks();
        if (loaderHooks == null) {
            return null;
        }
        Enumeration<URL> result = null;
        for (ClassLoaderHook hook : loaderHooks) {
            switch (type) {
                case 1: {
                    result = hook.preFindClass(name2, this.getModuleClassLoader());
                    break;
                }
                case 2: {
                    result = hook.postFindClass(name2, this.getModuleClassLoader());
                    break;
                }
                case 3: {
                    result = hook.preFindResource(name2, this.getModuleClassLoader());
                    break;
                }
                case 4: {
                    result = hook.postFindResource(name2, this.getModuleClassLoader());
                    break;
                }
                case 5: {
                    result = hook.preFindResources(name2, this.getModuleClassLoader());
                    break;
                }
                case 6: {
                    result = hook.postFindResources(name2, this.getModuleClassLoader());
                }
            }
            if (result == null) continue;
            return (E)result;
        }
        return (E)result;
    }

    private boolean isRequestFromVM() {
        if (!this.container.getConfiguration().contextBootDelegation) {
            return false;
        }
        Class<?>[] context = CLASS_CONTEXT.getClassContext();
        if (context == null || context.length < 2) {
            return false;
        }
        int i2 = 1;
        while (i2 < context.length) {
            Class<?> clazz = context[i2];
            if (clazz != BundleLoader.class && !ModuleClassLoader.class.isAssignableFrom(clazz) && clazz != ClassLoader.class && clazz != Class.class && !clazz.getName().equals("java.lang.J9VMInternals")) {
                if (Bundle.class.isAssignableFrom(clazz)) {
                    return false;
                }
                ClassLoader cl = BundleLoader.getClassLoader(clazz);
                if (cl != FW_CLASSLOADER) {
                    ClassLoader last = null;
                    while (cl != null && cl != last) {
                        last = cl;
                        if (cl instanceof ModuleClassLoader) {
                            return false;
                        }
                        cl = BundleLoader.getClassLoader(cl.getClass());
                    }
                    return true;
                }
            }
            ++i2;
        }
        return false;
    }

    private static ClassLoader getClassLoader(Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getClassLoader();
        }
        return AccessController.doPrivileged(clazz::getClassLoader);
    }

    public URL findResource(String name2) {
        URL result;
        if (this.debug.DEBUG_LOADER) {
            Debug.println("BundleLoader[" + this + "].findResource(" + name2 + ")");
        }
        if (name2.length() > 1 && name2.charAt(0) == '/') {
            name2 = name2.substring(1);
        }
        String pkgName = BundleLoader.getResourcePackageName(name2);
        boolean bootDelegation = false;
        if (this.parent != null) {
            if (pkgName.startsWith(JAVA_PACKAGE)) {
                return this.parent.getResource(name2);
            }
            if (this.container.isBootDelegationPackage(pkgName)) {
                result = this.parent.getResource(name2);
                if (result != null) {
                    return result;
                }
                bootDelegation = true;
            }
        }
        result = null;
        try {
            result = (URL)this.searchHooks(name2, 3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (result != null) {
            return result;
        }
        PackageSource source = this.findImportedSource(pkgName, null);
        if (source != null) {
            if (this.debug.DEBUG_LOADER) {
                Debug.println("BundleLoader[" + this + "] loading from import package: " + source);
            }
            return source.getResource(name2);
        }
        source = this.findRequiredSource(pkgName, null);
        if (source != null) {
            if (this.debug.DEBUG_LOADER) {
                Debug.println("BundleLoader[" + this + "] loading from required bundle package: " + source);
            }
            result = source.getResource(name2);
        }
        if (result == null) {
            result = this.findLocalResource(name2);
        }
        if (result != null) {
            return result;
        }
        if (source == null && (source = this.findDynamicSource(pkgName)) != null) {
            return source.getResource(name2);
        }
        if (result == null) {
            try {
                result = (URL)this.searchHooks(name2, 4);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (result == null && this.policy != null) {
            result = this.policy.doBuddyResourceLoading(name2);
        }
        if (result != null) {
            return result;
        }
        if (this.parent != null && !bootDelegation && (this.container.getConfiguration().compatibilityBootDelegation || this.isRequestFromVM())) {
            return this.parent.getResource(name2);
        }
        return result;
    }

    public Enumeration<URL> findResources(String name2) throws IOException {
        if (this.debug.DEBUG_LOADER) {
            Debug.println("BundleLoader[" + this + "].findResources(" + name2 + ")");
        }
        if (name2.length() > 1 && name2.charAt(0) == '/') {
            name2 = name2.substring(1);
        }
        String pkgName = BundleLoader.getResourcePackageName(name2);
        Enumeration<URL> result = Collections.emptyEnumeration();
        boolean bootDelegation = false;
        if (this.parent != null) {
            if (pkgName.startsWith(JAVA_PACKAGE)) {
                return this.parent.getResources(name2);
            }
            if (this.container.isBootDelegationPackage(pkgName)) {
                result = BundleLoader.compoundEnumerations(result, this.parent.getResources(name2));
                bootDelegation = true;
            }
        }
        try {
            Enumeration hookResources = (Enumeration)this.searchHooks(name2, 5);
            if (hookResources != null) {
                return BundleLoader.compoundEnumerations(result, hookResources);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
            return result;
        }
        PackageSource source = this.findImportedSource(pkgName, null);
        if (source != null) {
            if (this.debug.DEBUG_LOADER) {
                Debug.println("BundleLoader[" + this + "] loading from import package: " + source);
            }
            return BundleLoader.compoundEnumerations(result, source.getResources(name2));
        }
        source = this.findRequiredSource(pkgName, null);
        if (source != null) {
            if (this.debug.DEBUG_LOADER) {
                Debug.println("BundleLoader[" + this + "] loading from required bundle package: " + source);
            }
            result = BundleLoader.compoundEnumerations(result, source.getResources(name2));
        }
        Enumeration<URL> localResults = this.findLocalResources(name2);
        result = BundleLoader.compoundEnumerations(result, localResults);
        if (source == null && !result.hasMoreElements() && (source = this.findDynamicSource(pkgName)) != null) {
            return BundleLoader.compoundEnumerations(result, source.getResources(name2));
        }
        if (!result.hasMoreElements()) {
            try {
                Enumeration hookResources = (Enumeration)this.searchHooks(name2, 6);
                result = BundleLoader.compoundEnumerations(result, hookResources);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        if (this.policy != null) {
            Enumeration<URL> buddyResult = this.policy.doBuddyResourcesLoading(name2);
            result = BundleLoader.compoundEnumerations(result, buddyResult);
        }
        if (!result.hasMoreElements() && this.parent != null && !bootDelegation && (this.container.getConfiguration().compatibilityBootDelegation || this.isRequestFromVM())) {
            return this.parent.getResources(name2);
        }
        return result;
    }

    private boolean isSubPackage(String parentPackage, String subPackage) {
        String prefix = parentPackage.length() == 0 || parentPackage.equals(DEFAULT_PACKAGE) ? "" : String.valueOf(parentPackage) + '.';
        return subPackage.startsWith(prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<String> listResources(String path, String filePattern, int options) {
        ArrayList<PackageSource> imports;
        Map<String, PackageSource> importSources;
        String pkgName = BundleLoader.getResourcePackageName(path.endsWith("/") ? path : String.valueOf(path) + '/');
        if (path.length() > 1 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        boolean subPackages = (options & 1) != 0;
        ArrayList<String> packages = new ArrayList<String>();
        Map<String, PackageSource> map2 = importSources = this.getImportedSources(null);
        synchronized (map2) {
            imports = new ArrayList<PackageSource>(importSources.values());
        }
        for (PackageSource source : imports) {
            String id = source.getId();
            if (!id.equals(pkgName) && (!subPackages || !this.isSubPackage(pkgName, id))) continue;
            packages.add(id);
        }
        ArrayList<BundleLoader> visited = new ArrayList<BundleLoader>();
        visited.add(this);
        for (ModuleWire bundleWire : this.requiredBundleWires) {
            BundleLoader loader = this.getProviderLoader(bundleWire);
            if (loader == null) continue;
            loader.addProvidedPackageNames(pkgName, packages, subPackages, visited);
        }
        boolean localSearch = (options & 2) != 0;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        HashSet<String> importedPackages = new HashSet<String>(0);
        for (String name2 : packages) {
            PackageSource externalSource = this.findImportedSource(name2, null);
            if (externalSource != null) {
                importedPackages.add(name2);
            } else {
                externalSource = this.findRequiredSource(name2, null);
            }
            if (externalSource == null || localSearch) continue;
            String packagePath = name2.replace('.', '/');
            Collection<String> externalResources = externalSource.listResources(packagePath, filePattern);
            for (String resource : externalResources) {
                if (result.contains(resource)) continue;
                result.add(resource);
            }
        }
        Collection<String> localResources = this.getModuleClassLoader().listLocalResources(path, filePattern, options);
        for (String resource : localResources) {
            String resourcePkg = BundleLoader.getResourcePackageName(resource);
            if (importedPackages.contains(resourcePkg) || result.contains(resource)) continue;
            result.add(resource);
        }
        return result;
    }

    @Override
    protected List<URL> findEntries(String path, String filePattern, int options) {
        return this.getModuleClassLoader().findEntries(path, filePattern, options);
    }

    public static <E> Enumeration<E> compoundEnumerations(Enumeration<E> list1, Enumeration<E> list2) {
        if (list2 == null || !list2.hasMoreElements()) {
            return list1 == null ? Collections.emptyEnumeration() : list1;
        }
        if (list1 == null || !list1.hasMoreElements()) {
            return list2 == null ? Collections.emptyEnumeration() : list2;
        }
        ArrayList<E> compoundResults = Collections.list(list1);
        while (list2.hasMoreElements()) {
            E item = list2.nextElement();
            if (compoundResults.contains(item)) continue;
            compoundResults.add(item);
        }
        return Collections.enumeration(compoundResults);
    }

    public URL findLocalResource(String name2) {
        return this.getModuleClassLoader().findLocalResource(name2);
    }

    public Enumeration<URL> findLocalResources(String name2) {
        return this.getModuleClassLoader().findLocalResources(name2);
    }

    public final String toString() {
        ModuleRevision revision = this.wiring.getRevision();
        String name2 = revision.getSymbolicName();
        if (name2 == null) {
            name2 = "unknown";
        }
        return String.valueOf(name2) + '_' + revision.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean isDynamicallyImported(String pkgname) {
        if (this instanceof SystemBundleLoader) {
            return false;
        }
        if (pkgname.startsWith(JAVA_PACKAGE)) {
            return true;
        }
        Map<String, PackageSource> map2 = this.importedSources;
        synchronized (map2) {
            int n;
            int n2;
            String[] stringArray;
            if (this.dynamicAllPackages) {
                return true;
            }
            if (this.dynamicImportPackages != null) {
                stringArray = this.dynamicImportPackages;
                n2 = this.dynamicImportPackages.length;
                n = 0;
                while (n < n2) {
                    String dynamicImportPackage = stringArray[n];
                    if (pkgname.equals(dynamicImportPackage)) {
                        return true;
                    }
                    ++n;
                }
            }
            if (this.dynamicImportPackageStems == null) return false;
            stringArray = this.dynamicImportPackageStems;
            n2 = this.dynamicImportPackageStems.length;
            n = 0;
            while (true) {
                if (n >= n2) {
                    return false;
                }
                String dynamicImportPackageStem = stringArray[n];
                if (pkgname.startsWith(dynamicImportPackageStem)) {
                    return true;
                }
                ++n;
            }
        }
    }

    final void addExportedProvidersFor(String packageName, List<PackageSource> result, Collection<BundleLoader> visited) {
        if (visited.contains(this)) {
            return;
        }
        visited.add(this);
        PackageSource local = null;
        if (this.isExportedPackage(packageName)) {
            local = this.exportSources.getPackageSource(packageName);
        } else if (this.isSubstitutedExport(packageName)) {
            result.add(this.findImportedSource(packageName, visited));
            return;
        }
        for (ModuleWire bundleWire : this.requiredBundleWires) {
            BundleLoader loader;
            if (local == null && !"reexport".equals(bundleWire.getRequirement().getDirectives().get("visibility")) || (loader = this.getProviderLoader(bundleWire)) == null) continue;
            loader.addExportedProvidersFor(packageName, result, visited);
        }
        if (local != null) {
            result.add(local);
        }
    }

    private BundleLoader getProviderLoader(ModuleWire wire) {
        ModuleWiring provider = wire.getProviderWiring();
        if (provider == null) {
            if (this.firstUseOfInvalidLoader.getAndSet(true)) {
                String message = "Invalid class loader from a refreshed bundle is being used: " + this.toString();
                this.container.getEventPublisher().publishFrameworkEvent(2, this.wiring.getBundle(), new IllegalStateException(message));
            }
            return null;
        }
        return (BundleLoader)provider.getModuleLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addProvidedPackageNames(String packageName, List<String> result, boolean subPackages, Collection<BundleLoader> visited) {
        if (visited.contains(this)) {
            return;
        }
        visited.add(this);
        Collection<String> collection = this.exportedPackages;
        synchronized (collection) {
            for (String exported : this.exportedPackages) {
                if (!exported.equals(packageName) && (!subPackages || !this.isSubPackage(packageName, exported)) || result.contains(exported)) continue;
                result.add(exported);
            }
        }
        for (String substituted : this.wiring.getSubstitutedNames()) {
            if (!substituted.equals(packageName) && (!subPackages || !this.isSubPackage(packageName, substituted)) || result.contains(substituted)) continue;
            result.add(substituted);
        }
        for (ModuleWire bundleWire : this.requiredBundleWires) {
            BundleLoader loader;
            if (!"reexport".equals(bundleWire.getRequirement().getDirectives().get("visibility")) || (loader = this.getProviderLoader(bundleWire)) == null) continue;
            loader.addProvidedPackageNames(packageName, result, subPackages, visited);
        }
    }

    public final boolean isExportedPackage(String name2) {
        return this.exportedPackages.contains(name2);
    }

    final boolean isSubstitutedExport(String name2) {
        return this.wiring.isSubstitutedPackage(name2);
    }

    private void addDynamicImportPackage(List<ModuleRequirement> packageImports) {
        if (packageImports == null || packageImports.isEmpty()) {
            return;
        }
        ArrayList<String> dynamicImports = new ArrayList<String>(packageImports.size());
        for (ModuleRequirement packageImport : packageImports) {
            String dynamicName;
            Matcher matcher;
            if (!"dynamic".equals(packageImport.getDirectives().get("resolution")) || !(matcher = PACKAGENAME_FILTER.matcher(packageImport.getDirectives().get("filter"))).find() || (dynamicName = matcher.group(1)) == null) continue;
            dynamicImports.add(dynamicName);
        }
        if (dynamicImports.size() > 0) {
            this.addDynamicImportPackage(dynamicImports.toArray(new String[dynamicImports.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDynamicImportPackage(String[] packages) {
        if (packages == null) {
            return;
        }
        Map<String, PackageSource> map2 = this.importedSources;
        synchronized (map2) {
            ArrayList<String> names;
            int n;
            ArrayList<String> stems;
            int size = packages.length;
            if (this.dynamicImportPackageStems == null) {
                stems = new ArrayList<String>(size);
            } else {
                stems = new ArrayList(size + this.dynamicImportPackageStems.length);
                String[] stringArray = this.dynamicImportPackageStems;
                n = this.dynamicImportPackageStems.length;
                int n2 = 0;
                while (n2 < n) {
                    String dynamicImportPackageStem = stringArray[n2];
                    stems.add(dynamicImportPackageStem);
                    ++n2;
                }
            }
            if (this.dynamicImportPackages == null) {
                names = new ArrayList<String>(size);
            } else {
                names = new ArrayList(size + this.dynamicImportPackages.length);
                String[] stringArray = this.dynamicImportPackages;
                int n3 = this.dynamicImportPackages.length;
                n = 0;
                while (n < n3) {
                    String dynamicImportPackage = stringArray[n];
                    names.add(dynamicImportPackage);
                    ++n;
                }
            }
            int i2 = 0;
            while (i2 < size) {
                String name2 = packages[i2];
                if (!this.isDynamicallyImported(name2)) {
                    if (name2.equals("*")) {
                        this.dynamicAllPackages = true;
                        return;
                    }
                    if (name2.endsWith(".*")) {
                        stems.add(name2.substring(0, name2.length() - 1));
                    } else {
                        names.add(name2);
                    }
                }
                ++i2;
            }
            size = stems.size();
            if (size > 0) {
                this.dynamicImportPackageStems = stems.toArray(new String[size]);
            }
            if ((size = names.size()) > 0) {
                this.dynamicImportPackages = names.toArray(new String[size]);
            }
        }
    }

    public final void addDynamicImportPackage(ManifestElement[] packages) {
        if (packages == null) {
            return;
        }
        ArrayList dynamicImports = new ArrayList(packages.length);
        StringBuilder importSpec = new StringBuilder();
        ManifestElement[] manifestElementArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestElement dynamicImportElement = manifestElementArray[n2];
            String[] names = dynamicImportElement.getValueComponents();
            Collections.addAll(dynamicImports, names);
            if (importSpec.length() > 0) {
                importSpec.append(',');
            }
            importSpec.append(dynamicImportElement.toString());
            ++n2;
        }
        if (dynamicImports.size() > 0) {
            HashMap<String, String> dynamicImportMap = new HashMap<String, String>();
            dynamicImportMap.put("DynamicImport-Package", importSpec.toString());
            try {
                ModuleRevisionBuilder builder = OSGiManifestBuilderFactory.createBuilder(dynamicImportMap);
                this.wiring.addDynamicImports(builder);
            }
            catch (BundleException e) {
                throw new RuntimeException(e);
            }
            this.addDynamicImportPackage(dynamicImports.toArray(new String[dynamicImports.size()]));
        }
    }

    private PackageSource findSource(String pkgName) {
        if (pkgName == null) {
            return null;
        }
        PackageSource result = this.findImportedSource(pkgName, null);
        if (result != null) {
            return result;
        }
        return this.findRequiredSource(pkgName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageSource findImportedSource(String pkgName, Collection<BundleLoader> visited) {
        Map<String, PackageSource> imports;
        Map<String, PackageSource> map2 = imports = this.getImportedSources(visited);
        synchronized (map2) {
            return imports.get(pkgName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, PackageSource> getImportedSources(Collection<BundleLoader> visited) {
        Map<String, PackageSource> map2 = this.importedSources;
        synchronized (map2) {
            if (this.importsInitialized) {
                return this.importedSources;
            }
            List<ModuleWire> importWires = this.wiring.getRequiredModuleWires("osgi.wiring.package");
            if (importWires != null) {
                for (ModuleWire importWire : importWires) {
                    PackageSource source = this.createExportPackageSource(importWire, visited);
                    if (source == null) continue;
                    this.importedSources.put(source.getId(), source);
                }
            }
            this.importsInitialized = true;
            return this.importedSources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageSource findDynamicSource(String pkgName) {
        if (!this.isExportedPackage(pkgName) && this.isDynamicallyImported(pkgName)) {
            ModuleRevision revision;
            ModuleWire dynamicWire;
            if (this.debug.DEBUG_LOADER) {
                Debug.println("BundleLoader[" + this + "] attempting to resolve dynamic package: " + pkgName);
            }
            if ((dynamicWire = (revision = this.wiring.getRevision()).getRevisions().getModule().getContainer().resolveDynamic(pkgName, revision)) != null) {
                PackageSource source = this.createExportPackageSource(dynamicWire, null);
                if (this.debug.DEBUG_LOADER) {
                    Debug.println("BundleLoader[" + this + "] using dynamic import source: " + source);
                }
                Map<String, PackageSource> map2 = this.importedSources;
                synchronized (map2) {
                    this.importedSources.put(source.getId(), source);
                }
                return source;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageSource findRequiredSource(String pkgName, Collection<BundleLoader> visited) {
        PackageSource source;
        if (this.requiredBundleWires.isEmpty()) {
            return null;
        }
        Map<String, PackageSource> map2 = this.requiredSources;
        synchronized (map2) {
            PackageSource result = this.requiredSources.get(pkgName);
            if (result != null) {
                return result.isNullSource() ? null : result;
            }
        }
        if (visited == null) {
            visited = new ArrayList<BundleLoader>();
        }
        if (!visited.contains(this)) {
            visited.add(this);
        }
        ArrayList<PackageSource> result = new ArrayList<PackageSource>(3);
        for (ModuleWire bundleWire : this.requiredBundleWires) {
            BundleLoader loader = this.getProviderLoader(bundleWire);
            if (loader == null) continue;
            loader.addExportedProvidersFor(pkgName, result, visited);
        }
        if (result.size() == 0) {
            source = NullPackageSource.getNullPackageSource(pkgName);
        } else if (result.size() == 1) {
            source = (PackageSource)result.get(0);
        } else {
            PackageSource[] srcs = result.toArray(new PackageSource[result.size()]);
            source = BundleLoader.createMultiSource(pkgName, srcs);
        }
        Map<String, PackageSource> map3 = this.requiredSources;
        synchronized (map3) {
            this.requiredSources.put(source.getId(), source);
        }
        return source.isNullSource() ? null : source;
    }

    public final PackageSource getPackageSource(String pkgName) {
        PackageSource result = this.findSource(pkgName);
        if (!this.isExportedPackage(pkgName)) {
            return result;
        }
        PackageSource localSource = this.exportSources.getPackageSource(pkgName);
        if (result == null) {
            return localSource;
        }
        if (localSource == null) {
            return result;
        }
        return BundleLoader.createMultiSource(pkgName, new PackageSource[]{result, localSource});
    }

    @Override
    protected boolean getAndSetTrigger() {
        return this.triggerClassLoaded.getAndSet(true);
    }

    @Override
    public boolean isTriggerSet() {
        return this.triggerClassLoaded.get();
    }

    static final class ClassContext
    extends SecurityManager {
        ClassContext() {
        }

        @Override
        public Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

