/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.util;

import paper.libs.org.eclipse.jdt.core.compiler.CharOperation;
import paper.libs.org.eclipse.jdt.core.util.ClassFormatException;
import paper.libs.org.eclipse.jdt.core.util.IConstantPool;
import paper.libs.org.eclipse.jdt.core.util.IConstantPoolEntry;
import paper.libs.org.eclipse.jdt.core.util.IConstantPoolEntry3;
import paper.libs.org.eclipse.jdt.core.util.IModulePackagesAttribute;
import paper.libs.org.eclipse.jdt.internal.core.util.ClassFileAttribute;

public class ModulePackagesAttribute
extends ClassFileAttribute
implements IModulePackagesAttribute {
    private int packagesCount;
    private int[] packageIndices;
    private char[][] packageNames;

    public ModulePackagesAttribute(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int readOffset = 6;
        int length = this.u2At(classFileBytes, readOffset, offset);
        readOffset += 2;
        this.packagesCount = length;
        if (length != 0) {
            this.packageIndices = new int[length];
            this.packageNames = new char[length][0];
            int i2 = 0;
            while (i2 < length) {
                this.packageIndices[i2] = this.u2At(classFileBytes, readOffset, offset);
                readOffset += 2;
                IConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(this.packageIndices[i2]);
                if (constantPoolEntry.getKind() != 20) {
                    throw new ClassFormatException(3);
                }
                char[] name2 = ((IConstantPoolEntry3)constantPoolEntry).getPackageName();
                this.packageNames[i2] = name2 != null ? name2 : CharOperation.NO_CHAR;
                ++i2;
            }
        } else {
            this.packageNames = CharOperation.NO_CHAR_CHAR;
        }
    }

    @Override
    public int getPackagesCount() {
        return this.packagesCount;
    }

    @Override
    public int[] getPackageIndices() {
        return this.packageIndices;
    }

    @Override
    public char[][] getPackageNames() {
        return this.packageNames;
    }
}

