/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.search.matching;

import paper.libs.org.eclipse.core.runtime.IProgressMonitor;
import paper.libs.org.eclipse.core.runtime.SubMonitor;
import paper.libs.org.eclipse.jdt.core.ICompilationUnit;
import paper.libs.org.eclipse.jdt.core.IOrdinaryClassFile;
import paper.libs.org.eclipse.jdt.core.IType;
import paper.libs.org.eclipse.jdt.core.JavaModelException;
import paper.libs.org.eclipse.jdt.core.compiler.CharOperation;
import paper.libs.org.eclipse.jdt.core.search.IJavaSearchScope;
import paper.libs.org.eclipse.jdt.core.search.SearchEngine;
import paper.libs.org.eclipse.jdt.core.search.SearchParticipant;
import paper.libs.org.eclipse.jdt.core.search.SearchPattern;
import paper.libs.org.eclipse.jdt.internal.compiler.ASTVisitor;
import paper.libs.org.eclipse.jdt.internal.compiler.CompilationResult;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.Initializer;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import paper.libs.org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import paper.libs.org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import paper.libs.org.eclipse.jdt.internal.core.JavaModelManager;
import paper.libs.org.eclipse.jdt.internal.core.JavaProject;
import paper.libs.org.eclipse.jdt.internal.core.Openable;
import paper.libs.org.eclipse.jdt.internal.core.SourceType;
import paper.libs.org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import paper.libs.org.eclipse.jdt.internal.core.search.JavaSearchParticipant;
import paper.libs.org.eclipse.jdt.internal.core.search.PathCollector;
import paper.libs.org.eclipse.jdt.internal.core.search.PatternSearchJob;
import paper.libs.org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import paper.libs.org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import paper.libs.org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import paper.libs.org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;
import paper.libs.org.eclipse.jdt.internal.core.util.ASTNodeFinder;
import paper.libs.org.eclipse.jdt.internal.core.util.Util;

public class SuperTypeNamesCollector {
    SearchPattern pattern;
    char[] typeSimpleName;
    char[] typeQualification;
    MatchLocator locator;
    IType type;
    IProgressMonitor progressMonitor;
    char[][][] result;
    int resultIndex;
    char[][][] samePackageSuperTypeName;
    int samePackageIndex;

    public SuperTypeNamesCollector(SearchPattern pattern, char[] typeSimpleName, char[] typeQualification, MatchLocator locator, IType type, IProgressMonitor progressMonitor) {
        this.pattern = pattern;
        this.typeSimpleName = typeSimpleName;
        this.typeQualification = typeQualification;
        this.locator = locator;
        this.type = type;
        this.progressMonitor = progressMonitor;
    }

    private boolean addIfSamePackage(char[][] compoundName, char[][] path) {
        if (compoundName.length != path.length) {
            return false;
        }
        int resultLength = this.samePackageSuperTypeName.length;
        int i2 = 0;
        while (i2 < resultLength) {
            if (CharOperation.equals(this.samePackageSuperTypeName[i2], compoundName)) {
                return false;
            }
            ++i2;
        }
        i2 = 0;
        int length = compoundName.length - 1;
        while (i2 < length) {
            if (!CharOperation.equals(compoundName[i2], path[i2])) {
                return false;
            }
            ++i2;
        }
        if (resultLength == this.samePackageIndex) {
            char[][][] cArrayArray = new char[resultLength * 2][][];
            this.samePackageSuperTypeName = cArrayArray;
            System.arraycopy(this.samePackageSuperTypeName, 0, cArrayArray, 0, resultLength);
        }
        this.samePackageSuperTypeName[this.samePackageIndex++] = compoundName;
        return true;
    }

    protected void addToResult(char[][] compoundName) {
        int resultLength = this.result.length;
        int i2 = 0;
        while (i2 < resultLength) {
            if (CharOperation.equals(this.result[i2], compoundName)) {
                return;
            }
            ++i2;
        }
        if (resultLength == this.resultIndex) {
            char[][][] cArrayArray = new char[resultLength * 2][][];
            this.result = cArrayArray;
            System.arraycopy(this.result, 0, cArrayArray, 0, resultLength);
        }
        this.result[this.resultIndex++] = compoundName;
    }

    protected CompilationUnitDeclaration buildBindings(ICompilationUnit compilationUnit, boolean isTopLevelOrMember) throws JavaModelException {
        CompilationUnitDeclaration unit;
        paper.libs.org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit = (paper.libs.org.eclipse.jdt.internal.compiler.env.ICompilationUnit)((Object)compilationUnit);
        CompilationResult compilationResult = new CompilationResult(sourceUnit, 1, 1, 0);
        CompilationUnitDeclaration compilationUnitDeclaration = unit = isTopLevelOrMember ? this.locator.basicParser().dietParse(sourceUnit, compilationResult) : this.locator.basicParser().parse(sourceUnit, compilationResult);
        if (unit != null) {
            this.locator.lookupEnvironment.buildTypeBindings(unit, null);
            this.locator.lookupEnvironment.completeTypeBindings(unit, !isTopLevelOrMember);
            if (!isTopLevelOrMember) {
                if (unit.scope != null) {
                    unit.scope.faultInTypes();
                }
                unit.resolve();
            }
        }
        return unit;
    }

    public char[][][] collect() throws JavaModelException {
        if (this.type != null) {
            this.result = new char[1][][];
            this.resultIndex = 0;
            JavaProject javaProject = (JavaProject)this.type.getJavaProject();
            this.locator.initialize(javaProject, 0);
            try {
                if (this.type.isBinary()) {
                    BinaryTypeBinding binding = this.locator.cacheBinaryType(this.type, null);
                    if (binding != null) {
                        this.collectSuperTypeNames(binding, null);
                    }
                } else {
                    TypeDeclaration typeDecl;
                    SourceType sourceType;
                    boolean isTopLevelOrMember;
                    ICompilationUnit unit = this.type.getCompilationUnit();
                    CompilationUnitDeclaration parsedUnit = this.buildBindings(unit, isTopLevelOrMember = (sourceType = (SourceType)this.type).getOuterMostLocalContext() == null);
                    if (parsedUnit != null && (typeDecl = new ASTNodeFinder(parsedUnit).findType(this.type)) != null && typeDecl.binding != null) {
                        this.collectSuperTypeNames(typeDecl.binding, null);
                    }
                }
            }
            catch (AbortCompilation abortCompilation) {
                return null;
            }
            if (this.result.length > this.resultIndex) {
                char[][][] cArrayArray = new char[this.resultIndex][][];
                this.result = cArrayArray;
                System.arraycopy(this.result, 0, cArrayArray, 0, this.resultIndex);
            }
            return this.result;
        }
        String[] paths = this.getPathsOfDeclaringType();
        if (paths == null) {
            return null;
        }
        Util.sort(paths);
        JavaProject previousProject = null;
        this.result = new char[1][][];
        this.samePackageSuperTypeName = new char[1][][];
        this.resultIndex = 0;
        int i2 = 0;
        int length = paths.length;
        while (i2 < length) {
            try {
                Openable openable = this.locator.handleFactory.createOpenable(paths[i2], this.locator.scope);
                if (openable != null) {
                    IOrdinaryClassFile classFile;
                    BinaryTypeBinding binding;
                    JavaProject project = openable.getJavaProject();
                    if (!((Object)project).equals(previousProject)) {
                        previousProject = project;
                        this.locator.initialize(previousProject, 0);
                    }
                    if (openable instanceof ICompilationUnit) {
                        ICompilationUnit unit = (ICompilationUnit)((Object)openable);
                        CompilationUnitDeclaration parsedUnit = this.buildBindings(unit, true);
                        if (parsedUnit != null) {
                            parsedUnit.traverse((ASTVisitor)new TypeDeclarationVisitor(), parsedUnit.scope);
                        }
                    } else if (openable instanceof IOrdinaryClassFile && this.matches(binding = this.locator.cacheBinaryType((classFile = (IOrdinaryClassFile)((Object)openable)).getType(), null))) {
                        this.collectSuperTypeNames(binding, binding.compoundName);
                    }
                }
            }
            catch (JavaModelException | AbortCompilation exception) {}
            ++i2;
        }
        if (this.result.length > this.resultIndex) {
            char[][][] cArrayArray = new char[this.resultIndex][][];
            this.result = cArrayArray;
            System.arraycopy(this.result, 0, cArrayArray, 0, this.resultIndex);
        }
        return this.result;
    }

    protected void collectSuperTypeNames(ReferenceBinding binding, char[][] path) {
        ReferenceBinding[] interfaces;
        boolean samePackage;
        ReferenceBinding superclass = binding.superclass();
        if (path != null && superclass != null && !(samePackage = this.addIfSamePackage(superclass.compoundName, path))) {
            path = null;
        }
        if (superclass != null) {
            this.addToResult(superclass.compoundName);
            this.collectSuperTypeNames(superclass, path);
        }
        if ((interfaces = binding.superInterfaces()) != null) {
            int i2 = 0;
            while (i2 < interfaces.length) {
                ReferenceBinding interfaceBinding = interfaces[i2];
                this.addToResult(interfaceBinding.compoundName);
                this.collectSuperTypeNames(interfaceBinding, path);
                ++i2;
            }
        }
    }

    protected String[] getPathsOfDeclaringType() {
        if (this.typeQualification == null && this.typeSimpleName == null) {
            return null;
        }
        final PathCollector pathCollector = new PathCollector();
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        IndexManager indexManager = JavaModelManager.getIndexManager();
        TypeDeclarationPattern searchPattern = new TypeDeclarationPattern(this.typeSimpleName != null ? null : this.typeQualification, null, this.typeSimpleName, '\u0000', this.pattern.getMatchRule());
        IndexQueryRequestor searchRequestor = new IndexQueryRequestor(){

            @Override
            public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                TypeDeclarationPattern record = (TypeDeclarationPattern)indexRecord;
                if (record.enclosingTypeNames != IIndexConstants.ONE_ZERO_CHAR) {
                    pathCollector.acceptIndexMatch(documentPath, indexRecord, participant, access);
                }
                return true;
            }
        };
        SubMonitor subMonitor = SubMonitor.convert(this.progressMonitor, 100);
        indexManager.performConcurrentJob(new PatternSearchJob(searchPattern, new JavaSearchParticipant(), scope, searchRequestor), 3, subMonitor.split(100));
        return pathCollector.getPaths();
    }

    public char[][][] getSamePackageSuperTypeNames() {
        return this.samePackageSuperTypeName;
    }

    protected boolean matches(char[][] compoundName) {
        int length = ((char[][])compoundName).length;
        if (length == 0) {
            return false;
        }
        char[] simpleName = compoundName[length - 1];
        int last = length - 1;
        if (this.typeSimpleName == null || this.pattern.matchesName(simpleName, this.typeSimpleName)) {
            char[][] qualification = new char[last][];
            System.arraycopy(compoundName, 0, qualification, 0, last);
            return this.pattern.matchesName(this.typeQualification, CharOperation.concatWith(qualification, '.'));
        }
        if (!CharOperation.endsWith(simpleName, this.typeSimpleName)) {
            return false;
        }
        char[][] cArray = compoundName;
        char[][] cArrayArray = new char[length + 1][];
        compoundName = cArrayArray;
        System.arraycopy(cArray, 0, cArrayArray, 0, last);
        int dollar = CharOperation.indexOf('$', simpleName);
        if (dollar == -1) {
            return false;
        }
        compoundName[last] = CharOperation.subarray(simpleName, 0, dollar);
        compoundName[length] = CharOperation.subarray(simpleName, dollar + 1, simpleName.length);
        return this.matches((char[][])compoundName);
    }

    protected boolean matches(ReferenceBinding binding) {
        return binding != null && binding.compoundName != null && this.matches(binding.compoundName);
    }

    public class TypeDeclarationVisitor
    extends ASTVisitor {
        @Override
        public boolean visit(TypeDeclaration typeDeclaration, BlockScope scope) {
            SourceTypeBinding binding = typeDeclaration.binding;
            if (SuperTypeNamesCollector.this.matches(binding)) {
                SuperTypeNamesCollector.this.collectSuperTypeNames(binding, binding.compoundName);
            }
            return true;
        }

        @Override
        public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
            SourceTypeBinding binding = typeDeclaration.binding;
            if (SuperTypeNamesCollector.this.matches(binding)) {
                SuperTypeNamesCollector.this.collectSuperTypeNames(binding, binding.compoundName);
            }
            return true;
        }

        @Override
        public boolean visit(TypeDeclaration memberTypeDeclaration, ClassScope scope) {
            SourceTypeBinding binding = memberTypeDeclaration.binding;
            if (SuperTypeNamesCollector.this.matches(binding)) {
                SuperTypeNamesCollector.this.collectSuperTypeNames(binding, binding.compoundName);
            }
            return true;
        }

        @Override
        public boolean visit(FieldDeclaration fieldDeclaration, MethodScope scope) {
            return false;
        }

        @Override
        public boolean visit(Initializer initializer, MethodScope scope) {
            return false;
        }

        @Override
        public boolean visit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
            return false;
        }

        @Override
        public boolean visit(MethodDeclaration methodDeclaration, ClassScope scope) {
            return false;
        }
    }
}

