/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.nd.java.model;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import paper.libs.org.eclipse.core.resources.IFile;
import paper.libs.org.eclipse.core.resources.ResourcesPlugin;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.IPath;
import paper.libs.org.eclipse.core.runtime.IProgressMonitor;
import paper.libs.org.eclipse.core.runtime.IStatus;
import paper.libs.org.eclipse.core.runtime.Path;
import paper.libs.org.eclipse.jdt.core.JavaModelException;
import paper.libs.org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import paper.libs.org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import paper.libs.org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import paper.libs.org.eclipse.jdt.internal.compiler.util.Util;
import paper.libs.org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import paper.libs.org.eclipse.jdt.internal.core.JavaModelManager;
import paper.libs.org.eclipse.jdt.internal.core.JrtPackageFragmentRoot;
import paper.libs.org.eclipse.jdt.internal.core.ModularClassFile;
import paper.libs.org.eclipse.jdt.internal.core.PackageFragmentRoot;
import paper.libs.org.eclipse.jdt.internal.core.nd.java.model.BinaryModuleDescriptor;
import paper.libs.org.eclipse.jdt.internal.core.nd.java.model.BinaryTypeFactory;

public class BinaryModuleFactory {
    public static BinaryModuleDescriptor createDescriptor(ModularClassFile modularClassFile) {
        return BinaryModuleFactory.createDescriptor(modularClassFile.getPackageFragmentRoot(), modularClassFile);
    }

    private static BinaryModuleDescriptor createDescriptor(PackageFragmentRoot root, ModularClassFile classFile) {
        String indexPath;
        IPath location = BinaryTypeFactory.getLocationForElement(root);
        if (location == null) {
            return null;
        }
        String entryName = "module-info.class";
        IPath workspacePath = root.getPath();
        char[] moduleName = null;
        if (root instanceof JarPackageFragmentRoot) {
            entryName = ((JarPackageFragmentRoot)root).getClassFilePath(entryName);
            indexPath = String.valueOf(root.getHandleIdentifier()) + '|' + entryName;
            if (root instanceof JrtPackageFragmentRoot) {
                moduleName = root.getElementName().toCharArray();
            }
        } else {
            location = location.append(entryName);
            indexPath = workspacePath.append(entryName).toString();
            workspacePath = classFile.resource().getFullPath();
        }
        return new BinaryModuleDescriptor(location.toString().toCharArray(), moduleName, workspacePath.toString().toCharArray(), indexPath.toCharArray());
    }

    public static IBinaryModule readModule(BinaryModuleDescriptor descriptor, IProgressMonitor monitor) throws JavaModelException, ClassFormatException {
        return BinaryModuleFactory.rawReadModule(descriptor, true);
    }

    public static IBinaryModule rawReadModule(BinaryModuleDescriptor descriptor, boolean fullyInitialize) throws JavaModelException, ClassFormatException {
        try {
            return BinaryModuleFactory.rawReadModuleTestForExists(descriptor, fullyInitialize, true);
        }
        catch (FileNotFoundException e) {
            throw new JavaModelException(e, 985);
        }
    }

    public static IBinaryModule rawReadModuleTestForExists(BinaryModuleDescriptor descriptor, boolean fullyInitialize, boolean useInvalidArchiveCache) throws JavaModelException, ClassFormatException, FileNotFoundException {
        ZipFile zip;
        block21: {
            byte[] contents2;
            if (descriptor == null) {
                return null;
            }
            if (descriptor.isInJarFile()) {
                zip = null;
                try {
                    byte[] contents3;
                    zip = JavaModelManager.getJavaModelManager().getZipFile(new Path(new String(descriptor.workspacePath)), useInvalidArchiveCache);
                    String entryName = "module-info.class";
                    ZipEntry ze = zip.getEntry(entryName);
                    if (ze == null) break block21;
                    try {
                        contents3 = Util.getZipEntryByteContent(ze, zip);
                    }
                    catch (IOException ioe) {
                        throw new JavaModelException(ioe, 985);
                    }
                    ClassFileReader classFileReader = new ClassFileReader(contents3, descriptor.indexPath, fullyInitialize);
                    IBinaryModule iBinaryModule = classFileReader.getModuleDeclaration();
                    JavaModelManager.getJavaModelManager().closeZipFile(zip);
                    return iBinaryModule;
                }
                catch (CoreException e) {
                    try {
                        throw new JavaModelException(e);
                    }
                    catch (Throwable throwable) {
                        JavaModelManager.getJavaModelManager().closeZipFile(zip);
                        throw throwable;
                    }
                }
            }
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(new String(descriptor.workspacePath)));
            try {
                Throwable ze = null;
                Object contents222 = null;
                try (InputStream stream = file.getContents(true);){
                    contents2 = Util.getInputStreamAsByteArray(stream);
                }
                catch (Throwable contents222) {
                    if (ze == null) {
                        ze = contents222;
                    } else if (ze != contents222) {
                        ze.addSuppressed(contents222);
                    }
                    throw ze;
                }
            }
            catch (CoreException e) {
                IStatus status = e.getStatus();
                if (status.getCode() == 368) {
                    throw new FileNotFoundException();
                }
                throw new JavaModelException(e);
            }
            catch (IOException e) {
                throw new JavaModelException(e, 985);
            }
            ClassFileReader classFileReader = new ClassFileReader(contents2, file.getFullPath().toString().toCharArray(), fullyInitialize);
            return classFileReader.getModuleDeclaration();
        }
        JavaModelManager.getJavaModelManager().closeZipFile(zip);
        return null;
    }
}

