/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core;

import java.util.Iterator;
import java.util.List;
import paper.libs.org.eclipse.jdt.core.ICompilationUnit;
import paper.libs.org.eclipse.jdt.core.IJavaElement;
import paper.libs.org.eclipse.jdt.core.IJavaModelStatus;
import paper.libs.org.eclipse.jdt.core.IType;
import paper.libs.org.eclipse.jdt.core.JavaModelException;
import paper.libs.org.eclipse.jdt.core.Signature;
import paper.libs.org.eclipse.jdt.core.dom.ASTNode;
import paper.libs.org.eclipse.jdt.core.dom.MethodDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.SimpleName;
import paper.libs.org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import paper.libs.org.eclipse.jdt.internal.core.CreateTypeMemberOperation;
import paper.libs.org.eclipse.jdt.internal.core.JavaModelStatus;
import paper.libs.org.eclipse.jdt.internal.core.util.Messages;
import paper.libs.org.eclipse.jdt.internal.core.util.Util;

public class CreateMethodOperation
extends CreateTypeMemberOperation {
    protected String[] parameterTypes;

    public CreateMethodOperation(IType parentElement, String source, boolean force) {
        super(parentElement, source, force);
    }

    protected String[] convertASTMethodTypesToSignatures() {
        if (this.parameterTypes == null && this.createdNode != null) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)this.createdNode;
            List parameters = methodDeclaration.parameters();
            int size = parameters.size();
            this.parameterTypes = new String[size];
            Iterator iterator = parameters.iterator();
            int i2 = 0;
            while (i2 < size) {
                SingleVariableDeclaration parameter = (SingleVariableDeclaration)iterator.next();
                String typeSig = Util.getSignature(parameter.getType());
                int extraDimensions = parameter.getExtraDimensions();
                if (methodDeclaration.isVarargs() && i2 == size - 1) {
                    ++extraDimensions;
                }
                this.parameterTypes[i2] = Signature.createArraySignature(typeSig, extraDimensions);
                ++i2;
            }
        }
        return this.parameterTypes;
    }

    @Override
    protected ASTNode generateElementAST(ASTRewrite rewriter, ICompilationUnit cu) throws JavaModelException {
        ASTNode node = super.generateElementAST(rewriter, cu);
        if (node.getNodeType() != 31) {
            throw new JavaModelException(new JavaModelStatus(984));
        }
        return node;
    }

    @Override
    protected IJavaElement generateResultHandle() {
        String[] types = this.convertASTMethodTypesToSignatures();
        String name2 = this.getASTNodeName();
        return this.getType().getMethod(name2, types);
    }

    private String getASTNodeName() {
        return ((MethodDeclaration)this.createdNode).getName().getIdentifier();
    }

    @Override
    public String getMainTaskName() {
        return Messages.operation_createMethodProgress;
    }

    @Override
    protected SimpleName rename(ASTNode node, SimpleName newName) {
        MethodDeclaration method = (MethodDeclaration)node;
        SimpleName oldName = method.getName();
        method.setName(newName);
        return oldName;
    }

    @Override
    protected IJavaModelStatus verifyNameCollision() {
        String[] types;
        String name2;
        IType type;
        if (this.createdNode != null && (type = this.getType()).getMethod(name2 = ((MethodDeclaration)this.createdNode).isConstructor() ? type.getElementName() : this.getASTNodeName(), types = this.convertASTMethodTypesToSignatures()).exists()) {
            return new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, name2));
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

