/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import paper.libs.org.eclipse.core.resources.IContainer;
import paper.libs.org.eclipse.core.resources.IFile;
import paper.libs.org.eclipse.core.resources.IResource;
import paper.libs.org.eclipse.core.resources.IWorkspace;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.NullProgressMonitor;
import paper.libs.org.eclipse.core.runtime.Path;
import paper.libs.org.eclipse.core.runtime.jobs.ISchedulingRule;
import paper.libs.org.eclipse.jdt.core.IBuffer;
import paper.libs.org.eclipse.jdt.core.ICompilationUnit;
import paper.libs.org.eclipse.jdt.core.IJavaElement;
import paper.libs.org.eclipse.jdt.core.IJavaModelStatus;
import paper.libs.org.eclipse.jdt.core.IJavaProject;
import paper.libs.org.eclipse.jdt.core.IPackageFragment;
import paper.libs.org.eclipse.jdt.core.JavaConventions;
import paper.libs.org.eclipse.jdt.core.JavaModelException;
import paper.libs.org.eclipse.jdt.internal.core.JavaElementDelta;
import paper.libs.org.eclipse.jdt.internal.core.JavaModelOperation;
import paper.libs.org.eclipse.jdt.internal.core.JavaModelStatus;
import paper.libs.org.eclipse.jdt.internal.core.util.Messages;
import paper.libs.org.eclipse.jdt.internal.core.util.Util;

public class CreateCompilationUnitOperation
extends JavaModelOperation {
    protected String name;
    protected String source = null;

    public CreateCompilationUnitOperation(IPackageFragment parentElement, String name2, String source, boolean force) {
        super(null, new IJavaElement[]{parentElement}, force);
        this.name = name2;
        this.source = source;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void executeOperation() throws JavaModelException {
        try {
            this.beginTask(Messages.operation_createUnitProgress, 2);
            JavaElementDelta delta = this.newJavaElementDelta();
            ICompilationUnit unit = this.getCompilationUnit();
            IPackageFragment pkg = (IPackageFragment)this.getParentElement();
            IContainer folder = (IContainer)pkg.getResource();
            this.worked(1);
            IFile compilationUnitFile = folder.getFile(new Path(this.name));
            if (compilationUnitFile.exists()) {
                if (!this.force) throw new JavaModelException(new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, compilationUnitFile.getFullPath().toString())));
                IBuffer buffer = unit.getBuffer();
                if (buffer == null) {
                    return;
                }
                buffer.setContents(this.source);
                unit.save(new NullProgressMonitor(), false);
                this.resultElements = new IJavaElement[]{unit};
                if (!Util.isExcluded(unit) && unit.getParent().exists()) {
                    int i2 = 0;
                    while (i2 < this.resultElements.length) {
                        delta.changed(this.resultElements[i2], 1);
                        ++i2;
                    }
                    this.addDelta(delta);
                }
            } else {
                try {
                    String encoding = null;
                    try {
                        encoding = folder.getDefaultCharset();
                    }
                    catch (CoreException coreException) {}
                    ByteArrayInputStream stream = new ByteArrayInputStream(encoding == null ? this.source.getBytes() : this.source.getBytes(encoding));
                    this.createFile(folder, unit.getElementName(), stream, this.force);
                    this.resultElements = new IJavaElement[]{unit};
                    if (!Util.isExcluded(unit) && unit.getParent().exists()) {
                        int i3 = 0;
                        while (i3 < this.resultElements.length) {
                            delta.added(this.resultElements[i3]);
                            ++i3;
                        }
                        this.addDelta(delta);
                    }
                }
                catch (IOException e) {
                    throw new JavaModelException(e, 985);
                }
            }
            this.worked(1);
            return;
        }
        finally {
            this.done();
        }
    }

    protected ICompilationUnit getCompilationUnit() {
        return ((IPackageFragment)this.getParentElement()).getCompilationUnit(this.name);
    }

    @Override
    protected ISchedulingRule getSchedulingRule() {
        IResource resource = this.getCompilationUnit().getResource();
        IWorkspace workspace = resource.getWorkspace();
        if (resource.exists()) {
            return workspace.getRuleFactory().modifyRule(resource);
        }
        return workspace.getRuleFactory().createRule(resource);
    }

    @Override
    public IJavaModelStatus verify() {
        if (this.getParentElement() == null) {
            return new JavaModelStatus(968);
        }
        IJavaProject project = this.getParentElement().getJavaProject();
        if (JavaConventions.validateCompilationUnitName(this.name, project.getOption("paper.libs.org.eclipse.jdt.core.compiler.source", true), project.getOption("paper.libs.org.eclipse.jdt.core.compiler.compliance", true)).getSeverity() == 4) {
            return new JavaModelStatus(983, this.name);
        }
        if (this.source == null) {
            return new JavaModelStatus(984);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

