/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import paper.libs.org.eclipse.core.resources.IContainer;
import paper.libs.org.eclipse.core.resources.IFile;
import paper.libs.org.eclipse.core.resources.IFolder;
import paper.libs.org.eclipse.core.resources.IResource;
import paper.libs.org.eclipse.core.resources.IResourceRuleFactory;
import paper.libs.org.eclipse.core.resources.ResourcesPlugin;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.IPath;
import paper.libs.org.eclipse.core.runtime.Path;
import paper.libs.org.eclipse.core.runtime.jobs.ISchedulingRule;
import paper.libs.org.eclipse.core.runtime.jobs.MultiRule;
import paper.libs.org.eclipse.jdt.core.ICompilationUnit;
import paper.libs.org.eclipse.jdt.core.IJavaElement;
import paper.libs.org.eclipse.jdt.core.IJavaElementDelta;
import paper.libs.org.eclipse.jdt.core.IJavaModelStatus;
import paper.libs.org.eclipse.jdt.core.IJavaProject;
import paper.libs.org.eclipse.jdt.core.IPackageFragment;
import paper.libs.org.eclipse.jdt.core.IPackageFragmentRoot;
import paper.libs.org.eclipse.jdt.core.IType;
import paper.libs.org.eclipse.jdt.core.JavaModelException;
import paper.libs.org.eclipse.jdt.core.dom.AST;
import paper.libs.org.eclipse.jdt.core.dom.ASTNode;
import paper.libs.org.eclipse.jdt.core.dom.ASTParser;
import paper.libs.org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.Javadoc;
import paper.libs.org.eclipse.jdt.core.dom.MethodDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.Name;
import paper.libs.org.eclipse.jdt.core.dom.PackageDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.SimpleName;
import paper.libs.org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import paper.libs.org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import paper.libs.org.eclipse.jdt.internal.core.CompilationUnit;
import paper.libs.org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import paper.libs.org.eclipse.jdt.internal.core.JavaElement;
import paper.libs.org.eclipse.jdt.internal.core.JavaElementDelta;
import paper.libs.org.eclipse.jdt.internal.core.JavaModelStatus;
import paper.libs.org.eclipse.jdt.internal.core.JavaProject;
import paper.libs.org.eclipse.jdt.internal.core.MultiOperation;
import paper.libs.org.eclipse.jdt.internal.core.PackageFragment;
import paper.libs.org.eclipse.jdt.internal.core.PackageFragmentRoot;
import paper.libs.org.eclipse.jdt.internal.core.util.Messages;
import paper.libs.org.eclipse.jdt.internal.core.util.Util;
import paper.libs.org.eclipse.text.edits.TextEdit;

public class CopyResourceElementsOperation
extends MultiOperation
implements SuffixConstants {
    protected ArrayList createdElements;
    protected Map deltasPerProject = new HashMap(1);
    protected ASTParser parser;

    public CopyResourceElementsOperation(IJavaElement[] resourcesToCopy, IJavaElement[] destContainers, boolean force) {
        super(resourcesToCopy, destContainers, force);
        this.initializeASTParser();
    }

    private void initializeASTParser() {
        this.parser = ASTParser.newParser(this.getLatestASTLevel());
    }

    private IResource[] collectResourcesOfInterest(IPackageFragment source) throws JavaModelException {
        IJavaElement[] children = source.getChildren();
        int childOfInterest = 5;
        if (source.getKind() == 2) {
            childOfInterest = 6;
        }
        ArrayList<IResource> correctKindChildren = new ArrayList<IResource>(children.length);
        int i2 = 0;
        while (i2 < children.length) {
            IJavaElement child = children[i2];
            if (child.getElementType() == childOfInterest) {
                correctKindChildren.add(((JavaElement)child).resource());
            }
            ++i2;
        }
        Object[] nonJavaResources = source.getNonJavaResources();
        int actualNonJavaResourceCount = 0;
        int i3 = 0;
        int max = nonJavaResources.length;
        while (i3 < max) {
            if (nonJavaResources[i3] instanceof IResource) {
                ++actualNonJavaResourceCount;
            }
            ++i3;
        }
        IResource[] actualNonJavaResources = new IResource[actualNonJavaResourceCount];
        int i4 = 0;
        int max2 = nonJavaResources.length;
        int index = 0;
        while (i4 < max2) {
            if (nonJavaResources[i4] instanceof IResource) {
                actualNonJavaResources[index++] = (IResource)nonJavaResources[i4];
            }
            ++i4;
        }
        if (actualNonJavaResourceCount != 0) {
            int correctKindChildrenSize = correctKindChildren.size();
            IResource[] result = new IResource[correctKindChildrenSize + actualNonJavaResourceCount];
            correctKindChildren.toArray(result);
            System.arraycopy(actualNonJavaResources, 0, result, correctKindChildrenSize, actualNonJavaResourceCount);
            return result;
        }
        IResource[] result = new IResource[correctKindChildren.size()];
        correctKindChildren.toArray(result);
        return result;
    }

    private boolean createNeededPackageFragments(IContainer sourceFolder, PackageFragmentRoot root, String[] newFragName, boolean moveFolder) throws JavaModelException {
        boolean containsReadOnlyPackageFragment = false;
        IContainer parentFolder = (IContainer)root.resource();
        JavaElementDelta projectDelta = null;
        String[] sideEffectPackageName = null;
        char[][] inclusionPatterns = root.fullInclusionPatternChars();
        char[][] exclusionPatterns = root.fullExclusionPatternChars();
        int i2 = 0;
        while (i2 < newFragName.length) {
            String subFolderName = newFragName[i2];
            sideEffectPackageName = Util.arrayConcat(sideEffectPackageName, subFolderName);
            IResource subFolder = parentFolder.findMember(subFolderName);
            if (subFolder == null) {
                if (!moveFolder || i2 != newFragName.length - 1) {
                    this.createFolder(parentFolder, subFolderName, this.force);
                }
                parentFolder = parentFolder.getFolder(new Path(subFolderName));
                if (Util.isReadOnly(sourceFolder = sourceFolder.getFolder(new Path(subFolderName)))) {
                    containsReadOnlyPackageFragment = true;
                }
                PackageFragment sideEffectPackage = root.getPackageFragment(sideEffectPackageName);
                if (i2 < newFragName.length - 1 && !Util.isExcluded(parentFolder, inclusionPatterns, exclusionPatterns)) {
                    if (projectDelta == null) {
                        projectDelta = this.getDeltaFor(root.getJavaProject());
                    }
                    projectDelta.added(sideEffectPackage);
                }
                this.createdElements.add(sideEffectPackage);
            } else {
                parentFolder = (IContainer)subFolder;
            }
            ++i2;
        }
        return containsReadOnlyPackageFragment;
    }

    private JavaElementDelta getDeltaFor(IJavaProject javaProject) {
        JavaElementDelta delta = (JavaElementDelta)this.deltasPerProject.get(javaProject);
        if (delta == null) {
            delta = new JavaElementDelta(javaProject);
            this.deltasPerProject.put(javaProject, delta);
        }
        return delta;
    }

    @Override
    protected String getMainTaskName() {
        return Messages.operation_copyResourceProgress;
    }

    @Override
    protected ISchedulingRule getSchedulingRule() {
        if (this.elementsToProcess == null) {
            return null;
        }
        int length = this.elementsToProcess.length;
        if (length == 1) {
            return this.getSchedulingRule(this.elementsToProcess[0]);
        }
        ISchedulingRule[] rules = new ISchedulingRule[length];
        int index = 0;
        int i2 = 0;
        while (i2 < length) {
            ISchedulingRule rule = this.getSchedulingRule(this.elementsToProcess[i2]);
            if (rule != null) {
                rules[index++] = rule;
            }
            ++i2;
        }
        if (index != length) {
            ISchedulingRule[] iSchedulingRuleArray = rules;
            rules = new ISchedulingRule[index];
            System.arraycopy(iSchedulingRuleArray, 0, rules, 0, index);
        }
        return new MultiRule(rules);
    }

    private ISchedulingRule getSchedulingRule(IJavaElement element) {
        IResource destResource;
        String newName;
        if (element == null) {
            return null;
        }
        IResource sourceResource = this.getResource(element);
        IResource destContainer = this.getResource(this.getDestinationParent(element));
        if (!(destContainer instanceof IContainer)) {
            return null;
        }
        try {
            newName = this.getNewNameFor(element);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        if (newName == null) {
            newName = element.getElementName();
        }
        String sourceEncoding = null;
        if (sourceResource.getType() == 1) {
            destResource = ((IContainer)destContainer).getFile(new Path(newName));
            try {
                sourceEncoding = ((IFile)sourceResource).getCharset(false);
            }
            catch (CoreException coreException) {}
        } else {
            destResource = ((IContainer)destContainer).getFolder(new Path(newName));
        }
        IResourceRuleFactory factory = ResourcesPlugin.getWorkspace().getRuleFactory();
        ISchedulingRule rule = this.isMove() ? factory.moveRule(sourceResource, destResource) : factory.copyRule(sourceResource, destResource);
        if (sourceEncoding != null) {
            rule = new MultiRule(new ISchedulingRule[]{rule, factory.charsetRule(destResource)});
        }
        return rule;
    }

    private IResource getResource(IJavaElement element) {
        String pkgName;
        int firstDot;
        if (element == null) {
            return null;
        }
        if (element.getElementType() == 4 && (firstDot = (pkgName = element.getElementName()).indexOf(46)) != -1) {
            element = ((IPackageFragmentRoot)element.getParent()).getPackageFragment(pkgName.substring(0, firstDot));
        }
        return element.getResource();
    }

    protected void prepareDeltas(IJavaElement sourceElement, IJavaElement destinationElement, boolean isMove, boolean overWriteCU) {
        if (Util.isExcluded(sourceElement) || Util.isExcluded(destinationElement)) {
            return;
        }
        IJavaProject destProject = destinationElement.getJavaProject();
        if (isMove) {
            IJavaProject sourceProject = sourceElement.getJavaProject();
            this.getDeltaFor(sourceProject).movedFrom(sourceElement, destinationElement);
            if (!overWriteCU) {
                this.getDeltaFor(destProject).movedTo(destinationElement, sourceElement);
                return;
            }
        } else if (!overWriteCU) {
            this.getDeltaFor(destProject).added(destinationElement);
            return;
        }
        this.getDeltaFor(destinationElement.getJavaProject()).changed(destinationElement, 1);
    }

    private void processCompilationUnitResource(ICompilationUnit source, PackageFragment dest) throws JavaModelException {
        String newCUName = this.getNewNameFor(source);
        String destName = newCUName != null ? newCUName : source.getElementName();
        TextEdit edit = this.updateContent(source, dest, newCUName);
        IFile sourceResource = (IFile)source.getResource();
        String sourceEncoding = null;
        try {
            sourceEncoding = sourceResource.getCharset(false);
        }
        catch (CoreException coreException) {}
        IContainer destFolder = (IContainer)dest.getResource();
        IFile destFile = destFolder.getFile(new Path(destName));
        CompilationUnit destCU = new CompilationUnit(dest, destName, DefaultWorkingCopyOwner.PRIMARY);
        if (!destFile.equals(sourceResource)) {
            try {
                if (!destCU.isWorkingCopy()) {
                    int flags;
                    if (destFile.exists()) {
                        if (this.force) {
                            this.deleteResource(destFile, 2);
                            destCU.close();
                        } else {
                            throw new JavaModelException(new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, destFile.getFullPath().toString())));
                        }
                    }
                    int n = flags = this.force ? 1 : 0;
                    if (this.isMove()) {
                        sourceResource.move(destFile.getFullPath(), flags |= 2, this.getSubProgressMonitor(1));
                    } else {
                        if (edit != null) {
                            flags |= 2;
                        }
                        sourceResource.copy(destFile.getFullPath(), flags, this.getSubProgressMonitor(1));
                    }
                    CopyResourceElementsOperation.setAttribute("hasModifiedResource", "true");
                } else {
                    destCU.getBuffer().setContents(source.getBuffer().getContents());
                }
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
            if (edit != null) {
                boolean wasReadOnly = destFile.isReadOnly();
                try {
                    try {
                        this.saveContent(dest, destName, edit, sourceEncoding, destFile);
                    }
                    catch (CoreException e) {
                        if (e instanceof JavaModelException) {
                            throw (JavaModelException)e;
                        }
                        throw new JavaModelException(e);
                    }
                }
                finally {
                    Util.setReadOnly(destFile, wasReadOnly);
                }
            }
            boolean contentChanged = this.force && destFile.exists();
            this.prepareDeltas(source, destCU, this.isMove(), contentChanged);
            if (newCUName != null) {
                String oldName = Util.getNameWithoutJavaLikeExtension(source.getElementName());
                String newName = Util.getNameWithoutJavaLikeExtension(newCUName);
                this.prepareDeltas(source.getType(oldName), destCU.getType(newName), this.isMove(), false);
            }
        } else {
            if (!this.force) {
                throw new JavaModelException(new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, destFile.getFullPath().toString())));
            }
            if (edit != null) {
                this.saveContent(dest, destName, edit, sourceEncoding, destFile);
            }
        }
    }

    protected void processDeltas() {
        Iterator deltas = this.deltasPerProject.values().iterator();
        while (deltas.hasNext()) {
            this.addDelta((IJavaElementDelta)deltas.next());
        }
    }

    @Override
    protected void processElement(IJavaElement element) throws JavaModelException {
        IJavaElement dest = this.getDestinationParent(element);
        switch (element.getElementType()) {
            case 5: {
                this.processCompilationUnitResource((ICompilationUnit)element, (PackageFragment)dest);
                this.createdElements.add(((IPackageFragment)dest).getCompilationUnit(element.getElementName()));
                break;
            }
            case 4: {
                this.processPackageFragmentResource((PackageFragment)element, (PackageFragmentRoot)dest, this.getNewNameFor(element));
                break;
            }
            default: {
                throw new JavaModelException(new JavaModelStatus(967, element));
            }
        }
    }

    @Override
    protected void processElements() throws JavaModelException {
        this.createdElements = new ArrayList(this.elementsToProcess.length);
        try {
            super.processElements();
        }
        finally {
            this.resultElements = new IJavaElement[this.createdElements.size()];
            this.createdElements.toArray(this.resultElements);
            this.processDeltas();
        }
    }

    private void processPackageFragmentResource(PackageFragment source, PackageFragmentRoot root, String newName) throws JavaModelException {
        try {
            Object[] newFragName = newName == null ? source.names : Util.getTrimmedSimpleNames(newName);
            PackageFragment newFrag = root.getPackageFragment((String[])newFragName);
            IResource[] resources = this.collectResourcesOfInterest(source);
            boolean shouldMoveFolder = this.isMove() && !newFrag.resource().exists();
            IFolder srcFolder = (IFolder)source.resource();
            IPath destPath = newFrag.getPath();
            if (shouldMoveFolder) {
                if (srcFolder.getFullPath().isPrefixOf(destPath)) {
                    shouldMoveFolder = false;
                } else {
                    IResource[] members = srcFolder.members();
                    int i2 = 0;
                    while (i2 < members.length) {
                        if (members[i2] instanceof IFolder) {
                            shouldMoveFolder = false;
                            break;
                        }
                        ++i2;
                    }
                }
            }
            boolean containsReadOnlySubPackageFragments = this.createNeededPackageFragments((IContainer)source.getParent().resource(), root, (String[])newFragName, shouldMoveFolder);
            boolean sourceIsReadOnly = Util.isReadOnly(srcFolder);
            if (shouldMoveFolder) {
                if (sourceIsReadOnly) {
                    Util.setReadOnly(srcFolder, false);
                }
                srcFolder.move(destPath, this.force, true, this.getSubProgressMonitor(1));
                if (sourceIsReadOnly) {
                    Util.setReadOnly(srcFolder, true);
                }
                CopyResourceElementsOperation.setAttribute("hasModifiedResource", "true");
            } else if (resources.length > 0) {
                IResource destinationResource;
                int max;
                int i3;
                if (this.isRename()) {
                    if (!destPath.equals(source.getPath())) {
                        this.moveResources(resources, destPath);
                    }
                } else if (this.isMove()) {
                    i3 = 0;
                    max = resources.length;
                    while (i3 < max) {
                        destinationResource = ResourcesPlugin.getWorkspace().getRoot().findMember(destPath.append(resources[i3].getName()));
                        if (destinationResource != null) {
                            if (this.force) {
                                this.deleteResource(destinationResource, 2);
                            } else {
                                throw new JavaModelException(new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, destinationResource.getFullPath().toString())));
                            }
                        }
                        ++i3;
                    }
                    this.moveResources(resources, destPath);
                } else {
                    i3 = 0;
                    max = resources.length;
                    while (i3 < max) {
                        destinationResource = ResourcesPlugin.getWorkspace().getRoot().findMember(destPath.append(resources[i3].getName()));
                        if (destinationResource != null) {
                            if (this.force) {
                                this.deleteResource(destinationResource, 2);
                            } else {
                                throw new JavaModelException(new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, destinationResource.getFullPath().toString())));
                            }
                        }
                        ++i3;
                    }
                    this.copyResources(resources, destPath);
                }
            }
            if (!Util.equalArraysOrNull(newFragName, source.names)) {
                char[][] inclusionPatterns = root.fullInclusionPatternChars();
                char[][] exclusionPatterns = root.fullExclusionPatternChars();
                int i4 = 0;
                while (i4 < resources.length) {
                    ICompilationUnit cu;
                    String resourceName = resources[i4].getName();
                    if (Util.isJavaLikeFileName(resourceName) && !Util.isExcluded((cu = newFrag.getCompilationUnit(resourceName)).getPath(), inclusionPatterns, exclusionPatterns, false)) {
                        this.parser.setSource(cu);
                        paper.libs.org.eclipse.jdt.core.dom.CompilationUnit astCU = (paper.libs.org.eclipse.jdt.core.dom.CompilationUnit)this.parser.createAST(this.progressMonitor);
                        AST ast = astCU.getAST();
                        ASTRewrite rewrite = ASTRewrite.create(ast);
                        this.updatePackageStatement(astCU, (String[])newFragName, rewrite, cu);
                        TextEdit edits = rewrite.rewriteAST();
                        this.applyTextEdit(cu, edits);
                        cu.save(null, false);
                    }
                    ++i4;
                }
            }
            boolean isEmpty = true;
            if (this.isMove()) {
                this.updateReadOnlyPackageFragmentsForMove((IContainer)source.getParent().resource(), root, (String[])newFragName, sourceIsReadOnly);
                if (srcFolder.exists()) {
                    IResource[] remaining = srcFolder.members();
                    int i5 = 0;
                    int length = remaining.length;
                    while (i5 < length) {
                        IResource file = remaining[i5];
                        if (file instanceof IFile) {
                            if (Util.isReadOnly(file)) {
                                Util.setReadOnly(file, false);
                            }
                            this.deleteResource(file, 3);
                        } else {
                            isEmpty = false;
                        }
                        ++i5;
                    }
                }
                if (isEmpty) {
                    IResource rootResource = destPath.isPrefixOf(srcFolder.getFullPath()) ? newFrag.resource() : source.getParent().resource();
                    this.deleteEmptyPackageFragment(source, false, rootResource);
                }
            } else if (containsReadOnlySubPackageFragments) {
                this.updateReadOnlyPackageFragmentsForCopy((IContainer)source.getParent().resource(), root, (String[])newFragName);
            }
            if (isEmpty && this.isMove() && !Util.isExcluded(source) && !Util.isExcluded(newFrag)) {
                JavaProject sourceProject = source.getJavaProject();
                this.getDeltaFor(sourceProject).movedFrom(source, newFrag);
                JavaProject destProject = newFrag.getJavaProject();
                this.getDeltaFor(destProject).movedTo(newFrag, source);
            }
        }
        catch (JavaModelException e) {
            throw e;
        }
        catch (CoreException ce) {
            throw new JavaModelException(ce);
        }
    }

    private void saveContent(PackageFragment dest, String destName, TextEdit edits, String sourceEncoding, IFile destFile) throws JavaModelException {
        try {
            if (sourceEncoding != null) {
                destFile.setCharset(sourceEncoding, this.progressMonitor);
            }
        }
        catch (CoreException coreException) {}
        Util.setReadOnly(destFile, false);
        ICompilationUnit destCU = dest.getCompilationUnit(destName);
        this.applyTextEdit(destCU, edits);
        destCU.save(this.getSubProgressMonitor(1), this.force);
    }

    private TextEdit updateContent(ICompilationUnit cu, PackageFragment dest, String newName) throws JavaModelException {
        Object[] currPackageName = ((PackageFragment)cu.getParent()).names;
        Object[] destPackageName = dest.names;
        if (Util.equalArraysOrNull(currPackageName, destPackageName) && newName == null) {
            return null;
        }
        cu.makeConsistent(this.progressMonitor);
        this.parser.setSource(cu);
        paper.libs.org.eclipse.jdt.core.dom.CompilationUnit astCU = (paper.libs.org.eclipse.jdt.core.dom.CompilationUnit)this.parser.createAST(this.progressMonitor);
        AST ast = astCU.getAST();
        ASTRewrite rewrite = ASTRewrite.create(ast);
        this.updateTypeName(cu, astCU, cu.getElementName(), newName, rewrite);
        this.updatePackageStatement(astCU, (String[])destPackageName, rewrite, cu);
        return rewrite.rewriteAST();
    }

    private void updatePackageStatement(paper.libs.org.eclipse.jdt.core.dom.CompilationUnit astCU, String[] pkgName, ASTRewrite rewriter, ICompilationUnit cu) throws JavaModelException {
        boolean defaultPackage = pkgName.length == 0;
        AST ast = astCU.getAST();
        if (defaultPackage) {
            PackageDeclaration pkg = astCU.getPackage();
            if (pkg != null) {
                int extendedStart;
                Javadoc javadoc = pkg.getJavadoc();
                int pkgStart = javadoc != null ? javadoc.getStartPosition() + javadoc.getLength() + 1 : pkg.getStartPosition();
                if (pkgStart != (extendedStart = astCU.getExtendedStartPosition(pkg))) {
                    String commentSource = cu.getSource().substring(extendedStart, pkgStart);
                    ASTNode comment = rewriter.createStringPlaceholder(commentSource, 35);
                    rewriter.set(astCU, paper.libs.org.eclipse.jdt.core.dom.CompilationUnit.PACKAGE_PROPERTY, comment, null);
                } else {
                    rewriter.set(astCU, paper.libs.org.eclipse.jdt.core.dom.CompilationUnit.PACKAGE_PROPERTY, null, null);
                }
            }
        } else {
            PackageDeclaration pkg = astCU.getPackage();
            if (pkg != null) {
                Name name2 = ast.newName(pkgName);
                rewriter.set(pkg, PackageDeclaration.NAME_PROPERTY, name2, null);
            } else {
                pkg = ast.newPackageDeclaration();
                pkg.setName(ast.newName(pkgName));
                rewriter.set(astCU, paper.libs.org.eclipse.jdt.core.dom.CompilationUnit.PACKAGE_PROPERTY, pkg, null);
            }
        }
    }

    private void updateReadOnlyPackageFragmentsForCopy(IContainer sourceFolder, PackageFragmentRoot root, String[] newFragName) {
        IContainer parentFolder = (IContainer)root.resource();
        int i2 = 0;
        int length = newFragName.length;
        while (i2 < length) {
            String subFolderName = newFragName[i2];
            parentFolder = parentFolder.getFolder(new Path(subFolderName));
            if ((sourceFolder = sourceFolder.getFolder(new Path(subFolderName))).exists() && Util.isReadOnly(sourceFolder)) {
                Util.setReadOnly(parentFolder, true);
            }
            ++i2;
        }
    }

    private void updateReadOnlyPackageFragmentsForMove(IContainer sourceFolder, PackageFragmentRoot root, String[] newFragName, boolean sourceFolderIsReadOnly) {
        IContainer parentFolder = (IContainer)root.resource();
        int i2 = 0;
        int length = newFragName.length;
        while (i2 < length) {
            String subFolderName = newFragName[i2];
            parentFolder = parentFolder.getFolder(new Path(subFolderName));
            if ((sourceFolder = sourceFolder.getFolder(new Path(subFolderName))).exists() && Util.isReadOnly(sourceFolder) || i2 == length - 1 && sourceFolderIsReadOnly) {
                Util.setReadOnly(parentFolder, true);
                Util.setReadOnly(sourceFolder, false);
            }
            ++i2;
        }
    }

    private void updateTypeName(ICompilationUnit cu, paper.libs.org.eclipse.jdt.core.dom.CompilationUnit astCU, String oldName, String newName, ASTRewrite rewriter) throws JavaModelException {
        if (newName != null) {
            String oldTypeName = Util.getNameWithoutJavaLikeExtension(oldName);
            String newTypeName = Util.getNameWithoutJavaLikeExtension(newName);
            AST ast = astCU.getAST();
            IType[] types = cu.getTypes();
            int i2 = 0;
            int max = types.length;
            while (i2 < max) {
                AbstractTypeDeclaration typeNode;
                IType currentType = types[i2];
                if (currentType.getElementName().equals(oldTypeName) && (typeNode = (AbstractTypeDeclaration)((JavaElement)((Object)currentType)).findNode(astCU)) != null) {
                    rewriter.replace(typeNode.getName(), ast.newSimpleName(newTypeName), null);
                    for (Object bodyDeclaration : typeNode.bodyDeclarations()) {
                        SimpleName methodName;
                        MethodDeclaration methodDeclaration;
                        if (!(bodyDeclaration instanceof MethodDeclaration) || !(methodDeclaration = (MethodDeclaration)bodyDeclaration).isConstructor() || !(methodName = methodDeclaration.getName()).getIdentifier().equals(oldTypeName)) continue;
                        rewriter.replace(methodName, ast.newSimpleName(newTypeName), null);
                    }
                }
                ++i2;
            }
        }
    }

    @Override
    protected IJavaModelStatus verify() {
        IJavaModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (this.renamingsList != null && this.renamingsList.length != this.elementsToProcess.length) {
            return new JavaModelStatus(980);
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    @Override
    protected void verify(IJavaElement element) throws JavaModelException {
        int elementType;
        IResource resource;
        if (element == null || !element.exists()) {
            this.error(969, element);
        }
        if (element.isReadOnly() && (this.isRename() || this.isMove())) {
            this.error(976, element);
        }
        if ((resource = ((JavaElement)element).resource()) instanceof IFolder && resource.isLinked()) {
            this.error(995, element);
        }
        if ((elementType = element.getElementType()) == 5) {
            CompilationUnit compilationUnit = (CompilationUnit)element;
            if (this.isMove() && compilationUnit.isWorkingCopy() && !compilationUnit.isPrimary()) {
                this.error(967, element);
            }
        } else if (elementType != 4) {
            this.error(967, element);
        }
        JavaElement dest = (JavaElement)this.getDestinationParent(element);
        this.verifyDestination(element, dest);
        if (this.renamings != null) {
            this.verifyRenaming(element);
        }
    }
}

