/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import paper.libs.org.eclipse.core.runtime.IPath;
import paper.libs.org.eclipse.core.runtime.IProgressMonitor;
import paper.libs.org.eclipse.core.runtime.OperationCanceledException;
import paper.libs.org.eclipse.jdt.core.IClasspathEntry;
import paper.libs.org.eclipse.jdt.core.ICompilationUnit;
import paper.libs.org.eclipse.jdt.core.IJavaProject;
import paper.libs.org.eclipse.jdt.core.IModuleDescription;
import paper.libs.org.eclipse.jdt.core.JavaModelException;
import paper.libs.org.eclipse.jdt.core.WorkingCopyOwner;
import paper.libs.org.eclipse.jdt.core.compiler.CategorizedProblem;
import paper.libs.org.eclipse.jdt.internal.compiler.CompilationResult;
import paper.libs.org.eclipse.jdt.internal.compiler.Compiler;
import paper.libs.org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import paper.libs.org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import paper.libs.org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import paper.libs.org.eclipse.jdt.internal.compiler.IProblemFactory;
import paper.libs.org.eclipse.jdt.internal.compiler.SourceElementParser;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import paper.libs.org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import paper.libs.org.eclipse.jdt.internal.compiler.env.IModule;
import paper.libs.org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import paper.libs.org.eclipse.jdt.internal.compiler.env.ISourceType;
import paper.libs.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import paper.libs.org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import paper.libs.org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import paper.libs.org.eclipse.jdt.internal.core.CancelableNameEnvironment;
import paper.libs.org.eclipse.jdt.internal.core.CancelableProblemFactory;
import paper.libs.org.eclipse.jdt.internal.core.CompilationUnit;
import paper.libs.org.eclipse.jdt.internal.core.JavaProject;
import paper.libs.org.eclipse.jdt.internal.core.ModuleDescriptionInfo;
import paper.libs.org.eclipse.jdt.internal.core.NameLookup;
import paper.libs.org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import paper.libs.org.eclipse.jdt.internal.core.util.CommentRecorderParser;
import paper.libs.org.eclipse.jdt.internal.core.util.Util;

public class CompilationUnitProblemFinder
extends Compiler {
    protected CompilationUnitProblemFinder(INameEnvironment environment, IErrorHandlingPolicy policy, CompilerOptions compilerOptions, ICompilerRequestor requestor, IProblemFactory problemFactory) {
        super(environment, policy, compilerOptions, requestor, problemFactory);
    }

    @Override
    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        while (sourceTypes[0].getEnclosingType() != null) {
            sourceTypes[0] = sourceTypes[0].getEnclosingType();
        }
        CompilationResult result = new CompilationResult(sourceTypes[0].getFileName(), 1, 1, this.options.maxProblemsPerUnit);
        long savedComplianceLevel = this.options.complianceLevel;
        long savedSourceLevel = this.options.sourceLevel;
        LookupEnvironment environment = packageBinding.environment;
        if (environment == null) {
            environment = this.lookupEnvironment;
        }
        try {
            IJavaProject project = ((SourceTypeElementInfo)sourceTypes[0]).getHandle().getJavaProject();
            this.options.complianceLevel = CompilerOptions.versionToJdkLevel(project.getOption("paper.libs.org.eclipse.jdt.core.compiler.compliance", true));
            this.options.sourceLevel = CompilerOptions.versionToJdkLevel(project.getOption("paper.libs.org.eclipse.jdt.core.compiler.source", true));
            CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(sourceTypes, 31, environment.problemReporter, result);
            if (unit != null) {
                environment.buildTypeBindings(unit, accessRestriction);
                CompilationUnitDeclaration previousUnitBeingCompleted = this.lookupEnvironment.unitBeingCompleted;
                environment.completeTypeBindings(unit);
                this.lookupEnvironment.unitBeingCompleted = previousUnitBeingCompleted;
            }
        }
        finally {
            this.options.complianceLevel = savedComplianceLevel;
            this.options.sourceLevel = savedSourceLevel;
        }
    }

    @Override
    public void accept(IModule module, LookupEnvironment environment) {
        IModuleDescription handle = null;
        if (module instanceof ModuleDescriptionInfo) {
            handle = ((ModuleDescriptionInfo)module).getHandle();
        }
        if (handle == null) {
            super.accept(module, environment);
            return;
        }
        CompilationResult result = new CompilationResult(TypeConstants.MODULE_INFO_FILE_NAME, 1, 1, this.options.maxProblemsPerUnit);
        long savedComplianceLevel = this.options.complianceLevel;
        long savedSourceLevel = this.options.sourceLevel;
        if (environment == null) {
            environment = this.lookupEnvironment;
        }
        try {
            IJavaProject project = handle.getJavaProject();
            this.options.complianceLevel = CompilerOptions.versionToJdkLevel(project.getOption("paper.libs.org.eclipse.jdt.core.compiler.compliance", true));
            this.options.sourceLevel = CompilerOptions.versionToJdkLevel(project.getOption("paper.libs.org.eclipse.jdt.core.compiler.source", true));
            CompilationUnitDeclaration unit = SourceTypeConverter.buildModularCompilationUnit(module, environment.problemReporter, result);
            if (unit != null) {
                environment.buildTypeBindings(unit, null);
                environment.completeTypeBindings(unit);
            }
        }
        finally {
            this.options.complianceLevel = savedComplianceLevel;
            this.options.sourceLevel = savedSourceLevel;
        }
    }

    protected static CompilerOptions getCompilerOptions(Map settings, boolean creatingAST, boolean statementsRecovery) {
        CompilerOptions compilerOptions = new CompilerOptions(settings);
        compilerOptions.performMethodsFullRecovery = statementsRecovery;
        compilerOptions.performStatementsRecovery = statementsRecovery;
        boolean bl = compilerOptions.parseLiteralExpressionsAsConstants = !creatingAST;
        if (creatingAST) {
            compilerOptions.storeAnnotations = true;
        }
        return compilerOptions;
    }

    protected static IErrorHandlingPolicy getHandlingPolicy() {
        return DefaultErrorHandlingPolicies.proceedWithAllProblems();
    }

    protected static ICompilerRequestor getRequestor() {
        return new ICompilerRequestor(){

            @Override
            public void acceptResult(CompilationResult compilationResult) {
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isTestSource(IJavaProject project, ICompilationUnit cu) {
        try {
            IClasspathEntry[] resolvedClasspath = project.getResolvedClasspath(true);
            IPath resourcePath = cu.getResource().getFullPath();
            IClasspathEntry[] iClasspathEntryArray = resolvedClasspath;
            int n = resolvedClasspath.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry e = iClasspathEntryArray[n2];
                if (e.getEntryKind() == 3 && e.isTest() && e.getPath().isPrefixOf(resourcePath)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            Util.log(e, "Exception while determining if compilation unit \"" + cu.getElementName() + "\" is test source");
        }
        return false;
    }

    public static CompilationUnitDeclaration process(CompilationUnit unitElement, SourceElementParser parser, WorkingCopyOwner workingCopyOwner, HashMap problems, boolean creatingAST, int reconcileFlags, IProgressMonitor monitor) throws JavaModelException {
        JavaProject project = unitElement.getJavaProject();
        CancelableNameEnvironment environment = null;
        CancelableProblemFactory problemFactory = null;
        CompilationUnitProblemFinder problemFinder = null;
        CompilationUnitDeclaration unit = null;
        try {
            try {
                boolean ignoreMethodBodies;
                environment = new CancelableNameEnvironment(project, workingCopyOwner, monitor, !CompilationUnitProblemFinder.isTestSource(unitElement.getJavaProject(), unitElement));
                problemFactory = new CancelableProblemFactory(monitor);
                CompilerOptions compilerOptions = CompilationUnitProblemFinder.getCompilerOptions(project.getOptions(true), creatingAST, (reconcileFlags & 2) != 0);
                compilerOptions.ignoreMethodBodies = ignoreMethodBodies = (reconcileFlags & 8) != 0;
                problemFinder = new CompilationUnitProblemFinder((INameEnvironment)environment, CompilationUnitProblemFinder.getHandlingPolicy(), compilerOptions, CompilationUnitProblemFinder.getRequestor(), (IProblemFactory)problemFactory);
                boolean analyzeAndGenerateCode = true;
                if (ignoreMethodBodies) {
                    analyzeAndGenerateCode = false;
                }
                try {
                    if (parser != null) {
                        problemFinder.parser = parser;
                        unit = parser.parseCompilationUnit(unitElement, true, monitor);
                        problemFinder.resolve(unit, unitElement, true, analyzeAndGenerateCode, analyzeAndGenerateCode);
                    } else {
                        unit = problemFinder.resolve(unitElement, true, analyzeAndGenerateCode, analyzeAndGenerateCode);
                    }
                }
                catch (AbortCompilation e) {
                    problemFinder.handleInternalException(e, unit);
                }
                if (unit != null) {
                    CategorizedProblem[] categorizedProblems;
                    int length;
                    CompilationResult unitResult = unit.compilationResult;
                    CategorizedProblem[] unitProblems = unitResult.getCUProblems();
                    int n = length = unitProblems == null ? 0 : unitProblems.length;
                    if (length > 0) {
                        categorizedProblems = new CategorizedProblem[length];
                        System.arraycopy(unitProblems, 0, categorizedProblems, 0, length);
                        problems.put("paper.libs.org.eclipse.jdt.core.problem", categorizedProblems);
                    }
                    int n2 = length = (unitProblems = unitResult.getTasks()) == null ? 0 : unitProblems.length;
                    if (length > 0) {
                        categorizedProblems = new CategorizedProblem[length];
                        System.arraycopy(unitProblems, 0, categorizedProblems, 0, length);
                        problems.put("paper.libs.org.eclipse.jdt.core.task", categorizedProblems);
                    }
                    if (NameLookup.VERBOSE) {
                        System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInSourcePackage: " + environment.nameLookup.timeSpentInSeekTypesInSourcePackage + "ms");
                        System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInBinaryPackage: " + environment.nameLookup.timeSpentInSeekTypesInBinaryPackage + "ms");
                    }
                }
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (RuntimeException e) {
                String lineDelimiter = unitElement.findRecommendedLineSeparator();
                StringBuilder message = new StringBuilder("Exception occurred during problem detection:");
                message.append(lineDelimiter);
                message.append("----------------------------------- SOURCE BEGIN -------------------------------------");
                message.append(lineDelimiter);
                message.append(unitElement.getSource());
                message.append(lineDelimiter);
                message.append("----------------------------------- SOURCE END -------------------------------------");
                Util.log(e, message.toString());
                throw new JavaModelException(e, 1005);
            }
        }
        finally {
            if (environment != null) {
                environment.setMonitor(null);
            }
            if (problemFactory != null) {
                problemFactory.monitor = null;
            }
            if (problemFinder != null && !creatingAST) {
                problemFinder.lookupEnvironment.reset();
            }
        }
        return unit;
    }

    public static CompilationUnitDeclaration process(CompilationUnit unitElement, WorkingCopyOwner workingCopyOwner, HashMap problems, boolean creatingAST, int reconcileFlags, IProgressMonitor monitor) throws JavaModelException {
        return CompilationUnitProblemFinder.process(unitElement, null, workingCopyOwner, problems, creatingAST, reconcileFlags, monitor);
    }

    @Override
    public void initializeParser() {
        this.parser = new CommentRecorderParser(this.problemReporter, this.options.parseLiteralExpressionsAsConstants);
    }
}

