/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.compiler.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import paper.libs.org.eclipse.jdt.internal.compiler.util.CharArrayMapper;

public final class CharArrayMap<P>
implements CharArrayMapper<P> {
    private char[][] keyTable;
    private P[] valueTable;
    private int size;

    public CharArrayMap() {
        this(0);
    }

    public CharArrayMap(int estimatedSize) {
        int capacity = estimatedSize > 0 ? estimatedSize : 0;
        this.size = 0;
        this.keyTable = new char[capacity][];
        Object[] x = new Object[capacity];
        this.valueTable = x;
    }

    @Override
    public Collection<P> values() {
        return Arrays.stream(this.valueTable).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Collection<char[]> keys() {
        return Arrays.stream(this.keyTable).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public boolean containsKey(char[] key) {
        int i2 = 0;
        while (i2 < this.size) {
            if (Arrays.equals(this.keyTable[i2], key)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    @Override
    public P get(char[] key) {
        int i2 = 0;
        while (i2 < this.size) {
            if (Arrays.equals(this.keyTable[i2], key)) {
                return this.valueTable[i2];
            }
            ++i2;
        }
        return null;
    }

    @Override
    public P put(char[] key, P value) {
        int i2 = 0;
        while (i2 < this.size) {
            if (Arrays.equals(this.keyTable[i2], key)) {
                P previous = this.valueTable[i2];
                this.valueTable[i2] = value;
                return previous;
            }
            ++i2;
        }
        if (i2 >= this.keyTable.length) {
            this.grow();
        }
        this.keyTable[i2] = key;
        this.valueTable[i2] = value;
        ++this.size;
        return null;
    }

    void transferTo(CharArrayMapper<P> bigMap) {
        int i2 = 0;
        while (i2 < this.size) {
            if (this.keyTable[i2] != null) {
                bigMap.put(this.keyTable[i2], this.valueTable[i2]);
            }
            ++i2;
        }
    }

    private void grow() {
        int capacity = this.keyTable.length > 1 ? this.keyTable.length : 1;
        int newCapacity = capacity * 2;
        this.keyTable = (char[][])Arrays.copyOfRange(this.keyTable, 0, newCapacity);
        this.valueTable = Arrays.copyOfRange(this.valueTable, 0, newCapacity);
    }

    @Override
    public int size() {
        return this.size;
    }

    public String toString() {
        return CharArrayMapper.toString(this);
    }
}

