/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import paper.libs.org.eclipse.jdt.internal.compiler.ASTVisitor;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.Expression;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.NameReference;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.Statement;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import paper.libs.org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import paper.libs.org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import paper.libs.org.eclipse.jdt.internal.compiler.flow.FlowContext;
import paper.libs.org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import paper.libs.org.eclipse.jdt.internal.compiler.impl.Constant;
import paper.libs.org.eclipse.jdt.internal.compiler.impl.IntConstant;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class CaseStatement
extends Statement {
    public BranchLabel targetLabel;
    public Expression[] constantExpressions;
    public BranchLabel[] targetLabels;
    public boolean isExpr;

    public CaseStatement(Expression constantExpression, int sourceEnd, int sourceStart) {
        Expression[] expressionArray;
        if (constantExpression != null) {
            Expression[] expressionArray2 = new Expression[1];
            expressionArray = expressionArray2;
            expressionArray2[0] = constantExpression;
        } else {
            expressionArray = null;
        }
        this(sourceEnd, sourceStart, expressionArray);
    }

    public CaseStatement(int sourceEnd, int sourceStart, Expression[] constantExpressions) {
        this.isExpr = false;
        this.constantExpressions = constantExpressions;
        this.sourceEnd = sourceEnd;
        this.sourceStart = sourceStart;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.constantExpressions != null) {
            Expression[] expressionArray = this.constantExpressions;
            int n = this.constantExpressions.length;
            int n2 = 0;
            while (n2 < n) {
                Expression e = expressionArray[n2];
                this.analyseConstantExpression(currentScope, flowContext, flowInfo, e);
                ++n2;
            }
        }
        return flowInfo;
    }

    private void analyseConstantExpression(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, Expression e) {
        if (e.constant == Constant.NotAConstant && !e.resolvedType.isEnum()) {
            currentScope.problemReporter().caseExpressionMustBeConstant(e);
        }
        e.analyseCode(currentScope, flowContext, flowInfo);
    }

    @Override
    public StringBuffer printStatement(int tab, StringBuffer output) {
        CaseStatement.printIndent(tab, output);
        if (this.constantExpressions == null) {
            output.append("default ");
            output.append(this.isExpr ? "->" : ":");
        } else {
            output.append("case ");
            int i2 = 0;
            int l = this.constantExpressions.length;
            while (i2 < l) {
                this.constantExpressions[i2].printExpression(0, output);
                if (i2 < l - 1) {
                    output.append(',');
                }
                ++i2;
            }
            output.append(this.isExpr ? " ->" : " :");
        }
        return output;
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        if (this.targetLabels != null) {
            int i2 = 0;
            int l = this.targetLabels.length;
            while (i2 < l) {
                this.targetLabels[i2].place();
                ++i2;
            }
        } else {
            this.targetLabel.place();
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    @Override
    public void resolve(BlockScope scope) {
    }

    @Override
    public Constant[] resolveCase(BlockScope scope, TypeBinding switchExpressionType, SwitchStatement switchStatement) {
        TypeBinding caseType;
        Expression constExpr;
        scope.enclosingCase = this;
        Expression[] constExprs = this.constantExpressions;
        Expression expression = constExpr = constExprs != null && constExprs.length > 0 ? constExprs[0] : null;
        if (constExpr == null) {
            if (switchStatement.defaultCase != null) {
                scope.problemReporter().duplicateDefaultCase(this);
            }
            switchStatement.defaultCase = this;
            return Constant.NotAConstantList;
        }
        switchStatement.cases[switchStatement.caseCount++] = this;
        if (switchExpressionType != null && switchExpressionType.isEnum() && constExpr instanceof SingleNameReference) {
            ((SingleNameReference)constExpr).setActualReceiverType((ReferenceBinding)switchExpressionType);
        }
        if ((caseType = constExpr.resolveType(scope)) == null || switchExpressionType == null) {
            return Constant.NotAConstantList;
        }
        ArrayList<Constant> cases = new ArrayList<Constant>();
        Expression[] expressionArray = constExprs;
        int n = constExprs.length;
        int n2 = 0;
        while (n2 < n) {
            Constant con;
            Expression e = expressionArray[n2];
            if (e != constExpr) {
                if (switchExpressionType.isEnum() && e instanceof SingleNameReference) {
                    ((SingleNameReference)e).setActualReceiverType((ReferenceBinding)switchExpressionType);
                }
                e.resolveType(scope);
            }
            if ((con = this.resolveConstantExpression(scope, caseType, switchExpressionType, switchStatement, e)) != Constant.NotAConstant) {
                cases.add(con);
            }
            ++n2;
        }
        if (cases.size() > 0) {
            return cases.toArray(new Constant[cases.size()]);
        }
        return Constant.NotAConstantList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Constant resolveConstantExpression(BlockScope scope, TypeBinding caseType, TypeBinding switchExpressionType, SwitchStatement switchStatement, Expression expression) {
        if (expression.isConstantValueOfTypeAssignableToType(caseType, switchExpressionType) || caseType.isCompatibleWith(switchExpressionType)) {
            if (!caseType.isEnum()) return expression.constant;
            if ((expression.bits & 0x1FE00000) >> 21 != 0) {
                scope.problemReporter().enumConstantsCannotBeSurroundedByParenthesis(expression);
            }
            if (expression instanceof NameReference && (expression.bits & 7) == 1) {
                NameReference reference = (NameReference)expression;
                FieldBinding field = reference.fieldBinding();
                if ((field.modifiers & 0x4000) == 0) {
                    scope.problemReporter().enumSwitchCannotTargetField(reference, field);
                    return IntConstant.fromValue(field.original().id + 1);
                } else {
                    if (!(reference instanceof QualifiedNameReference)) return IntConstant.fromValue(field.original().id + 1);
                    scope.problemReporter().cannotUseQualifiedEnumConstantInCaseLabel(reference, field);
                }
                return IntConstant.fromValue(field.original().id + 1);
            }
        } else if (this.isBoxingCompatible(caseType, switchExpressionType, expression, scope)) {
            return expression.constant;
        }
        scope.problemReporter().typeMismatchError(caseType, switchExpressionType, expression, (ASTNode)switchStatement.expression);
        return Constant.NotAConstant;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope) && this.constantExpressions != null) {
            Expression[] expressionArray = this.constantExpressions;
            int n = this.constantExpressions.length;
            int n2 = 0;
            while (n2 < n) {
                Expression e = expressionArray[n2];
                e.traverse(visitor, blockScope);
                ++n2;
            }
        }
        visitor.endVisit(this, blockScope);
    }
}

