/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.core.util;

import java.util.Comparator;
import paper.libs.org.eclipse.core.runtime.IProgressMonitor;
import paper.libs.org.eclipse.jdt.core.ICompilationUnit;
import paper.libs.org.eclipse.jdt.core.IJavaElement;
import paper.libs.org.eclipse.jdt.core.JavaModelException;
import paper.libs.org.eclipse.jdt.core.dom.CompilationUnit;
import paper.libs.org.eclipse.jdt.internal.core.SortElementsOperation;
import paper.libs.org.eclipse.jdt.internal.core.dom.util.DOMASTUtil;
import paper.libs.org.eclipse.text.edits.TextEdit;
import paper.libs.org.eclipse.text.edits.TextEditGroup;

public final class CompilationUnitSorter {
    public static final String RELATIVE_ORDER = "relativeOrder";

    private CompilationUnitSorter() {
    }

    private static void checkASTLevel(int level) {
        DOMASTUtil.checkASTLevel(level);
    }

    public static void sort(ICompilationUnit compilationUnit, int[] positions, Comparator comparator2, int options, IProgressMonitor monitor) throws JavaModelException {
        CompilationUnitSorter.sort(2, compilationUnit, positions, comparator2, options, monitor);
    }

    public static void sort(int level, ICompilationUnit compilationUnit, int[] positions, Comparator comparator2, int options, IProgressMonitor monitor) throws JavaModelException {
        if (compilationUnit == null || comparator2 == null) {
            throw new IllegalArgumentException();
        }
        CompilationUnitSorter.checkASTLevel(level);
        IJavaElement[] compilationUnits = new ICompilationUnit[]{compilationUnit};
        SortElementsOperation operation = new SortElementsOperation(level, compilationUnits, positions, comparator2);
        operation.runOperation(monitor);
    }

    public static TextEdit sort(CompilationUnit unit, Comparator comparator2, int options, TextEditGroup group, IProgressMonitor monitor) throws JavaModelException {
        if (unit == null || comparator2 == null) {
            throw new IllegalArgumentException();
        }
        SortElementsOperation operation = new SortElementsOperation(unit.getAST().apiLevel(), new IJavaElement[]{unit.getJavaElement()}, null, comparator2);
        return operation.calculateEdit(unit, group);
    }
}

