/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.resources.mapping;

import java.util.ArrayList;
import paper.libs.org.eclipse.core.internal.resources.mapping.ChangeDescription;
import paper.libs.org.eclipse.core.internal.resources.mapping.ResourceChangeDescriptionFactory;
import paper.libs.org.eclipse.core.internal.utils.Messages;
import paper.libs.org.eclipse.core.internal.utils.Policy;
import paper.libs.org.eclipse.core.resources.IResource;
import paper.libs.org.eclipse.core.resources.IResourceDelta;
import paper.libs.org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import paper.libs.org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import paper.libs.org.eclipse.core.resources.mapping.ModelProvider;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.IProgressMonitor;
import paper.libs.org.eclipse.core.runtime.IStatus;
import paper.libs.org.eclipse.core.runtime.MultiStatus;
import paper.libs.org.eclipse.core.runtime.Status;
import paper.libs.org.eclipse.osgi.util.NLS;

public final class ResourceChangeValidator {
    private static ResourceChangeValidator instance;

    public static ResourceChangeValidator getValidator() {
        if (instance == null) {
            instance = new ResourceChangeValidator();
        }
        return instance;
    }

    private ResourceChangeValidator() {
    }

    private IStatus combineResults(IStatus[] result) {
        ArrayList<IStatus> notOK = new ArrayList<IStatus>();
        IStatus[] iStatusArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status = iStatusArray[n2];
            if (!status.isOK()) {
                notOK.add(status);
            }
            ++n2;
        }
        if (notOK.isEmpty()) {
            return Status.OK_STATUS;
        }
        if (notOK.size() == 1) {
            return (IStatus)notOK.get(0);
        }
        return new MultiStatus("paper.libs.org.eclipse.core.resources", 0, notOK.toArray(new IStatus[notOK.size()]), Messages.mapping_multiProblems, null);
    }

    public IResourceChangeDescriptionFactory createDeltaFactory() {
        return new ResourceChangeDescriptionFactory();
    }

    private ModelProvider[] getProviders(IResource[] resources) {
        IModelProviderDescriptor[] descriptors = ModelProvider.getModelProviderDescriptors();
        ArrayList<ModelProvider> result = new ArrayList<ModelProvider>();
        IModelProviderDescriptor[] iModelProviderDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IModelProviderDescriptor descriptor = iModelProviderDescriptorArray[n2];
            try {
                IResource[] matchingResources = descriptor.getMatchingResources(resources);
                if (matchingResources.length > 0) {
                    result.add(descriptor.getModelProvider());
                }
            }
            catch (CoreException e) {
                Policy.log(e.getStatus().getSeverity(), NLS.bind("Could not instantiate provider {0}", descriptor.getId()), e);
            }
            ++n2;
        }
        return result.toArray(new ModelProvider[result.size()]);
    }

    private IResource[] getRootResources(IResourceDelta root) {
        ChangeDescription changeDescription = new ChangeDescription();
        try {
            root.accept(delta -> changeDescription.recordChange(delta));
        }
        catch (CoreException e) {
            Policy.log(4, "Internal error", e);
        }
        return changeDescription.getRootResources();
    }

    public IStatus validateChange(IResourceDelta delta, IProgressMonitor monitor) {
        monitor = Policy.monitorFor(monitor);
        try {
            IResource[] resources = this.getRootResources(delta);
            ModelProvider[] providers = this.getProviders(resources);
            if (providers.length == 0) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            monitor.beginTask(Messages.mapping_validate, providers.length);
            IStatus[] result = new IStatus[providers.length];
            int i2 = 0;
            while (i2 < providers.length) {
                result[i2] = providers[i2].validateChange(delta, Policy.subMonitorFor(monitor, 1));
                ++i2;
            }
            IStatus iStatus = this.combineResults(result);
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }
}

