/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.runtime;

import java.util.HashSet;
import java.util.Set;
import paper.libs.org.eclipse.core.internal.runtime.PlatformLogWriter;
import paper.libs.org.eclipse.core.runtime.ILog;
import paper.libs.org.eclipse.core.runtime.ILogListener;
import paper.libs.org.eclipse.core.runtime.ISafeRunnable;
import paper.libs.org.eclipse.core.runtime.IStatus;
import paper.libs.org.eclipse.core.runtime.SafeRunner;
import paper.libs.org.eclipse.equinox.log.LogFilter;
import paper.libs.org.eclipse.equinox.log.Logger;
import paper.libs.org.eclipse.equinox.log.SynchronousLogListener;
import paper.libs.org.osgi.framework.Bundle;
import paper.libs.org.osgi.service.log.LogEntry;

public class Log
implements ILog,
SynchronousLogListener,
LogFilter {
    final Bundle bundle;
    private final Logger logger;
    private final Set<ILogListener> logListeners = new HashSet<ILogListener>(5);

    public Log(Bundle plugin, Logger logger) {
        if (plugin == null) {
            throw new IllegalArgumentException("Logging bundle must not be null.");
        }
        this.bundle = plugin;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLogListener(ILogListener listener) {
        Set<ILogListener> set = this.logListeners;
        synchronized (set) {
            this.logListeners.add(listener);
        }
    }

    @Override
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public void log(IStatus status) {
        this.logger.log(PlatformLogWriter.getLog(status), PlatformLogWriter.getLevel(status), status.getMessage(), status.getException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLogListener(ILogListener listener) {
        Set<ILogListener> set = this.logListeners;
        synchronized (set) {
            this.logListeners.remove(listener);
        }
    }

    @Override
    public void logged(LogEntry entry) {
        this.logToListeners(PlatformLogWriter.convertToStatus(entry));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logToListeners(final IStatus status) {
        ILogListener[] listeners;
        Set<ILogListener> set = this.logListeners;
        synchronized (set) {
            listeners = this.logListeners.toArray(new ILogListener[this.logListeners.size()]);
        }
        ILogListener[] iLogListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            final ILogListener listener = iLogListenerArray[n2];
            ISafeRunnable code = new ISafeRunnable(){

                @Override
                public void run() throws Exception {
                    listener.logging(status, Log.this.bundle.getSymbolicName());
                }

                @Override
                public void handleException(Throwable e) {
                }
            };
            SafeRunner.run(code);
            ++n2;
        }
    }

    @Override
    public boolean isLoggable(Bundle loggingBundle, String loggerName, int logLevel) {
        return "paper.libs.org.eclipse.equinox.logger".equals(loggerName) && this.bundle.getBundleId() == loggingBundle.getBundleId();
    }
}

