/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.resources;

import java.util.Map;
import paper.libs.org.eclipse.core.resources.IResourceChangeListener;
import paper.libs.org.eclipse.core.resources.IWorkspace;
import paper.libs.org.osgi.service.log.Logger;
import paper.libs.org.osgi.service.log.LoggerFactory;

public final class ResourceChangeListenerRegistrar {
    private final IWorkspace workspace;
    private Logger logger;

    public ResourceChangeListenerRegistrar(IWorkspace workspace) {
        this.workspace = workspace;
    }

    public void addResourceChangeListener(IResourceChangeListener listener, Map<String, Object> properties) {
        Object mask = properties.get("event.mask");
        if (mask instanceof Integer) {
            this.workspace.addResourceChangeListener(listener, (Integer)mask);
        } else {
            Logger local = this.logger;
            if (mask != null && local != null) {
                local.warn("event.mask of IResourceChangeListener service: expected Integer but was {} (from {}): {}", mask.getClass(), listener.getClass(), mask);
            }
            this.workspace.addResourceChangeListener(listener);
        }
    }

    public void removeResourceChangeListener(IResourceChangeListener listener) {
        this.workspace.removeResourceChangeListener(listener);
    }

    public void setLoggerFactory(LoggerFactory factory) {
        this.logger = factory.getLogger(ResourceChangeListenerRegistrar.class);
    }

    public void unsetLogger() {
        this.logger = null;
    }
}

