/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.resources;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import paper.libs.org.eclipse.core.filesystem.URIUtil;
import paper.libs.org.eclipse.core.internal.events.PathVariableChangeEvent;
import paper.libs.org.eclipse.core.internal.resources.IManager;
import paper.libs.org.eclipse.core.internal.resources.PathVariableUtil;
import paper.libs.org.eclipse.core.internal.resources.ProjectVariableProviderManager;
import paper.libs.org.eclipse.core.internal.resources.ResourceStatus;
import paper.libs.org.eclipse.core.internal.utils.FileUtil;
import paper.libs.org.eclipse.core.internal.utils.Messages;
import paper.libs.org.eclipse.core.resources.IPathVariableChangeListener;
import paper.libs.org.eclipse.core.resources.IPathVariableManager;
import paper.libs.org.eclipse.core.resources.IProject;
import paper.libs.org.eclipse.core.resources.IResource;
import paper.libs.org.eclipse.core.resources.ResourcesPlugin;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.IPath;
import paper.libs.org.eclipse.core.runtime.IProgressMonitor;
import paper.libs.org.eclipse.core.runtime.ISafeRunnable;
import paper.libs.org.eclipse.core.runtime.IStatus;
import paper.libs.org.eclipse.core.runtime.Path;
import paper.libs.org.eclipse.core.runtime.Preferences;
import paper.libs.org.eclipse.core.runtime.SafeRunner;
import paper.libs.org.eclipse.core.runtime.Status;
import paper.libs.org.eclipse.osgi.util.NLS;

public class PathVariableManager
implements IPathVariableManager,
IManager {
    static final String VARIABLE_PREFIX = "pathvariable.";
    private Set<IPathVariableChangeListener> listeners = Collections.synchronizedSet(new HashSet());
    private Map<IProject, Collection<IPathVariableChangeListener>> projectListeners = Collections.synchronizedMap(new HashMap());
    private Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();

    @Override
    public void addChangeListener(IPathVariableChangeListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void addChangeListener(IPathVariableChangeListener listener, IProject project) {
        Collection<IPathVariableChangeListener> list = this.projectListeners.get(project);
        if (list == null) {
            list = Collections.synchronizedSet(new HashSet());
            this.projectListeners.put(project, list);
        }
        list.add(listener);
    }

    private void checkIsValidName(String name2) throws CoreException {
        IStatus status = this.validateName(name2);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    private void checkIsValidValue(IPath newValue) throws CoreException {
        IStatus status = this.validateValue(newValue);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    private void fireVariableChangeEvent(String name2, IPath value, int type) {
        this.fireVariableChangeEvent(this.listeners, name2, value, type);
    }

    private void fireVariableChangeEvent(Collection<IPathVariableChangeListener> list, String name2, IPath value, int type) {
        if (list.isEmpty()) {
            return;
        }
        IPathVariableChangeListener[] listenerArray = list.toArray(new IPathVariableChangeListener[list.size()]);
        final PathVariableChangeEvent pve = new PathVariableChangeEvent(this, name2, value, type);
        IPathVariableChangeListener[] iPathVariableChangeListenerArray = listenerArray;
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            final IPathVariableChangeListener listener = iPathVariableChangeListenerArray[n2];
            ISafeRunnable job = new ISafeRunnable(){

                @Override
                public void handleException(Throwable exception) {
                }

                @Override
                public void run() throws Exception {
                    listener.pathVariableChanged(pve);
                }
            };
            SafeRunner.run(job);
            ++n2;
        }
    }

    public void fireVariableChangeEvent(IProject project, String name2, IPath value, int type) {
        Collection<IPathVariableChangeListener> list = this.projectListeners.get(project);
        if (list != null) {
            this.fireVariableChangeEvent(list, name2, value, type);
        }
    }

    private String getKeyForName(String varName) {
        return VARIABLE_PREFIX + varName;
    }

    @Override
    public String[] getPathVariableNames() {
        String[] names;
        LinkedList<String> result = new LinkedList<String>();
        String[] stringArray = names = this.preferences.propertyNames();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String key;
            String name2 = stringArray[n2];
            if (name2.startsWith(VARIABLE_PREFIX) && this.validateName(key = name2.substring(VARIABLE_PREFIX.length())).isOK() && this.validateValue(this.getValue(key)).isOK()) {
                result.add(key);
            }
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    @Deprecated
    public IPath getValue(String varName) {
        String key = this.getKeyForName(varName);
        String value = this.preferences.getString(key);
        return value.length() == 0 ? null : Path.fromPortableString(value);
    }

    @Override
    public boolean isDefined(String varName) {
        return this.getValue(varName) != null;
    }

    @Override
    public void removeChangeListener(IPathVariableChangeListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void removeChangeListener(IPathVariableChangeListener listener, IProject project) {
        Collection<IPathVariableChangeListener> list = this.projectListeners.get(project);
        if (list != null) {
            list.remove(listener);
            if (list.isEmpty()) {
                this.projectListeners.remove(project);
            }
        }
    }

    @Override
    @Deprecated
    public IPath resolvePath(IPath path) {
        if (path == null || path.segmentCount() == 0 || path.isAbsolute() || path.getDevice() != null) {
            return path;
        }
        IPath value = this.getValue(path.segment(0));
        return value == null ? path : value.append(path.removeFirstSegments(1));
    }

    @Override
    public URI resolveURI(URI uri) {
        if (uri == null || uri.isAbsolute()) {
            return uri;
        }
        String schemeSpecificPart = uri.getSchemeSpecificPart();
        if (schemeSpecificPart == null || schemeSpecificPart.isEmpty()) {
            return uri;
        }
        Path raw = new Path(schemeSpecificPart);
        IPath resolved = this.resolvePath(raw);
        return raw == resolved ? uri : URIUtil.toURI(resolved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(String varName, IPath newValue) throws CoreException {
        int eventType;
        this.checkIsValidName(varName);
        if (newValue != null && newValue.isAbsolute()) {
            newValue = FileUtil.canonicalPath(newValue);
        }
        this.checkIsValidValue(newValue);
        PathVariableManager pathVariableManager = this;
        synchronized (pathVariableManager) {
            boolean variableExists;
            IPath currentValue = this.getValue(varName);
            boolean bl = variableExists = currentValue != null;
            if (!variableExists && newValue == null) {
                return;
            }
            if (variableExists && currentValue.equals(newValue)) {
                return;
            }
            if (newValue == null) {
                this.preferences.setToDefault(this.getKeyForName(varName));
                eventType = 3;
            } else {
                this.preferences.setValue(this.getKeyForName(varName), newValue.toPortableString());
                eventType = variableExists ? 1 : 2;
            }
        }
        this.fireVariableChangeEvent(varName, newValue, eventType);
    }

    @Override
    public void shutdown(IProgressMonitor monitor) {
    }

    @Override
    public void startup(IProgressMonitor monitor) {
    }

    @Override
    public IStatus validateName(String name2) {
        String message = null;
        if (name2.length() == 0) {
            message = Messages.pathvar_length;
            return new ResourceStatus(77, null, message);
        }
        char first = name2.charAt(0);
        if (!Character.isLetter(first) && first != '_') {
            message = NLS.bind(Messages.pathvar_beginLetter, String.valueOf(first));
            return new ResourceStatus(77, null, message);
        }
        int i2 = 1;
        while (i2 < name2.length()) {
            char following = name2.charAt(i2);
            if (Character.isWhitespace(following)) {
                return new ResourceStatus(77, null, Messages.pathvar_whitespace);
            }
            if (!Character.isLetter(following) && !Character.isDigit(following) && following != '_') {
                message = NLS.bind(Messages.pathvar_invalidChar, String.valueOf(following));
                return new ResourceStatus(77, null, message);
            }
            ++i2;
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus validateValue(IPath value) {
        if (!(value == null || value.isValidPath(value.toString()) && value.isAbsolute())) {
            String message = Messages.pathvar_invalidValue;
            return new ResourceStatus(77, null, message);
        }
        return Status.OK_STATUS;
    }

    @Override
    public URI convertToRelative(URI path, boolean force, String variableHint) throws CoreException {
        return PathVariableUtil.convertToRelative((IPathVariableManager)this, path, null, false, variableHint);
    }

    @Override
    public URI getURIValue(String name2) {
        IPath path = this.getValue(name2);
        if (path != null) {
            return URIUtil.toURI(path);
        }
        return null;
    }

    @Override
    public void setURIValue(String name2, URI value) throws CoreException {
        this.setValue(name2, value != null ? URIUtil.toPath(value) : null);
    }

    @Override
    public IStatus validateValue(URI path) {
        return this.validateValue(path != null ? URIUtil.toPath(path) : null);
    }

    public URI resolveURI(URI uri, IResource resource) {
        return this.resolveURI(uri);
    }

    public String[] getPathVariableNames(IResource resource) {
        return this.getPathVariableNames();
    }

    @Override
    public URI getVariableRelativePathLocation(URI location) {
        try {
            URI result = this.convertToRelative(location, false, null);
            if (!result.equals(location)) {
                return result;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    @Override
    public String convertToUserEditableFormat(String value, boolean locationFormat) {
        return PathVariableUtil.convertToUserEditableFormatInternal(value, locationFormat);
    }

    @Override
    public String convertFromUserEditableFormat(String userFormat, boolean locationFormat) {
        return PathVariableUtil.convertFromUserEditableFormatInternal(this, userFormat, locationFormat);
    }

    @Override
    public boolean isUserDefined(String name2) {
        return ProjectVariableProviderManager.getDefault().findDescriptor(name2) == null;
    }
}

