/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.registry;

import paper.libs.org.eclipse.core.internal.registry.ConfigurationElement;
import paper.libs.org.eclipse.core.internal.registry.ExtensionHandle;
import paper.libs.org.eclipse.core.internal.registry.Handle;
import paper.libs.org.eclipse.core.internal.registry.IObjectManager;
import paper.libs.org.eclipse.core.internal.registry.RegistryObject;
import paper.libs.org.eclipse.core.internal.registry.RegistryObjectManager;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.IConfigurationElement;
import paper.libs.org.eclipse.core.runtime.IContributor;
import paper.libs.org.eclipse.core.runtime.IExtension;
import paper.libs.org.eclipse.core.runtime.InvalidRegistryObjectException;
import paper.libs.org.eclipse.core.runtime.Status;

public class ConfigurationElementHandle
extends Handle
implements IConfigurationElement {
    static final ConfigurationElementHandle[] EMPTY_ARRAY = new ConfigurationElementHandle[0];

    public ConfigurationElementHandle(IObjectManager objectManager, int id) {
        super(objectManager, id);
    }

    protected ConfigurationElement getConfigurationElement() {
        return (ConfigurationElement)this.objectManager.getObject(this.getId(), (byte)1);
    }

    protected boolean shouldPersist() {
        return this.getConfigurationElement().shouldPersist();
    }

    @Override
    public String getAttribute(String propertyName) {
        return this.getConfigurationElement().getAttribute(propertyName);
    }

    @Override
    public String getAttribute(String attrName, String locale) {
        return this.getConfigurationElement().getAttribute(attrName, locale);
    }

    @Override
    public String[] getAttributeNames() {
        return this.getConfigurationElement().getAttributeNames();
    }

    @Override
    public IConfigurationElement[] getChildren() {
        ConfigurationElement actualCe = this.getConfigurationElement();
        if (actualCe.noExtraData()) {
            return (IConfigurationElement[])this.objectManager.getHandles(actualCe.getRawChildren(), (byte)1);
        }
        return (IConfigurationElement[])this.objectManager.getHandles(actualCe.getRawChildren(), (byte)4);
    }

    @Override
    public Object createExecutableExtension(String propertyName) throws CoreException {
        try {
            return this.getConfigurationElement().createExecutableExtension(propertyName);
        }
        catch (InvalidRegistryObjectException e) {
            Status status = new Status(4, "paper.libs.org.eclipse.equinox.registry", 1, "Invalid registry object", (Throwable)e);
            if (this.objectManager instanceof RegistryObjectManager) {
                ((RegistryObjectManager)this.objectManager).getRegistry().log(status);
            }
            throw new CoreException(status);
        }
    }

    @Override
    public String getAttributeAsIs(String name2) {
        return this.getConfigurationElement().getAttributeAsIs(name2);
    }

    @Override
    public IConfigurationElement[] getChildren(String name2) {
        ConfigurationElement actualCE = this.getConfigurationElement();
        ConfigurationElement[] children = (ConfigurationElement[])this.objectManager.getObjects(actualCE.getRawChildren(), actualCE.noExtraData() ? (byte)1 : 4);
        if (children.length == 0) {
            return EMPTY_ARRAY;
        }
        IConfigurationElement[] result = new IConfigurationElement[1];
        int idx = 0;
        ConfigurationElement[] configurationElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurationElement child = configurationElementArray[n2];
            if (child.getName().equals(name2)) {
                if (idx != 0) {
                    IConfigurationElement[] copy = new IConfigurationElement[result.length + 1];
                    System.arraycopy(result, 0, copy, 0, result.length);
                    result = copy;
                }
                result[idx++] = (IConfigurationElement)((Object)this.objectManager.getHandle(child.getObjectId(), actualCE.noExtraData() ? (byte)1 : 4));
            }
            ++n2;
        }
        if (idx == 0) {
            return EMPTY_ARRAY;
        }
        return result;
    }

    @Override
    public IExtension getDeclaringExtension() {
        Object result = this;
        while (!((result = ((ConfigurationElementHandle)result).getParent()) instanceof ExtensionHandle)) {
        }
        return (IExtension)result;
    }

    @Override
    public String getName() {
        return this.getConfigurationElement().getName();
    }

    @Override
    public Object getParent() {
        ConfigurationElement actualCe = this.getConfigurationElement();
        return this.objectManager.getHandle(actualCe.parentId, actualCe.parentType);
    }

    @Override
    public String getValue() {
        return this.getConfigurationElement().getValue();
    }

    @Override
    public String getValue(String locale) {
        return this.getConfigurationElement().getValue(locale);
    }

    @Override
    public String getValueAsIs() {
        return this.getConfigurationElement().getValueAsIs();
    }

    @Override
    RegistryObject getObject() {
        return this.getConfigurationElement();
    }

    @Override
    public String getNamespace() {
        return this.getContributor().getName();
    }

    @Override
    public String getNamespaceIdentifier() {
        return this.getDeclaringExtension().getNamespaceIdentifier();
    }

    @Override
    public IContributor getContributor() {
        return this.getConfigurationElement().getContributor();
    }

    @Override
    public boolean isValid() {
        try {
            this.getConfigurationElement();
        }
        catch (InvalidRegistryObjectException invalidRegistryObjectException) {
            return false;
        }
        return true;
    }

    @Override
    public int getHandleId() {
        return this.getId();
    }

    public String toString() {
        String value;
        StringBuilder sb = new StringBuilder();
        sb.append("ConfigurationElementHandle [");
        sb.append("name: ");
        sb.append(this.getName());
        String id = this.getAttribute("id");
        if (id != null && id.length() > 0) {
            sb.append(", id: ").append(id);
        }
        if ((value = this.getValue()) != null) {
            sb.append(", value: ").append(value);
        }
        sb.append(", handle id: ").append(this.getHandleId());
        sb.append(", namespace: ");
        sb.append(this.getNamespaceIdentifier());
        sb.append("]");
        return sb.toString();
    }
}

