/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.refresh;

import java.util.Collection;
import paper.libs.org.eclipse.core.resources.IResource;
import paper.libs.org.eclipse.core.resources.ResourcesPlugin;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.ICoreRunnable;
import paper.libs.org.eclipse.core.runtime.IProgressMonitor;
import paper.libs.org.eclipse.core.runtime.IStatus;
import paper.libs.org.eclipse.core.runtime.Status;
import paper.libs.org.eclipse.core.runtime.jobs.ISchedulingRule;
import paper.libs.org.eclipse.core.runtime.jobs.Job;
import paper.libs.org.eclipse.core.runtime.jobs.MultiRule;

public class MonitorJob
extends Job {
    private final ICoreRunnable runnable;

    private MonitorJob(String name2, MonitorRule rule, ICoreRunnable runnable) {
        super(name2);
        this.runnable = runnable;
        this.setSystem(true);
        this.setRule(rule);
    }

    static Job createSystem(String name2, IResource resource, ICoreRunnable runnable) {
        return new MonitorJob(name2, MonitorRule.create(resource), runnable);
    }

    static Job createSystem(String name2, Collection<IResource> resources, ICoreRunnable runnable) {
        return new MonitorJob(name2, MonitorRule.create(resources), runnable);
    }

    @Override
    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.runnable.run(monitor);
        }
        catch (CoreException e) {
            IStatus st = e.getStatus();
            return new Status(st.getSeverity(), st.getPlugin(), st.getCode(), st.getMessage(), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    @Override
    public boolean belongsTo(Object family) {
        return ResourcesPlugin.FAMILY_AUTO_REFRESH == family;
    }

    private static class MonitorRule
    implements ISchedulingRule {
        private static final ISchedulingRule[] SCHEDULING_RULE__EMPTY_ARR = new ISchedulingRule[0];
        private final ISchedulingRule resourceRule;

        MonitorRule(ISchedulingRule schedulingRule) {
            this.resourceRule = schedulingRule;
        }

        static MonitorRule create(IResource resource) {
            return new MonitorRule(resource);
        }

        static MonitorRule create(Collection<IResource> resources) {
            return new MonitorRule(MultiRule.combine(resources.toArray(SCHEDULING_RULE__EMPTY_ARR)));
        }

        @Override
        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof MonitorRule) {
                return this.resourceRule.isConflicting(((MonitorRule)rule).resourceRule);
            }
            return false;
        }

        @Override
        public boolean contains(ISchedulingRule rule) {
            if (rule instanceof MonitorRule) {
                return this.resourceRule.contains(((MonitorRule)rule).resourceRule);
            }
            return false;
        }
    }
}

