/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.preferences;

import paper.libs.org.eclipse.core.internal.preferences.Activator;
import paper.libs.org.eclipse.core.internal.preferences.EclipsePreferences;
import paper.libs.org.eclipse.core.internal.preferences.PrefsMessages;
import paper.libs.org.eclipse.core.internal.preferences.exchange.ILegacyPreferences;
import paper.libs.org.eclipse.osgi.service.datalocation.Location;
import paper.libs.org.eclipse.osgi.service.debug.DebugOptions;
import paper.libs.org.osgi.framework.Bundle;
import paper.libs.org.osgi.framework.BundleContext;
import paper.libs.org.osgi.framework.Filter;
import paper.libs.org.osgi.framework.InvalidSyntaxException;
import paper.libs.org.osgi.service.packageadmin.PackageAdmin;
import paper.libs.org.osgi.util.tracker.ServiceTracker;

public class PreferencesOSGiUtils {
    private ServiceTracker<?, ILegacyPreferences> initTracker;
    private ServiceTracker<?, DebugOptions> debugTracker;
    private ServiceTracker<?, PackageAdmin> bundleTracker;
    private ServiceTracker<?, ?> configurationLocationTracker;
    private ServiceTracker<?, ?> instanceLocationTracker;
    private static final PreferencesOSGiUtils singleton = new PreferencesOSGiUtils();

    public static PreferencesOSGiUtils getDefault() {
        return singleton;
    }

    private PreferencesOSGiUtils() {
    }

    void openServices() {
        BundleContext context = Activator.getContext();
        if (context == null) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("PreferencesOSGiUtils called before plugin started");
            }
            return;
        }
        this.initTracker = new ServiceTracker(context, ILegacyPreferences.class, null);
        this.initTracker.open(true);
        this.debugTracker = new ServiceTracker(context, DebugOptions.class, null);
        this.debugTracker.open();
        this.bundleTracker = new ServiceTracker(context, PackageAdmin.class, null);
        this.bundleTracker.open();
        Filter filter = null;
        try {
            filter = context.createFilter(Location.CONFIGURATION_FILTER);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.configurationLocationTracker = new ServiceTracker(context, filter, null);
        this.configurationLocationTracker.open();
        try {
            filter = context.createFilter(Location.INSTANCE_FILTER);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.instanceLocationTracker = new ServiceTracker(context, filter, null);
        this.instanceLocationTracker.open();
    }

    void closeServices() {
        if (this.initTracker != null) {
            this.initTracker.close();
            this.initTracker = null;
        }
        if (this.debugTracker != null) {
            this.debugTracker.close();
            this.debugTracker = null;
        }
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
            this.bundleTracker = null;
        }
        if (this.configurationLocationTracker != null) {
            this.configurationLocationTracker.close();
            this.configurationLocationTracker = null;
        }
        if (this.instanceLocationTracker != null) {
            this.instanceLocationTracker.close();
            this.instanceLocationTracker = null;
        }
    }

    public ILegacyPreferences getLegacyPreferences() {
        if (this.initTracker != null) {
            return this.initTracker.getService();
        }
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Legacy preference tracker is not set");
        }
        return null;
    }

    public boolean getBooleanDebugOption(String option, boolean defaultValue) {
        String value;
        if (this.debugTracker == null) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Debug tracker is not set");
            }
            return defaultValue;
        }
        DebugOptions options = this.debugTracker.getService();
        if (options != null && (value = options.getOption(option)) != null) {
            return value.equalsIgnoreCase("true");
        }
        return defaultValue;
    }

    public Bundle getBundle(String bundleName) {
        if (this.bundleTracker == null) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Bundle tracker is not set");
            }
            return null;
        }
        PackageAdmin packageAdmin = this.bundleTracker.getService();
        if (packageAdmin == null) {
            return null;
        }
        Bundle[] bundles = packageAdmin.getBundles(bundleName, null);
        if (bundles == null) {
            return null;
        }
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if ((bundle.getState() & 3) == 0) {
                return bundle;
            }
            ++n2;
        }
        return null;
    }

    public Location getConfigurationLocation() {
        if (this.configurationLocationTracker != null) {
            return (Location)this.configurationLocationTracker.getService();
        }
        return null;
    }

    public Location getInstanceLocation() {
        if (this.instanceLocationTracker != null) {
            return (Location)this.instanceLocationTracker.getService();
        }
        return null;
    }
}

