/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.jobs;

import java.util.Hashtable;
import paper.libs.org.eclipse.core.internal.jobs.JobActivator;
import paper.libs.org.eclipse.core.internal.jobs.JobManager;
import paper.libs.org.eclipse.core.internal.jobs.JobMessages;
import paper.libs.org.eclipse.osgi.service.debug.DebugOptionsListener;
import paper.libs.org.osgi.framework.Bundle;
import paper.libs.org.osgi.framework.BundleContext;
import paper.libs.org.osgi.framework.FrameworkUtil;
import paper.libs.org.osgi.framework.ServiceRegistration;

class JobOSGiUtils {
    private ServiceRegistration<DebugOptionsListener> debugRegistration = null;
    private static final JobOSGiUtils singleton = new JobOSGiUtils();

    public static JobOSGiUtils getDefault() {
        return singleton;
    }

    private JobOSGiUtils() {
    }

    void openServices() {
        BundleContext context = JobActivator.getContext();
        if (context == null) {
            if (JobManager.DEBUG) {
                JobMessages.message("JobsOSGiUtils called before plugin started");
            }
            return;
        }
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        properties.put("listener.symbolic.name", "paper.libs.org.eclipse.core.jobs");
        this.debugRegistration = context.registerService(DebugOptionsListener.class, JobManager.getInstance(), properties);
    }

    void closeServices() {
        if (this.debugRegistration != null) {
            this.debugRegistration.unregister();
            this.debugRegistration = null;
        }
    }

    public String getBundleId(Object object) {
        if (object == null) {
            return null;
        }
        Bundle source = FrameworkUtil.getBundle(object.getClass());
        if (source != null && source.getSymbolicName() != null) {
            return source.getSymbolicName();
        }
        return null;
    }

    boolean useDaemonThreads() {
        BundleContext context = JobActivator.getContext();
        if (context == null) {
            String value = System.getProperty("eclipse.jobs.daemon");
            if (value == null) {
                return true;
            }
            return "true".equalsIgnoreCase(value);
        }
        String value = context.getProperty("eclipse.jobs.daemon");
        if (value == null) {
            return false;
        }
        return "true".equalsIgnoreCase(value);
    }
}

