/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.filesystem;

import java.net.URI;
import java.util.HashMap;
import paper.libs.org.eclipse.core.filesystem.IFileStore;
import paper.libs.org.eclipse.core.filesystem.IFileSystem;
import paper.libs.org.eclipse.core.filesystem.provider.FileSystem;
import paper.libs.org.eclipse.core.internal.filesystem.Messages;
import paper.libs.org.eclipse.core.internal.filesystem.Policy;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.IConfigurationElement;
import paper.libs.org.eclipse.core.runtime.IExtension;
import paper.libs.org.eclipse.core.runtime.IExtensionDelta;
import paper.libs.org.eclipse.core.runtime.IExtensionPoint;
import paper.libs.org.eclipse.core.runtime.IRegistryChangeEvent;
import paper.libs.org.eclipse.core.runtime.IRegistryChangeListener;
import paper.libs.org.eclipse.core.runtime.RegistryFactory;
import paper.libs.org.eclipse.osgi.util.NLS;

public class InternalFileSystemCore
implements IRegistryChangeListener {
    private static final InternalFileSystemCore INSTANCE = new InternalFileSystemCore();
    private HashMap<String, Object> fileSystems;

    public static InternalFileSystemCore getInstance() {
        return INSTANCE;
    }

    private InternalFileSystemCore() {
        RegistryFactory.getRegistry().addRegistryChangeListener(this);
    }

    public IFileSystem getFileSystem(String scheme) throws CoreException {
        if (scheme == null) {
            throw new NullPointerException();
        }
        HashMap<String, Object> registry = this.getFileSystemRegistry();
        Object result = registry.get(scheme);
        if (result == null) {
            Policy.error(566, NLS.bind(Messages.noFileSystem, scheme));
        }
        if (result instanceof IFileSystem) {
            return (IFileSystem)result;
        }
        try {
            IConfigurationElement element = (IConfigurationElement)result;
            FileSystem fs = (FileSystem)element.createExecutableExtension("run");
            fs.initialize(scheme);
            registry.put(scheme, fs);
            return fs;
        }
        catch (CoreException e) {
            registry.remove(scheme);
            throw e;
        }
    }

    public IFileSystem getLocalFileSystem() {
        try {
            return this.getFileSystem("file");
        }
        catch (CoreException e) {
            throw new Error(e);
        }
    }

    public IFileStore getStore(URI uri) throws CoreException {
        String scheme = uri.getScheme();
        if (scheme == null) {
            Policy.error(566, String.valueOf(Messages.noScheme) + uri);
        }
        return this.getFileSystem(scheme).getStore(uri);
    }

    private synchronized HashMap<String, Object> getFileSystemRegistry() {
        if (this.fileSystems == null) {
            IExtension[] extensions;
            this.fileSystems = new HashMap();
            IExtensionPoint point = RegistryFactory.getRegistry().getExtensionPoint("paper.libs.org.eclipse.core.filesystem", "filesystems");
            IExtension[] iExtensionArray = extensions = point.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    String scheme;
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if ("filesystem".equals(element.getName()) && (scheme = element.getAttribute("scheme")) != null) {
                        this.fileSystems.put(scheme, element);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return this.fileSystems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] changes = event.getExtensionDeltas("paper.libs.org.eclipse.core.filesystem", "filesystems");
        if (changes.length == 0) {
            return;
        }
        InternalFileSystemCore internalFileSystemCore = this;
        synchronized (internalFileSystemCore) {
            this.fileSystems = null;
        }
    }

    public IFileSystem getNullFileSystem() {
        try {
            return this.getFileSystem("null");
        }
        catch (CoreException e) {
            throw new Error(e);
        }
    }
}

