/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.expressions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import paper.libs.org.eclipse.core.expressions.IPropertyTester;
import paper.libs.org.eclipse.core.internal.expressions.ExpressionMessages;
import paper.libs.org.eclipse.core.internal.expressions.ExpressionStatus;
import paper.libs.org.eclipse.core.internal.expressions.Expressions;
import paper.libs.org.eclipse.core.internal.expressions.Messages;
import paper.libs.org.eclipse.core.internal.expressions.Property;
import paper.libs.org.eclipse.core.internal.expressions.PropertyCache;
import paper.libs.org.eclipse.core.internal.expressions.PropertyTesterDescriptor;
import paper.libs.org.eclipse.core.internal.expressions.TypeExtension;
import paper.libs.org.eclipse.core.runtime.Assert;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.IConfigurationElement;
import paper.libs.org.eclipse.core.runtime.IExtensionDelta;
import paper.libs.org.eclipse.core.runtime.IExtensionRegistry;
import paper.libs.org.eclipse.core.runtime.IRegistryChangeEvent;
import paper.libs.org.eclipse.core.runtime.IRegistryChangeListener;
import paper.libs.org.eclipse.core.runtime.Platform;

public class TypeExtensionManager
implements IRegistryChangeListener {
    private static final String EXTENSION_NAMESPACE = "paper.libs.org.eclipse.core.expressions";
    private String fExtensionPoint;
    private static boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.expressions/debug/TypeExtensionManager"));
    private static final String TYPE = "type";
    private static final IPropertyTester[] EMPTY_PROPERTY_TESTER_ARRAY = new IPropertyTester[0];
    private static final IPropertyTester NULL_PROPERTY_TESTER = new IPropertyTester(){

        @Override
        public boolean handles(String namespace, String property) {
            return false;
        }

        @Override
        public boolean isInstantiated() {
            return true;
        }

        @Override
        public boolean isDeclaringPluginActive() {
            return true;
        }

        @Override
        public IPropertyTester instantiate() throws CoreException {
            return this;
        }

        @Override
        public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
            return false;
        }
    };
    private Map<Class<?>, TypeExtension> fTypeExtensionMap;
    private Map<String, List<IConfigurationElement>> fConfigurationElementMap;
    private PropertyCache fPropertyCache;

    public TypeExtensionManager(String extensionPoint) {
        Assert.isNotNull(extensionPoint);
        this.fExtensionPoint = extensionPoint;
        Platform.getExtensionRegistry().addRegistryChangeListener(this);
        this.initializeCaches();
    }

    public Property getProperty(Object receiver, String namespace, String method) throws CoreException {
        return this.getProperty(receiver, namespace, method, false);
    }

    public synchronized Property getProperty(Object receiver, String namespace, String method, boolean forcePluginActivation) throws CoreException {
        TypeExtension extension;
        IPropertyTester extender;
        Class<?> clazz;
        Property result;
        Property cached;
        long start = 0L;
        if (Expressions.TRACING) {
            start = System.currentTimeMillis();
        }
        if ((cached = this.fPropertyCache.get(result = new Property(clazz = receiver instanceof Class ? (Class<?>)receiver : receiver.getClass(), namespace, method))) != null) {
            if (cached.isValidCacheEntry(forcePluginActivation)) {
                if (Expressions.TRACING) {
                    System.out.println("[Type Extension] - method " + clazz.getName() + "#" + method + " found in cache: " + (System.currentTimeMillis() - start) + " ms.");
                }
                return cached;
            }
            this.fPropertyCache.remove(cached);
        }
        if ((extender = (extension = this.get(clazz)).findTypeExtender(this, namespace, method, receiver instanceof Class, forcePluginActivation)) == TypeExtension.CONTINUE || extender == null) {
            Throwable t = null;
            if (DEBUG) {
                t = new Throwable("forcePluginActivation: " + forcePluginActivation + ", receiver: " + receiver).fillInStackTrace();
            }
            throw new CoreException(new ExpressionStatus(201, Messages.format(ExpressionMessages.TypeExtender_unknownMethod, new String[]{String.valueOf(namespace) + '.' + method, clazz.toString()}), t));
        }
        result.setPropertyTester(extender);
        this.fPropertyCache.put(result);
        if (Expressions.TRACING) {
            System.out.println("[Type Extension] - method " + clazz.getName() + "#" + method + " not found in cache: " + (System.currentTimeMillis() - start) + " ms.");
        }
        return result;
    }

    TypeExtension get(Class<?> clazz) {
        TypeExtension result = this.fTypeExtensionMap.get(clazz);
        if (result == null) {
            result = new TypeExtension(clazz);
            this.fTypeExtensionMap.put(clazz, result);
        }
        return result;
    }

    IPropertyTester[] loadTesters(Class<?> type) {
        String typeName;
        List<IConfigurationElement> typeConfigs;
        if (this.fConfigurationElementMap == null) {
            IConfigurationElement[] ces;
            this.fConfigurationElementMap = new HashMap<String, List<IConfigurationElement>>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = ces = registry.getConfigurationElementsFor(EXTENSION_NAMESPACE, this.fExtensionPoint);
            int n = ces.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                String typeAttr = config.getAttribute(TYPE);
                List<IConfigurationElement> typeConfigs2 = this.fConfigurationElementMap.get(typeAttr);
                if (typeConfigs2 == null) {
                    typeConfigs2 = new ArrayList<IConfigurationElement>();
                    this.fConfigurationElementMap.put(typeAttr, typeConfigs2);
                }
                typeConfigs2.add(config);
                ++n2;
            }
        }
        if ((typeConfigs = this.fConfigurationElementMap.get(typeName = type.getName())) == null) {
            return EMPTY_PROPERTY_TESTER_ARRAY;
        }
        IPropertyTester[] result = new IPropertyTester[typeConfigs.size()];
        int i2 = 0;
        while (i2 < result.length) {
            IConfigurationElement config = typeConfigs.get(i2);
            try {
                result[i2] = new PropertyTesterDescriptor(config);
            }
            catch (CoreException e) {
                Platform.getLog(TypeExtensionManager.class).log(e.getStatus());
                result[i2] = NULL_PROPERTY_TESTER;
            }
            ++i2;
        }
        this.fConfigurationElementMap.remove(typeName);
        return result;
    }

    @Override
    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas(EXTENSION_NAMESPACE, this.fExtensionPoint);
        if (deltas.length > 0) {
            this.initializeCaches();
        }
    }

    private synchronized void initializeCaches() {
        this.fTypeExtensionMap = new HashMap();
        this.fConfigurationElementMap = null;
        this.fPropertyCache = new PropertyCache(1000);
    }
}

