/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.filesystem.provider;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import paper.libs.org.eclipse.core.filesystem.EFS;
import paper.libs.org.eclipse.core.filesystem.IFileInfo;
import paper.libs.org.eclipse.core.filesystem.IFileStore;
import paper.libs.org.eclipse.core.filesystem.IFileSystem;
import paper.libs.org.eclipse.core.filesystem.provider.FileInfo;
import paper.libs.org.eclipse.core.internal.filesystem.FileCache;
import paper.libs.org.eclipse.core.internal.filesystem.Messages;
import paper.libs.org.eclipse.core.internal.filesystem.Policy;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.IPath;
import paper.libs.org.eclipse.core.runtime.IProgressMonitor;
import paper.libs.org.eclipse.core.runtime.PlatformObject;
import paper.libs.org.eclipse.core.runtime.SubMonitor;
import paper.libs.org.eclipse.osgi.util.NLS;

public abstract class FileStore
extends PlatformObject
implements IFileStore {
    protected static final IFileInfo[] EMPTY_FILE_INFO_ARRAY = new IFileInfo[0];
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];

    private static final void transferStreams(InputStream source, OutputStream destination, long length, String path, IProgressMonitor monitor) throws CoreException {
        byte[] buffer = new byte[8192];
        SubMonitor subMonitor = SubMonitor.convert(monitor, length >= 0L ? 1 + (int)(length / (long)buffer.length) : 1000);
        try {
            while (true) {
                String msg;
                int bytesRead = -1;
                try {
                    bytesRead = source.read(buffer);
                }
                catch (IOException e) {
                    msg = NLS.bind(Messages.failedReadDuringWrite, path);
                    Policy.error(271, msg, e);
                }
                try {
                    if (bytesRead == -1) {
                        destination.close();
                        break;
                    }
                    destination.write(buffer, 0, bytesRead);
                }
                catch (IOException e) {
                    msg = NLS.bind(Messages.couldNotWrite, path);
                    Policy.error(272, msg, e);
                }
                subMonitor.worked(1);
            }
        }
        finally {
            Policy.safeClose(source);
            Policy.safeClose(destination);
        }
    }

    @Override
    public IFileInfo[] childInfos(int options, IProgressMonitor monitor) throws CoreException {
        IFileStore[] childStores = this.childStores(options, monitor);
        IFileInfo[] childInfos = new IFileInfo[childStores.length];
        int i2 = 0;
        while (i2 < childStores.length) {
            childInfos[i2] = childStores[i2].fetchInfo();
            ++i2;
        }
        return childInfos;
    }

    @Override
    public abstract String[] childNames(int var1, IProgressMonitor var2) throws CoreException;

    @Override
    public IFileStore[] childStores(int options, IProgressMonitor monitor) throws CoreException {
        String[] children = this.childNames(options, monitor);
        IFileStore[] wrapped = new IFileStore[children.length];
        int i2 = 0;
        while (i2 < wrapped.length) {
            wrapped[i2] = this.getChild(children[i2]);
            ++i2;
        }
        return wrapped;
    }

    @Override
    public void copy(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        IFileInfo sourceInfo = this.fetchInfo(0, null);
        if (sourceInfo.isDirectory()) {
            this.copyDirectory(sourceInfo, destination, options, monitor);
        } else {
            this.copyFile(sourceInfo, destination, options, monitor);
        }
    }

    protected void copyDirectory(IFileInfo sourceInfo, IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        IFileStore[] children = null;
        int opWork = 1;
        if ((options & 4) == 0) {
            children = this.childStores(0, null);
            opWork += children.length;
        }
        SubMonitor subMonitor = SubMonitor.convert(monitor, opWork);
        subMonitor.subTask(NLS.bind(Messages.copying, this.toString()));
        destination.mkdir(0, subMonitor.newChild(1));
        this.transferAttributes(sourceInfo, destination);
        if (children == null) {
            return;
        }
        IFileStore[] iFileStoreArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore c = iFileStoreArray[n2];
            c.copy(destination.getChild(c.getName()), options, subMonitor.newChild(1));
            ++n2;
        }
    }

    protected void copyFile(IFileInfo sourceInfo, IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        if ((options & 2) == 0 && destination.fetchInfo().exists()) {
            Policy.error(268, NLS.bind(Messages.fileExists, destination));
        }
        long length = sourceInfo.getLength();
        String sourcePath = this.toString();
        SubMonitor subMonitor = SubMonitor.convert(monitor, NLS.bind(Messages.copying, sourcePath), 100);
        InputStream in = null;
        OutputStream out = null;
        try {
            in = this.openInputStream(0, subMonitor.newChild(1));
            out = destination.openOutputStream(0, subMonitor.newChild(1));
            FileStore.transferStreams(in, out, length, sourcePath, subMonitor.newChild(98));
            this.transferAttributes(sourceInfo, destination);
        }
        catch (CoreException e) {
            Policy.safeClose(in);
            Policy.safeClose(out);
            if (!destination.fetchInfo(0, null).exists()) {
                destination.delete(0, null);
            }
            throw e;
        }
    }

    @Override
    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        Policy.error(273, NLS.bind(Messages.noImplDelete, this.toString()));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileStore)) {
            return false;
        }
        return this.toURI().equals(((FileStore)obj).toURI());
    }

    @Override
    public IFileInfo fetchInfo() {
        try {
            return this.fetchInfo(0, null);
        }
        catch (CoreException coreException) {
            FileInfo result = new FileInfo(this.getName());
            result.setExists(false);
            return result;
        }
    }

    @Override
    public abstract IFileInfo fetchInfo(int var1, IProgressMonitor var2) throws CoreException;

    @Override
    @Deprecated
    public IFileStore getChild(IPath path) {
        IFileStore result = this;
        int i2 = 0;
        int imax = path.segmentCount();
        while (i2 < imax) {
            result = result.getChild(path.segment(i2));
            ++i2;
        }
        return result;
    }

    @Override
    public IFileStore getFileStore(IPath path) {
        IFileStore result = this;
        String segment = null;
        int i2 = 0;
        int imax = path.segmentCount();
        while (i2 < imax) {
            segment = path.segment(i2);
            if (!segment.equals(".")) {
                result = segment.equals("..") && result.getParent() != null ? result.getParent() : result.getChild(segment);
            }
            ++i2;
        }
        return result;
    }

    @Override
    public abstract IFileStore getChild(String var1);

    @Override
    public IFileSystem getFileSystem() {
        try {
            return EFS.getFileSystem(this.toURI().getScheme());
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public abstract String getName();

    @Override
    public abstract IFileStore getParent();

    public int hashCode() {
        return this.toURI().hashCode();
    }

    @Override
    public boolean isParentOf(IFileStore other) {
        do {
            if ((other = other.getParent()) != null) continue;
            return false;
        } while (!this.equals(other));
        return true;
    }

    @Override
    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        Policy.error(272, NLS.bind(Messages.noImplWrite, this.toString()));
        return null;
    }

    @Override
    public void move(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        try {
            SubMonitor subMonitor = SubMonitor.convert(monitor, NLS.bind(Messages.moving, destination.toString()), 100);
            this.copy(destination, options & 2, subMonitor.newChild(70));
            this.delete(0, subMonitor.newChild(30));
        }
        catch (CoreException e) {
            String message = NLS.bind(Messages.couldNotMove, this.toString());
            Policy.error(272, message, e);
        }
    }

    @Override
    public abstract InputStream openInputStream(int var1, IProgressMonitor var2) throws CoreException;

    @Override
    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        Policy.error(272, NLS.bind(Messages.noImplWrite, this.toString()));
        return null;
    }

    @Override
    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        Policy.error(272, NLS.bind(Messages.noImplWrite, this.toString()));
    }

    @Override
    public File toLocalFile(int options, IProgressMonitor monitor) throws CoreException {
        if (options != 4096) {
            return null;
        }
        return FileCache.getCache().cache(this, monitor);
    }

    @Override
    public String toString() {
        return this.toURI().toString();
    }

    @Override
    public abstract URI toURI();

    private void transferAttributes(IFileInfo sourceInfo, IFileStore destination) throws CoreException {
        int options = 3072;
        destination.putInfo(sourceInfo, options, null);
    }
}

