/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.expressions;

import org.w3c.dom.Element;
import paper.libs.org.eclipse.core.expressions.EvaluationResult;
import paper.libs.org.eclipse.core.expressions.Expression;
import paper.libs.org.eclipse.core.expressions.ExpressionInfo;
import paper.libs.org.eclipse.core.expressions.IEvaluationContext;
import paper.libs.org.eclipse.core.internal.expressions.Expressions;
import paper.libs.org.eclipse.core.runtime.Assert;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.IConfigurationElement;

public class EqualsExpression
extends Expression {
    private static final int HASH_INITIAL = EqualsExpression.class.getName().hashCode();
    private Object fExpectedValue;

    public EqualsExpression(Object expectedValue) {
        Assert.isNotNull(expectedValue);
        this.fExpectedValue = expectedValue;
    }

    public EqualsExpression(IConfigurationElement element) throws CoreException {
        String value = element.getAttribute("value");
        Expressions.checkAttribute("value", value);
        this.fExpectedValue = Expressions.convertArgument(value);
    }

    public EqualsExpression(Element element) throws CoreException {
        String value = element.getAttribute("value");
        Expressions.checkAttribute("value", value.isEmpty() ? null : value);
        this.fExpectedValue = Expressions.convertArgument(value);
    }

    @Override
    public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
        Object element = context.getDefaultVariable();
        return EvaluationResult.valueOf(element.equals(this.fExpectedValue));
    }

    @Override
    public void collectExpressionInfo(ExpressionInfo info) {
        info.markDefaultVariableAccessed();
    }

    public boolean equals(Object object) {
        if (!(object instanceof EqualsExpression)) {
            return false;
        }
        EqualsExpression that = (EqualsExpression)object;
        return this.fExpectedValue.equals(that.fExpectedValue);
    }

    @Override
    protected int computeHashCode() {
        return HASH_INITIAL * 89 + this.fExpectedValue.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append(" [expected=");
        builder.append(this.fExpectedValue);
        builder.append("]");
        return builder.toString();
    }
}

